/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.block.jareffects;

import com.toadstoolstudios.lilwings.block.ButterflyJarBlockEntity;
import com.toadstoolstudios.lilwings.block.jareffects.JarEffect;
import com.toadstoolstudios.lilwings.registry.LilWingsParticles;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class CrystalpuffJarEffect
implements JarEffect {
    private static final int MAX_TIME = 100;
    private static final int MAX_GROW_TIME = 100;
    private int growTime;
    private int lastParticle;
    List<BlockPos> amethystArea = (List)Util.m_137537_(() -> {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        for (BlockPos pos : BlockPos.m_121976_((int)-3, (int)-2, (int)-3, (int)3, (int)5, (int)3)) {
            list.add(pos.m_7949_());
        }
        return list;
    });
    private BlockPos crystalPos;
    private int checkCooldown;

    @Override
    public void tickEffect(Level level, ButterflyJarBlockEntity blockEntity) {
        if (level.m_5776_()) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        if (this.crystalPos == null) {
            ++this.checkCooldown;
            if (this.checkCooldown >= 100) {
                this.crystalPos = this.findNearestCrystal(level, blockEntity.m_58899_());
                this.checkCooldown = 0;
            }
        } else {
            BlockState state;
            ++this.growTime;
            ++this.lastParticle;
            if (this.lastParticle >= 10) {
                this.spawnParticle(serverLevel, this.crystalPos, 0.5, 0.2f, 0.5);
                this.spawnParticle(serverLevel, this.crystalPos, 0.5, 0.2f, 0.5);
                this.spawnParticle(serverLevel, this.crystalPos, 0.5, 0.2f, 0.5);
                this.lastParticle = 0;
            }
            if ((state = level.m_8055_(this.crystalPos)).m_60713_(Blocks.f_152495_)) {
                this.checkAndGrow(level, Blocks.f_152494_);
            } else if (state.m_60713_(Blocks.f_152494_)) {
                this.checkAndGrow(level, Blocks.f_152493_);
            } else if (state.m_60713_(Blocks.f_152493_)) {
                this.checkAndGrow(level, Blocks.f_152492_);
            } else {
                this.crystalPos = null;
                this.growTime = 0;
            }
        }
    }

    public void checkAndGrow(Level level, Block targetBlock) {
        if (this.growTime >= 100) {
            level.m_7731_(this.crystalPos, targetBlock.m_152465_(level.m_8055_(this.crystalPos)), 3);
            this.growTime = 0;
            this.crystalPos = null;
        }
    }

    @Override
    public ParticleOptions getParticleType() {
        return (ParticleOptions)LilWingsParticles.AMETHYST_GROW.get();
    }

    public BlockPos findNearestCrystal(Level level, BlockPos jarPos) {
        for (BlockPos pos : this.amethystArea) {
            BlockPos relativePos = jarPos.m_141952_((Vec3i)pos);
            BlockState state = level.m_8055_(relativePos);
            if (state.m_60795_() || !state.m_60713_(Blocks.f_152495_) && !state.m_60713_(Blocks.f_152494_) && !state.m_60713_(Blocks.f_152493_)) continue;
            return relativePos;
        }
        return null;
    }
}

