/*
 * Decompiled with CFR 0.152.
 */
package com.toadstoolstudios.lilwings.block;

import com.toadstoolstudios.lilwings.block.jareffects.JarEffect;
import com.toadstoolstudios.lilwings.entity.ButterflyEntity;
import com.toadstoolstudios.lilwings.registry.LilWingsBlocks;
import com.toadstoolstudios.lilwings.registry.entity.Butterfly;
import com.toadstoolstudios.lilwings.registry.entity.GraylingType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class ButterflyJarBlockEntity
extends BlockEntity {
    private ButterflyEntity renderEntity;
    private EntityType<? extends ButterflyEntity> entityType;
    private CompoundTag butterflyData;
    private JarEffect jarEffect;
    private GraylingType colorType;

    public ButterflyJarBlockEntity(BlockPos pWorldPosition, BlockState pBlockState) {
        super(LilWingsBlocks.BUTTERFLY_JAR_ENTITY.get(), pWorldPosition, pBlockState);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.entityType != null) {
            tag.m_128359_("entityId", EntityType.m_20613_(this.entityType).toString());
        }
        if (this.butterflyData != null) {
            tag.m_128365_("butterfly", (Tag)this.butterflyData);
        }
    }

    public void m_142466_(CompoundTag tag) {
        ResourceLocation id;
        super.m_142466_(tag);
        if (tag.m_128425_("entityId", 8) && Butterfly.BUTTERFLIES.containsKey(id = new ResourceLocation(tag.m_128461_("entityId")))) {
            this.entityType = (EntityType)EntityType.m_20632_((String)tag.m_128461_("entityId")).get();
            Butterfly butterfly = Butterfly.getButterfly(this.entityType);
            if (this.jarEffect == null && butterfly.jarEffect() != null) {
                this.jarEffect = butterfly.jarEffect().get();
            }
        }
        if (tag.m_128441_("butterfly")) {
            this.butterflyData = tag.m_128469_("butterfly");
        }
    }

    public static void tick(Level level, BlockPos pos, BlockState state, ButterflyJarBlockEntity blockEntity) {
        if (blockEntity.getJarEffect() != null) {
            blockEntity.getJarEffect().tickEffect(level, blockEntity);
        }
    }

    public void setEntityType(EntityType<? extends ButterflyEntity> entityType) {
        if (entityType != null) {
            Butterfly butterfly = Butterfly.getButterfly(entityType);
            this.entityType = entityType;
            if (butterfly.jarEffect() != null) {
                this.jarEffect = butterfly.jarEffect().get();
            }
            this.m_6596_();
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        } else {
            this.entityType = null;
            this.jarEffect = null;
        }
    }

    public void setButterflyData(CompoundTag tag) {
        this.butterflyData = tag;
        if (tag != null && tag.m_128441_("colorType")) {
            this.colorType = GraylingType.valueOf(tag.m_128461_("colorType"));
        }
        this.m_6596_();
        this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
    }

    @Nullable
    public EntityType<? extends ButterflyEntity> getEntityType() {
        return this.entityType;
    }

    public CompoundTag getButterflyData() {
        return this.butterflyData;
    }

    public JarEffect getJarEffect() {
        return this.jarEffect;
    }

    public GraylingType getColorType() {
        return this.colorType;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket toUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public ButterflyEntity getOrCreateEntity(Level world) {
        if (this.renderEntity == null && this.getEntityType() != null) {
            GraylingType color;
            this.renderEntity = new ButterflyEntity(this.getEntityType(), world, true);
            this.renderEntity.m_20258_(this.butterflyData);
            this.renderEntity.m_20343_(0.0, 0.0, 0.0);
            this.renderEntity.m_5618_(0.0f);
            this.renderEntity.m_146926_(0.0f);
            if (this.butterflyData != null && this.butterflyData.m_128441_("colorType") && (color = GraylingType.valueOf(this.butterflyData.m_128461_("colorType"))) != this.renderEntity.getColorType()) {
                this.renderEntity.setColorType(color);
            }
        }
        return this.renderEntity;
    }

    public void removeButterfly() {
        this.renderEntity = null;
    }
}

