/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.forge;

import com.mojang.datafixers.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibRegistry;
import net.cristellib.StructureConfig;
import net.cristellib.Util;
import net.cristellib.api.CristelLibAPI;
import net.cristellib.data.ReadData;
import net.cristellib.forge.extraapiutil.APIFinder;
import net.cristellib.forge.extrapackutil.ModResourcePack;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.forgespi.language.IModFileInfo;
import net.minecraftforge.forgespi.language.IModInfo;

public class CristelLibExpectPlatformImpl {
    public static Path getConfigDirectory() {
        return FMLPaths.CONFIGDIR.get();
    }

    @Nullable
    public static Path getResourceDirectory(String modid, String subPath) {
        IModFileInfo container = ModList.get().getModFileById(modid);
        if (container != null) {
            Path path = container.getFile().findResource(new String[]{subPath});
            if (path == null) {
                CristelLib.LOGGER.warn("Path for subPath: " + subPath + " in modId: " + modid + " is null");
            }
            return path;
        }
        CristelLib.LOGGER.warn("Mod container for modId:" + modid + " is null");
        return null;
    }

    public static Map<String, Set<StructureConfig>> getConfigs(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> configs = new HashMap<String, Set<StructureConfig>>();
        List<Pair<List<String>, CristelLibAPI>> apis = APIFinder.scanForAPIs();
        for (Pair<List<String>, CristelLibAPI> apiPair : apis) {
            CristelLibAPI api = (CristelLibAPI)apiPair.getSecond();
            List modIds = (List)apiPair.getFirst();
            HashSet<StructureConfig> set = new HashSet<StructureConfig>();
            api.registerConfigs(set);
            configs.put((String)modIds.get(0), set);
            api.registerStructureSets(registry);
        }
        Util.addAll(configs, CristelLibExpectPlatformImpl.data(registry));
        return configs;
    }

    public static Map<String, Set<StructureConfig>> data(CristelLibRegistry registry) {
        HashMap<String, Set<StructureConfig>> modidAndConfigs = new HashMap<String, Set<StructureConfig>>();
        for (IModInfo container : ModList.get().getMods()) {
            String modid = container.getModId();
            ReadData.getBuiltInPacks(modid);
            ReadData.copyFile(modid);
            ReadData.getStructureConfigs(modid, modidAndConfigs, registry);
        }
        return modidAndConfigs;
    }

    public static List<Path> getRootPaths(String modId) {
        ModContainer container = ModList.get().getModContainerById(modId).orElse(null);
        List<Path> paths = new ArrayList<Path>();
        if (container != null) {
            paths = Collections.singletonList(container.getModInfo().getOwningFile().getFile().getSecureJar().getRootPath());
        }
        return paths;
    }

    public static boolean isModLoaded(String modId) {
        return ModList.get().isLoaded(modId);
    }

    @Nullable
    public static AbstractPackResources createPack(String name, String subPath, String modId) {
        ModContainer container = ModList.get().getModContainerById(modId).orElse(null);
        if (container != null) {
            ModResourcePack pack = ModResourcePack.create(name, container.getModInfo(), subPath);
            return pack;
        }
        CristelLib.LOGGER.warn("Couldn't get mod container for modid: " + modId);
        return null;
    }
}

