/*
 * Decompiled with CFR 0.152.
 */
package net.cristellib.builtinpacks;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.cristellib.CristelLib;
import net.cristellib.CristelLibExpectPlatform;
import net.cristellib.builtinpacks.PackWithoutConstructor;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.util.Tuple;

public class BuiltInDataPacks {
    private static List<Tuple<Tuple<String, PackResources>, Supplier<Boolean>>> list = new ArrayList<Tuple<Tuple<String, PackResources>, Supplier<Boolean>>>();

    public static void registerAlwaysOnPack(String name, String subPath, String modid) {
        BuiltInDataPacks.registerPack(name, subPath, modid, () -> true);
    }

    public static void registerPack(String name, String subPath, String modid, Supplier<Boolean> supplier) {
        list.add((Tuple<Tuple<String, PackResources>, Supplier<Boolean>>)new Tuple((Object)new Tuple((Object)name, (Object)CristelLibExpectPlatform.createPack(name, subPath, modid)), supplier));
    }

    public static void registerPack(String name, PackResources packResource, Supplier<Boolean> supplier) {
        list.add((Tuple<Tuple<String, PackResources>, Supplier<Boolean>>)new Tuple((Object)new Tuple((Object)name, (Object)packResource), supplier));
    }

    public static void getPacks(Consumer<Pack> consumer) {
        if (list.isEmpty()) {
            return;
        }
        for (Tuple<Tuple<String, PackResources>, Supplier<Boolean>> entry : list) {
            if (!((Boolean)((Supplier)entry.m_14419_()).get()).booleanValue()) continue;
            PackResources pack = (PackResources)((Tuple)entry.m_14418_()).m_14419_();
            String displayName = (String)((Tuple)entry.m_14418_()).m_14418_();
            if (pack == null) {
                CristelLib.LOGGER.error("Pack for " + displayName + " is null");
                continue;
            }
            if (!pack.m_5698_(PackType.SERVER_DATA).isEmpty()) {
                PackWithoutConstructor resourcePackProfile = PackWithoutConstructor.of(pack);
                if (resourcePackProfile != null) {
                    consumer.accept(resourcePackProfile);
                    continue;
                }
                CristelLib.LOGGER.error(pack + " couldn't be created");
                continue;
            }
            CristelLib.LOGGER.debug(pack + " has no data");
        }
    }
}

