/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.patreon;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import java.util.function.Function;
import net.minecraft.client.KeyMapping;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import shadows.placebo.patreon.wings.IWingModel;
import shadows.placebo.patreon.wings.Wing;

public class PatreonUtils {
    public static final KeyMapping TOGGLE_T = new KeyMapping("placebo.toggleTrails", 328, "key.categories.placebo");
    public static final KeyMapping TOGGLE_W = new KeyMapping("placebo.toggleWings", 329, "key.categories.placebo");

    private static Function<Player, ResourceLocation> wingTex(String name) {
        Supplier supp = Suppliers.memoize(() -> new ResourceLocation("placebo", "textures/wings/" + name + ".png"));
        return player -> (ResourceLocation)supp.get();
    }

    public static enum WingType {
        ANGEL(() -> Wing.INSTANCE, PatreonUtils.wingTex("angel"), -0.5),
        ARMORED(() -> Wing.INSTANCE, PatreonUtils.wingTex("armored"), -0.7),
        BAT(() -> Wing.INSTANCE, PatreonUtils.wingTex("bat"), -0.7),
        BLAZE(() -> Wing.INSTANCE, PatreonUtils.wingTex("blaze"), -0.73),
        BONE(() -> Wing.INSTANCE, PatreonUtils.wingTex("bone"), -1.0),
        CLOUD(() -> Wing.INSTANCE, PatreonUtils.wingTex("cloud"), -1.0),
        DEMON(() -> Wing.INSTANCE, PatreonUtils.wingTex("demon"), -0.55),
        FAIRY(() -> Wing.INSTANCE, PatreonUtils.wingTex("fairy"), -0.85),
        FLY(() -> Wing.INSTANCE, PatreonUtils.wingTex("fly"), -0.58, 6.0),
        MECHANICAL(() -> Wing.INSTANCE, PatreonUtils.wingTex("mechanical"), -0.75),
        MONARCH(() -> Wing.INSTANCE, PatreonUtils.wingTex("monarch"), -0.85),
        PIXIE(() -> Wing.INSTANCE, PatreonUtils.wingTex("pixie"), -0.65),
        SPOOKY(() -> Wing.INSTANCE, PatreonUtils.wingTex("spooky"), -0.65);

        public final java.util.function.Supplier<IWingModel> model;
        public final Function<Player, ResourceLocation> textureGetter;
        public final double yOffset;
        public final double flapSpeed;

        private WingType(java.util.function.Supplier<IWingModel> model, Function<Player, ResourceLocation> textureGetter, double yOffset) {
            this(model, textureGetter, yOffset, 1.0);
        }

        private WingType(java.util.function.Supplier<IWingModel> model, Function<Player, ResourceLocation> textureGetter, double yOffset, double flapSpeed) {
            this.model = model;
            this.textureGetter = textureGetter;
            this.yOffset = yOffset;
            this.flapSpeed = flapSpeed;
        }
    }

    public static enum PatreonParticleType {
        ASH(() -> ParticleTypes.f_123783_),
        CAMPFIRE_SMOKE(() -> ParticleTypes.f_123777_),
        CLOUD(() -> ParticleTypes.f_123796_),
        DMG_HEART(() -> ParticleTypes.f_123798_),
        DRAGON_BREATH(() -> ParticleTypes.f_123799_),
        ELECTRIC_SPARK(() -> ParticleTypes.f_175830_),
        END_ROD(() -> ParticleTypes.f_123810_),
        FIRE(() -> ParticleTypes.f_123744_),
        FIREWORK(() -> ParticleTypes.f_123815_),
        GLOW(() -> ParticleTypes.f_175827_),
        GROWTH(() -> ParticleTypes.f_123748_),
        HEART(() -> ParticleTypes.f_123750_),
        SLIME(() -> ParticleTypes.f_123753_),
        SNOW(() -> ParticleTypes.f_123754_),
        SOUL(() -> ParticleTypes.f_123746_),
        SOUL_FIRE(() -> ParticleTypes.f_123745_),
        WITCH(() -> ParticleTypes.f_123771_);

        public final java.util.function.Supplier<ParticleOptions> type;

        private PatreonParticleType(java.util.function.Supplier<ParticleOptions> type) {
            this.type = type;
        }
    }
}

