/*
 * Decompiled with CFR 0.152.
 */
package shadows.placebo.json;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraftforge.registries.ForgeRegistries;
import shadows.placebo.Placebo;
import shadows.placebo.util.StepFunction;

public class RandomAttributeModifier {
    protected final Attribute attribute;
    protected final AttributeModifier.Operation op;
    protected final StepFunction value;
    protected final UUID id;

    public RandomAttributeModifier(Attribute attribute, AttributeModifier.Operation op, StepFunction value) {
        this.attribute = attribute;
        this.op = op;
        this.value = value;
        Random rand = new Random();
        rand.setSeed(Objects.hash(attribute, op, value));
        this.id = new UUID(rand.nextLong(), rand.nextLong());
    }

    public void apply(Random rand, LivingEntity entity) {
        if (entity == null) {
            throw new RuntimeException("Attempted to apply a random attribute modifier to a null entity!");
        }
        AttributeModifier modif = this.genModifier(rand);
        AttributeInstance inst = entity.m_21051_(this.attribute);
        if (inst == null) {
            Placebo.LOGGER.trace(String.format("Attempted to apply a random attribute modifier to an entity (%s) that does not have that attribute (%s)!", entity.m_6095_().getRegistryName(), this.attribute.getRegistryName()));
            return;
        }
        inst.m_22125_(modif);
    }

    public AttributeModifier genModifier(Random rand) {
        return new AttributeModifier(this.id, "placebo_random_modifier_" + this.attribute.m_22087_(), (double)this.value.get(rand.nextFloat()), this.op);
    }

    public AttributeModifier genModifier(String name, Random rand) {
        return new AttributeModifier(name, (double)this.value.get(rand.nextFloat()), this.op);
    }

    public Attribute getAttribute() {
        return this.attribute;
    }

    public AttributeModifier.Operation getOp() {
        return this.op;
    }

    public StepFunction getValue() {
        return this.value;
    }

    public static class Deserializer
    implements JsonDeserializer<RandomAttributeModifier>,
    JsonSerializer<RandomAttributeModifier> {
        public RandomAttributeModifier deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext ctx) throws JsonParseException {
            StepFunction value;
            JsonObject obj = json.getAsJsonObject();
            String _attribute = obj.get("attribute").getAsString();
            AttributeModifier.Operation op = (AttributeModifier.Operation)ctx.deserialize(obj.get("operation"), AttributeModifier.Operation.class);
            if (obj.get("value").isJsonObject()) {
                JsonObject valueObj = GsonHelper.m_13930_((JsonObject)obj, (String)"value");
                value = (StepFunction)ctx.deserialize((JsonElement)valueObj, StepFunction.class);
            } else {
                float v = GsonHelper.m_13915_((JsonObject)obj, (String)"value");
                value = new StepFunction(v, 1, 0.0f);
            }
            Attribute attribute = (Attribute)ForgeRegistries.ATTRIBUTES.getValue(new ResourceLocation(_attribute));
            if (attribute == null || value == null || op == null) {
                throw new JsonParseException("Attempted to deserialize invalid RandomAttributeModifier: " + json.toString());
            }
            return new RandomAttributeModifier(attribute, op, value);
        }

        public JsonElement serialize(RandomAttributeModifier src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject obj = new JsonObject();
            obj.addProperty("attribute", src.attribute.getRegistryName().toString());
            obj.addProperty("operation", src.op.name());
            StepFunction range = src.value;
            if (range.min() == range.max()) {
                obj.addProperty("value", (Number)Float.valueOf(range.min()));
            } else {
                obj.add("value", context.serialize((Object)src.value));
            }
            return obj;
        }
    }
}

