/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.mimic.events;

import ca.lukegrahamlandry.mimic.Constants;
import ca.lukegrahamlandry.mimic.entities.MimicEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class TickHandler {
    public static List<MimicSpawnData> spawns = new ArrayList<MimicSpawnData>();

    public static void onServerTick() {
        for (MimicSpawnData spawn : spawns) {
            --spawn.time;
            if (spawn.time > 0) continue;
            TickHandler.spawnMimic(spawn);
            spawns.remove(spawn);
            return;
        }
    }

    private static void spawnMimic(MimicSpawnData spawn) {
        BlockState state = spawn.world.m_8055_(spawn.pos);
        if (state.m_60713_(Blocks.f_50087_)) {
            ChestBlockEntity chest = (ChestBlockEntity)spawn.world.m_7702_(spawn.pos);
            MimicEntity mimic = (MimicEntity)((EntityType)Registry.f_122826_.m_7745_(Constants.MIMIC_ENTITY_ID)).m_20615_(spawn.world);
            for (int i = 0; i < chest.m_6643_(); ++i) {
                mimic.addItem(chest.m_8020_(i));
                chest.m_6836_(i, ItemStack.f_41583_);
            }
            spawn.world.m_7731_(spawn.pos, Blocks.f_50016_.m_49966_(), 3);
            mimic.snapToBlock(spawn.pos, (Direction)state.m_61143_((Property)ChestBlock.f_51478_));
            mimic.setStealth(true);
            spawn.world.m_7967_((Entity)mimic);
        }
    }

    public static class MimicSpawnData {
        public final BlockPos pos;
        public int time;
        public final Level world;

        public MimicSpawnData(Level level, BlockPos position) {
            this.pos = position;
            this.time = 40;
            this.world = level;
        }
    }
}

