/*
 * Decompiled with CFR 0.152.
 */
package ca.lukegrahamlandry.mimic.entities;

import ca.lukegrahamlandry.mimic.Constants;
import ca.lukegrahamlandry.mimic.client.MimicContainer;
import ca.lukegrahamlandry.mimic.goals.EatChestGoal;
import ca.lukegrahamlandry.mimic.goals.FindChestGoal;
import ca.lukegrahamlandry.mimic.goals.LockedPanicGoal;
import ca.lukegrahamlandry.mimic.goals.MimicAttackGoal;
import ca.lukegrahamlandry.mimic.goals.MimicChaseGoal;
import ca.lukegrahamlandry.mimic.goals.MimicWanderGoal;
import ca.lukegrahamlandry.mimic.goals.TamedFollowGoal;
import com.mojang.datafixers.util.Pair;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;

public class MimicEntity
extends PathfinderMob
implements MenuProvider,
Container {
    private static final EntityDataAccessor<Boolean> IS_TAMED = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_STEALTH = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_LOCKED = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> IS_ANGRY = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> ATTACK_TICK = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> UP_DOWN_TICK = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> IS_OPEN = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> OPEN_CLOSE_TICK = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> FACING_DIRECTION = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private UUID owner;
    int playerLookTicks = 0;
    Player playerLooking;
    int scaredTicks = 0;
    boolean hasAlreadyGeneratedLoot = false;
    private NonNullList<ItemStack> heldItems = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private static final int boredOfWanderingChance = 2400;

    public MimicEntity(EntityType<? extends MimicEntity> type, Level world) {
        super(type, world);
    }

    public static AttributeSupplier.Builder createMobAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22281_, 14.0).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22279_, 0.55).m_22268_(Attributes.f_22277_, 32.0);
    }

    protected void m_8099_() {
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21345_.m_25352_(2, (Goal)new MimicChaseGoal(this, 0.6, 10));
        this.f_21345_.m_25352_(2, (Goal)new MimicAttackGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new EatChestGoal(this));
        this.f_21345_.m_25352_(3, (Goal)new FindChestGoal(this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new LockedPanicGoal(this, 0.6));
        this.f_21345_.m_25352_(6, (Goal)new TamedFollowGoal(this, 0.75, 8.0f, 2.0f, false));
        this.f_21345_.m_25352_(7, (Goal)new MimicWanderGoal(this, 0.5));
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.f_19853_.m_5776_()) {
            if (this.getAttackTick() > 0) {
                this.m_20088_().m_135381_(ATTACK_TICK, (Object)(this.getAttackTick() - 1));
            }
            if ((Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
                this.m_20088_().m_135381_(UP_DOWN_TICK, (Object)((Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) - 1));
            }
            if ((Integer)this.m_20088_().m_135370_(OPEN_CLOSE_TICK) > 0) {
                this.m_20088_().m_135381_(OPEN_CLOSE_TICK, (Object)((Integer)this.m_20088_().m_135370_(OPEN_CLOSE_TICK) - 1));
            }
            if (this.scaredTicks > 0) {
                --this.scaredTicks;
            }
            if (this.playerLookTicks > 0) {
                --this.playerLookTicks;
                if (this.playerLookTicks == 0 && !this.isLocked() && !this.isTamed()) {
                    ((ServerPlayer)this.playerLooking).m_6915_();
                    this.setAngry(true);
                    float strength = 1.0f;
                    this.playerLooking.m_147240_((double)(strength * 0.5f), (double)Mth.m_14031_((float)(this.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(this.m_146908_() * ((float)Math.PI / 180)))));
                }
            }
            if (!(this.isAngry() || this.isStealth() || this.isTamed() || this.m_21187_().nextInt(2400) != 0)) {
                this.snapToBlock(this.m_142538_(), Direction.m_122407_((int)Math.floorDiv((int)this.f_20883_, 90)));
                this.setStealth(true);
            }
            if (!(this.isAngry() || this.isStealth() || this.isTamed() || this.isLocked() || this.m_21187_().nextInt(5) != 0)) {
                AABB box = this.m_142469_().m_82400_(10.0);
                for (Player playerentity : this.f_19853_.m_6907_()) {
                    if (playerentity.m_7500_() || !box.m_82393_(playerentity.m_20185_(), playerentity.m_20186_(), playerentity.m_20189_())) continue;
                    this.snapToBlock(this.m_142538_(), null);
                    this.setStealth(true);
                }
            }
            if (this.m_5830_() && this.isStealth()) {
                this.m_6034_(this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_());
            }
        }
    }

    public void snapToBlock(BlockPos pos, @Nullable Direction dir) {
        if (dir == null) {
            dir = Direction.m_122407_((int)this.m_21187_().nextInt(4));
        }
        this.m_7678_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5, dir.m_122416_() * 90, 0.0f);
        this.m_5618_(dir.m_122416_() * 90);
        this.m_21573_().m_26536_((Path)null, 0.0);
    }

    public Pair<String, Boolean> animationPredicate(float limbSwingAmount) {
        if (this.getAttackTick() > 0) {
            return Pair.of((Object)"animation.mimic.attack", (Object)false);
        }
        if (this.isOpen()) {
            if (this.isLocked()) {
                return Pair.of((Object)"animation.locked.mimic.chest.open", (Object)false);
            }
            return Pair.of((Object)"animation.mimic.chest.open", (Object)false);
        }
        if ((Integer)this.m_20088_().m_135370_(OPEN_CLOSE_TICK) > 0) {
            if (this.isLocked()) {
                return Pair.of((Object)"animation.locked.mimic.chest.close", (Object)false);
            }
            return Pair.of((Object)"animation.mimic.chest.close", (Object)false);
        }
        if (this.isLocked() && ((Boolean)this.m_20088_().m_135370_(IS_STEALTH)).booleanValue()) {
            if ((Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
                return Pair.of((Object)"animation.mimic.lock", (Object)false);
            }
            return Pair.of((Object)"animation.mimic.lockidle", (Object)true);
        }
        if (this.isLocked() && (Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
            return Pair.of((Object)"animation.locked.mimic.getup", (Object)false);
        }
        if (((Boolean)this.m_20088_().m_135370_(IS_STEALTH)).booleanValue()) {
            if ((Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
                return Pair.of((Object)"animation.mimic.sit", (Object)false);
            }
            return Pair.of((Object)"animation.mimic.idle.chest", (Object)true);
        }
        if ((Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
            return Pair.of((Object)"animation.mimic.getup", (Object)false);
        }
        if (!(limbSwingAmount > -0.15f) || !(limbSwingAmount < 0.15f)) {
            if (this.isLocked()) {
                return Pair.of((Object)"animation.locked.mimic.run", (Object)true);
            }
            if (this.isAngry()) {
                return Pair.of((Object)"animation.mimic.run", (Object)true);
            }
            return Pair.of((Object)"animation.mimic.walkcycle", (Object)true);
        }
        if (this.isLocked()) {
            return Pair.of((Object)"animation.locked.mimic.idle", (Object)true);
        }
        return Pair.of((Object)"animation.mimic.idle", (Object)true);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ATTACK_TICK, (Object)0);
        this.m_20088_().m_135372_(UP_DOWN_TICK, (Object)0);
        this.m_20088_().m_135372_(IS_TAMED, (Object)false);
        this.m_20088_().m_135372_(IS_LOCKED, (Object)false);
        this.m_20088_().m_135372_(IS_ANGRY, (Object)false);
        this.m_20088_().m_135372_(IS_STEALTH, (Object)false);
        this.m_20088_().m_135372_(IS_OPEN, (Object)false);
        this.m_20088_().m_135372_(OPEN_CLOSE_TICK, (Object)0);
        this.m_20088_().m_135372_(FACING_DIRECTION, (Object)-1);
    }

    protected InteractionResult m_6071_(Player player, InteractionHand hand) {
        if (hand == InteractionHand.OFF_HAND) {
            return InteractionResult.PASS;
        }
        if (this.isTamed() && player.m_6144_() && !this.f_19853_.m_5776_()) {
            boolean targetState = !this.isStealth();
            this.setStealth(targetState);
            if (targetState) {
                this.snapToBlock(this.m_142538_(), Direction.m_122407_((int)Math.floorDiv((int)this.f_20883_, 90)));
            }
            return InteractionResult.SUCCESS;
        }
        ItemStack stack = player.m_21120_(hand);
        if (this.canItemLock(stack) && !this.isTamed() && !this.isLocked()) {
            this.setLocked(true);
            this.snapToBlock(this.m_142538_(), Direction.m_122407_((int)Math.floorDiv((int)this.f_20883_, 90)));
            if (!player.m_7500_()) {
                stack.m_41774_(1);
            }
            this.m_21573_().m_26536_((Path)null, 0.0);
            return InteractionResult.CONSUME;
        }
        if (this.canItemTame(stack) && !this.isTamed() && !this.isLocked()) {
            if (!this.f_19853_.m_5776_()) {
                this.setTamed(true);
                this.setStealth(true);
                if (!player.m_7500_()) {
                    stack.m_41774_(1);
                }
                this.owner = player.m_142081_();
                this.m_21573_().m_26536_((Path)null, 0.0);
                for (int i = 0; i < 7; ++i) {
                    ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123750_, this.m_142469_().m_82399_().f_82479_ + (this.f_19796_.nextDouble() * 3.0 - 1.5), this.m_20186_() + 1.0, this.m_142469_().m_82399_().f_82481_ + (this.f_19796_.nextDouble() * 3.0 - 1.5), 1, 0.0, 0.0, 0.0, 1.0);
                }
            }
            return InteractionResult.m_19078_((boolean)this.f_19853_.m_5776_());
        }
        if (this.isStealth() && !player.m_6144_()) {
            if (this.m_7983_()) {
                this.generateDefaultLoot();
            }
            player.m_5893_((MenuProvider)this);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean canItemTame(ItemStack stack) {
        return stack.m_41720_() == Registry.f_122827_.m_7745_(Constants.MIMIC_KEY_ID);
    }

    protected boolean canItemLock(ItemStack stack) {
        return stack.m_41720_() == Registry.f_122827_.m_7745_(Constants.MIMIC_LOCK_ID);
    }

    protected void m_7472_(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        super.m_7472_(p_213333_1_, p_213333_2_, p_213333_3_);
        if (this.m_7983_()) {
            this.generateDefaultLoot();
        }
        for (int i = 0; i < this.heldItems.size(); ++i) {
            if (((ItemStack)this.heldItems.get(i)).m_41720_() == Items.f_41852_) continue;
            this.m_19983_((ItemStack)this.heldItems.get(i));
        }
    }

    public void addItem(ItemStack stack) {
        if (stack.m_41619_()) {
            return;
        }
        this.hasAlreadyGeneratedLoot = true;
        for (int i = 0; i < this.heldItems.size(); ++i) {
            if (((ItemStack)this.heldItems.get(i)).m_41720_() != Items.f_41852_) continue;
            this.heldItems.set(i, (Object)stack);
            this.m_21530_();
            return;
        }
        ItemEntity item = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), stack);
        this.f_19853_.m_7967_((Entity)item);
    }

    private void generateDefaultLoot() {
        if (this.f_19853_.m_5776_() || this.hasAlreadyGeneratedLoot) {
            return;
        }
        ResourceLocation lootLocation = new ResourceLocation("mimic", "default_mimic_loot");
        LootTable loottable = this.f_19853_.m_142572_().m_129898_().m_79217_(lootLocation);
        LootContext.Builder lootcontext$builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78972_(LootContextParams.f_81460_, (Object)this.m_20182_());
        loottable.m_79123_((Container)this, lootcontext$builder.m_78975_(LootContextParamSets.f_81411_));
        this.hasAlreadyGeneratedLoot = true;
    }

    public void m_7380_(CompoundTag compoundNBT) {
        super.m_7380_(compoundNBT);
        CompoundTag nbt = new CompoundTag();
        for (int i = 0; i < this.heldItems.size(); ++i) {
            ItemStack stack = (ItemStack)this.heldItems.get(i);
            CompoundTag tag = stack.m_41739_(new CompoundTag());
            nbt.m_128365_(String.valueOf(i), (Tag)tag);
        }
        compoundNBT.m_128365_("mimichelditems", (Tag)nbt);
        compoundNBT.m_128379_("tame", this.isTamed());
        compoundNBT.m_128379_("lock", this.isLocked());
        compoundNBT.m_128379_("angry", this.isAngry());
        compoundNBT.m_128379_("stealth", this.isStealth());
        compoundNBT.m_128379_("genloot", this.hasAlreadyGeneratedLoot);
        if (this.isTamed()) {
            compoundNBT.m_128359_("owner", this.owner.toString());
        }
    }

    public void m_7378_(CompoundTag compoundNBT) {
        super.m_7378_(compoundNBT);
        CompoundTag nbt = compoundNBT.m_128469_("mimichelditems");
        int i = 0;
        while (nbt.m_128441_(String.valueOf(i))) {
            CompoundTag tag = nbt.m_128469_(String.valueOf(i));
            ItemStack stack = ItemStack.m_41712_((CompoundTag)tag);
            this.heldItems.set(i, (Object)stack);
            ++i;
        }
        this.setTamed(compoundNBT.m_128471_("tame"));
        this.setLocked(compoundNBT.m_128471_("lock"));
        this.setStealth(compoundNBT.m_128471_("stealth"));
        this.setAngry(compoundNBT.m_128471_("angry"));
        this.hasAlreadyGeneratedLoot = compoundNBT.m_128471_("genloot");
        if (this.isTamed()) {
            this.owner = UUID.fromString(compoundNBT.m_128461_("owner"));
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (this.m_6673_(source)) {
            return false;
        }
        if (source.m_7640_() != null && source.m_7640_() instanceof LivingEntity && ((LivingEntity)source.m_7640_()).m_21120_(InteractionHand.MAIN_HAND).m_41720_() instanceof AxeItem) {
            amount *= 2.0f;
        }
        if (!this.f_19853_.m_5776_() && !this.isTamed() && source.m_7639_() != null && source.m_7639_() instanceof Player && !((Player)source.m_7639_()).m_7500_()) {
            this.setAngry(true);
        }
        return super.m_6469_(source, amount);
    }

    public LivingEntity getOwner() {
        if (!this.isTamed() || this.f_19853_.m_5776_()) {
            return null;
        }
        return (LivingEntity)((ServerLevel)this.f_19853_).m_8791_(this.owner);
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6063_() {
        return false;
    }

    public void m_7334_(Entity p_70108_1_) {
    }

    public void m_5997_(double p_70024_1_, double p_70024_3_, double p_70024_5_) {
    }

    public boolean isScared() {
        return this.scaredTicks > 0;
    }

    public boolean isOpen() {
        return (Boolean)this.m_20088_().m_135370_(IS_OPEN);
    }

    public boolean isTamed() {
        return (Boolean)this.m_20088_().m_135370_(IS_TAMED);
    }

    public boolean isAngry() {
        boolean flag = (Boolean)this.m_20088_().m_135370_(IS_ANGRY);
        if (flag && this.isStealth()) {
            return false;
        }
        return flag;
    }

    public boolean isStealth() {
        boolean flag = (Boolean)this.m_20088_().m_135370_(IS_STEALTH);
        if (!flag && (Integer)this.m_20088_().m_135370_(UP_DOWN_TICK) > 0) {
            return true;
        }
        return flag;
    }

    public boolean isLocked() {
        return (Boolean)this.m_20088_().m_135370_(IS_LOCKED);
    }

    public boolean hasTarget() {
        return this.m_5448_() != null && this.m_5448_().m_6084_();
    }

    public int getAttackTick() {
        return (Integer)this.m_20088_().m_135370_(ATTACK_TICK);
    }

    public void startAttackAnim() {
        this.m_20088_().m_135381_(ATTACK_TICK, (Object)20);
    }

    public void setAngry(boolean flag) {
        if (flag) {
            this.setStealth(false);
            if (this.isTamed() || this.isLocked()) {
                return;
            }
        }
        this.m_20088_().m_135381_(IS_ANGRY, (Object)flag);
    }

    public void setStealth(boolean flag) {
        if (!this.isStealth() && flag) {
            this.m_20088_().m_135381_(UP_DOWN_TICK, (Object)20);
        } else if (this.isStealth() && !flag) {
            this.m_20088_().m_135381_(UP_DOWN_TICK, (Object)2);
        }
        this.m_20088_().m_135381_(IS_STEALTH, (Object)flag);
    }

    public void setLocked(boolean flag) {
        if (flag) {
            this.setAngry(false);
            this.setStealth(true);
        }
        if (!this.isLocked() && flag) {
            this.m_20088_().m_135381_(UP_DOWN_TICK, (Object)28);
        }
        this.m_20088_().m_135381_(IS_LOCKED, (Object)flag);
    }

    public void setTamed(boolean flag) {
        if (flag) {
            this.setAngry(false);
        }
        this.m_20088_().m_135381_(IS_TAMED, (Object)flag);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory playerInventory, Player player) {
        if (!this.isTamed()) {
            this.playerLooking = player;
            this.playerLookTicks = 15;
        }
        MenuType menuType = (MenuType)Registry.f_122863_.m_7745_(this.isTamed() ? Constants.TAME_MIMIC_CONTAINER : Constants.EVIL_MIMIC_CONTAINER);
        return new MimicContainer(menuType, id, playerInventory, this, 3);
    }

    protected void m_7355_(BlockPos pos, BlockState state) {
        this.m_5496_(SoundEvents.f_12638_, 0.15f, 1.0f);
    }

    public void m_5785_(Player player) {
        this.m_20088_().m_135381_(OPEN_CLOSE_TICK, (Object)10);
        this.m_20088_().m_135381_(IS_OPEN, (Object)false);
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11747_, SoundSource.BLOCKS, 0.5f, this.f_19796_.nextFloat() * 0.1f + 0.9f);
    }

    public void m_5856_(Player player) {
        this.m_20088_().m_135381_(OPEN_CLOSE_TICK, (Object)13);
        this.m_20088_().m_135381_(IS_OPEN, (Object)true);
        this.f_19853_.m_6263_((Player)null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11749_, SoundSource.BLOCKS, 0.5f, this.f_19796_.nextFloat() * 0.1f + 0.9f);
    }

    public int m_6643_() {
        return 27;
    }

    public boolean m_7983_() {
        return this.heldItems.stream().allMatch(ItemStack::m_41619_);
    }

    public ItemStack m_8020_(int index) {
        return (ItemStack)this.heldItems.get(index);
    }

    private void onTake() {
        this.playerLookTicks = 2;
        if (this.isLocked() && this.m_21187_().nextInt(3) == 0) {
            if (this.playerLooking instanceof ServerPlayer) {
                ((ServerPlayer)this.playerLooking).m_6915_();
            } else if (this.playerLooking instanceof LocalPlayer) {
                ((LocalPlayer)this.playerLooking).m_6915_();
            }
            this.scaredTicks = 400;
            this.setStealth(false);
        }
    }

    public ItemStack m_7407_(int p_70298_1_, int p_70298_2_) {
        ItemStack itemstack = ContainerHelper.m_18969_(this.heldItems, (int)p_70298_1_, (int)p_70298_2_);
        if (!itemstack.m_41619_()) {
            this.m_6596_();
            this.onTake();
        }
        return itemstack;
    }

    public ItemStack m_8016_(int p_70304_1_) {
        ItemStack itemstack = ContainerHelper.m_18966_(this.heldItems, (int)p_70304_1_);
        if (!itemstack.m_41619_()) {
            this.onTake();
        }
        return itemstack;
    }

    public void m_6836_(int index, ItemStack stack) {
        this.heldItems.set(index, (Object)stack);
        if (stack.m_41619_()) {
            this.onTake();
        }
    }

    public void m_6596_() {
    }

    public boolean m_6542_(Player p_70300_1_) {
        return this.m_6084_();
    }

    public void m_6211_() {
        this.heldItems.clear();
    }

    public void consumeChest(BlockPos pos) {
        BlockEntity tile = this.f_19853_.m_7702_(pos);
        if (!(tile instanceof BaseContainerBlockEntity)) {
            System.out.println("mimic failed to eat chest at " + pos);
            return;
        }
        BaseContainerBlockEntity chest = (BaseContainerBlockEntity)tile;
        for (int i = 0; i < chest.m_6643_(); ++i) {
            this.addItem(chest.m_8020_(i));
            chest.m_6836_(i, ItemStack.f_41583_);
        }
        Direction chestFacing = this.f_19853_.m_8055_(pos).m_61145_((Property)ChestBlock.f_51478_).orElse(Direction.NORTH);
        if (chestFacing.m_122434_() == Direction.Axis.Y) {
            chestFacing = Direction.NORTH;
        }
        this.f_19853_.m_7731_(pos, Blocks.f_50016_.m_49966_(), 3);
        this.snapToBlock(pos, chestFacing);
        this.setStealth(true);
    }
}

