/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.content.tools.loot;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.phys.Vec3;
import vazkii.quark.base.handler.MiscUtil;
import vazkii.quark.content.tools.module.PathfinderMapsModule;

public class PathfinderMapFunction
extends LootItemConditionalFunction {
    private final TagKey<Biome> destination;
    private final boolean underground;
    private final int color;

    public PathfinderMapFunction(LootItemCondition[] conditions, TagKey<Biome> destination, boolean underground, int color) {
        super(conditions);
        this.destination = destination;
        this.underground = underground;
        this.color = color;
    }

    @Nonnull
    public LootItemFunctionType m_7162_() {
        return PathfinderMapsModule.pathfinderMapType;
    }

    @Nonnull
    public ItemStack m_7372_(ItemStack stack, @Nonnull LootContext context) {
        if (stack.m_150930_(Items.f_42676_)) {
            Vec3 vec = (Vec3)context.m_165124_(LootContextParams.f_81460_);
            if (this.underground) {
                vec = vec.m_82492_(0.0, vec.f_82480_ + 1.0, 0.0);
            }
            return PathfinderMapsModule.createMap((Level)context.m_78952_(), new BlockPos(vec), it -> it.m_203656_(this.destination), this.color);
        }
        return stack;
    }

    @Nonnull
    public Set<LootContextParam<?>> m_6231_() {
        return ImmutableSet.of((Object)LootContextParams.f_81460_);
    }

    public static class Serializer
    extends LootItemConditionalFunction.Serializer<PathfinderMapFunction> {
        public void serialize(@Nonnull JsonObject object, @Nonnull PathfinderMapFunction function, @Nonnull JsonSerializationContext serializationContext) {
            object.addProperty("destination", function.destination.f_203868_().toString());
            object.addProperty("underground", Boolean.valueOf(function.underground));
            object.addProperty("color", MiscUtil.toColorString(function.color));
        }

        @Nonnull
        public PathfinderMapFunction deserialize(@Nonnull JsonObject object, @Nonnull JsonDeserializationContext deserializationContext, @Nonnull LootItemCondition[] conditionsIn) {
            String key = GsonHelper.m_13906_((JsonObject)object, (String)"destination");
            TagKey destination = TagKey.m_203882_((ResourceKey)Registry.f_122885_, (ResourceLocation)new ResourceLocation(key));
            boolean underground = GsonHelper.m_13912_((JsonObject)object, (String)"underground");
            int color = MiscUtil.getAsColor(object, "color");
            return new PathfinderMapFunction(conditionsIn, (TagKey<Biome>)destination, underground, color);
        }
    }
}

