/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.base.world.generator;

import java.util.Random;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import vazkii.quark.base.module.config.type.DimensionConfig;
import vazkii.quark.base.world.generator.IGenerator;

public abstract class Generator
implements IGenerator {
    public static final BooleanSupplier NO_COND = () -> true;
    public final DimensionConfig dimConfig;
    private final BooleanSupplier condition;

    public Generator(DimensionConfig dimConfig) {
        this(dimConfig, NO_COND);
    }

    public Generator(DimensionConfig dimConfig, BooleanSupplier condition) {
        this.dimConfig = dimConfig;
        this.condition = condition;
    }

    @Override
    public final int generate(int seedIncrement, long seed, GenerationStep.Decoration stage, WorldGenRegion worldIn, ChunkGenerator generator, WorldgenRandom rand, BlockPos pos) {
        rand.m_190064_(seed, seedIncrement, stage.ordinal());
        this.generateChunk(worldIn, generator, (Random)rand, pos);
        return seedIncrement + 1;
    }

    public abstract void generateChunk(WorldGenRegion var1, ChunkGenerator var2, Random var3, BlockPos var4);

    @Override
    public boolean canGenerate(ServerLevelAccessor world) {
        return this.condition.getAsBoolean() && this.dimConfig.canSpawnHere((LevelAccessor)world.m_6018_());
    }

    public Holder<Biome> getBiome(LevelAccessor world, BlockPos pos, boolean offset) {
        BlockPos testPos = offset ? new BlockPos(pos.m_123341_(), world.m_151558_() - 1, pos.m_123343_()) : pos;
        return world.m_7062_().m_204214_(testPos);
    }

    protected boolean isNether(LevelAccessor world) {
        return world.m_6042_().m_63951_();
    }
}

