/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.module;

import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.ForgeModelBakery;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.arl.util.RegistryHelper;
import vazkii.quark.addons.oddities.client.render.entity.TotemOfHoldingRenderer;
import vazkii.quark.addons.oddities.entity.TotemOfHoldingEntity;
import vazkii.quark.addons.oddities.item.SoulCompassItem;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.QuarkModule;
import vazkii.quark.base.module.config.Config;

@LoadModule(category=ModuleCategory.ODDITIES, hasSubscriptions=true)
public class TotemOfHoldingModule
extends QuarkModule {
    private static final String TAG_LAST_TOTEM = "quark:lastTotemOfHolding";
    private static final String TAG_DEATH_X = "quark:deathX";
    private static final String TAG_DEATH_Z = "quark:deathZ";
    private static final String TAG_DEATH_DIM = "quark:deathDim";
    public static EntityType<TotemOfHoldingEntity> totemType;
    public static SoulCompassItem soulCompass;
    public static final ModelResourceLocation MODEL_LOC;
    @Config(description="Set this to false to remove the behaviour where totems destroy themselves if the player dies again.")
    public static boolean darkSoulsMode;
    @Config(name="Spawn Totem on PVP Kill", description="Totem will always spawn if the player killer is himself.")
    public static boolean enableOnPK;
    @Config(description="Set this to true to make it so that if a totem is destroyed, the items it holds are destroyed alongside it rather than dropped")
    public static boolean destroyLostItems;
    @Config(description="Set this to false to only allow the owner of a totem to collect its items rather than any player")
    public static boolean allowAnyoneToCollect;
    @Config(flag="soul_compass")
    public static boolean enableSoulCompass;

    @Override
    public void register() {
        soulCompass = new SoulCompassItem(this);
        soulCompass.setCondition(() -> enableSoulCompass);
        totemType = EntityType.Builder.m_20704_(TotemOfHoldingEntity::new, (MobCategory)MobCategory.MISC).m_20699_(0.5f, 1.0f).m_20717_(128).m_20719_().setShouldReceiveVelocityUpdates(false).setCustomClientFactory((spawnEntity, world) -> new TotemOfHoldingEntity((EntityType<? extends TotemOfHoldingEntity>)totemType, (Level)world)).m_20712_("totem");
        RegistryHelper.register(totemType, (String)"totem");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup() {
        EntityRenderers.m_174036_(totemType, TotemOfHoldingRenderer::new);
        this.enqueue(() -> ItemProperties.register((Item)soulCompass, (ResourceLocation)new ResourceLocation("angle"), SoulCompassItem::angle));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void modelRegistry() {
        ForgeModelBakery.addSpecialModel((ResourceLocation)MODEL_LOC);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerDrops(LivingDropsEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof Player)) {
            return;
        }
        Player player = (Player)entity;
        Collection drops = event.getDrops();
        if (!(event.isCanceled() || !enableOnPK && event.getSource().m_7639_() instanceof Player && entity != event.getSource().m_7639_())) {
            CompoundTag data = player.getPersistentData();
            CompoundTag persistent = data.m_128469_("PlayerPersisted");
            if (!drops.isEmpty()) {
                TotemOfHoldingEntity totem = new TotemOfHoldingEntity(totemType, player.f_19853_);
                totem.m_6034_(player.m_20185_(), Math.max((double)(player.f_19853_.m_141937_() + 3), player.m_20186_() + 1.0), player.m_20189_());
                totem.setOwner(player);
                totem.m_6593_(player.m_5446_());
                drops.stream().filter(Objects::nonNull).map(ItemEntity::m_32055_).filter(stack -> !stack.m_41619_()).forEach(totem::addItem);
                if (!player.f_19853_.f_46443_) {
                    player.f_19853_.m_7967_((Entity)totem);
                }
                persistent.m_128359_(TAG_LAST_TOTEM, totem.m_142081_().toString());
                event.setCanceled(true);
            } else {
                persistent.m_128359_(TAG_LAST_TOTEM, "");
            }
            BlockPos pos = player.m_142538_();
            persistent.m_128405_(TAG_DEATH_X, pos.m_123341_());
            persistent.m_128405_(TAG_DEATH_Z, pos.m_123343_());
            persistent.m_128359_(TAG_DEATH_DIM, player.f_19853_.m_46472_().m_135782_().toString());
            if (!data.m_128441_("PlayerPersisted")) {
                data.m_128365_("PlayerPersisted", (Tag)persistent);
            }
        }
    }

    public static String getTotemUUID(Player player) {
        CompoundTag cmp = player.getPersistentData().m_128469_("PlayerPersisted");
        if (cmp.m_128441_(TAG_LAST_TOTEM)) {
            return cmp.m_128461_(TAG_LAST_TOTEM);
        }
        return "";
    }

    public static Pair<BlockPos, String> getPlayerDeathPosition(Entity e) {
        CompoundTag cmp;
        if (e instanceof Player && (cmp = e.getPersistentData().m_128469_("PlayerPersisted")).m_128441_(TAG_LAST_TOTEM)) {
            int x = cmp.m_128451_(TAG_DEATH_X);
            int z = cmp.m_128451_(TAG_DEATH_Z);
            String dim = cmp.m_128461_(TAG_DEATH_DIM);
            return Pair.of((Object)new BlockPos(x, -1, z), (Object)dim);
        }
        return null;
    }

    static {
        MODEL_LOC = new ModelResourceLocation(new ResourceLocation("quark", "totem_of_holding"), "inventory");
        darkSoulsMode = true;
        enableOnPK = false;
        destroyLostItems = false;
        allowAnyoneToCollect = true;
        enableSoulCompass = true;
    }
}

