/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.addons.oddities.block.be;

import com.google.common.collect.Lists;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import vazkii.arl.util.ItemNBTHelper;
import vazkii.quark.addons.oddities.block.be.AbstractEnchantingTableBlockEntity;
import vazkii.quark.addons.oddities.inventory.EnchantmentMatrix;
import vazkii.quark.addons.oddities.inventory.MatrixEnchantingMenu;
import vazkii.quark.addons.oddities.module.MatrixEnchantingModule;
import vazkii.quark.addons.oddities.util.Influence;
import vazkii.quark.api.IEnchantmentInfluencer;

public class MatrixEnchantingTableBlockEntity
extends AbstractEnchantingTableBlockEntity
implements MenuProvider {
    public static final int OPER_ADD = 0;
    public static final int OPER_PLACE = 1;
    public static final int OPER_REMOVE = 2;
    public static final int OPER_ROTATE = 3;
    public static final int OPER_MERGE = 4;
    public static final String TAG_STACK_MATRIX = "quark:enchantingMatrix";
    private static final String TAG_MATRIX = "matrix";
    private static final String TAG_MATRIX_UUID_LESS = "uuidLess";
    private static final String TAG_MATRIX_UUID_MOST = "uuidMost";
    private static final String TAG_CHARGE = "charge";
    public EnchantmentMatrix matrix;
    private boolean matrixDirty = false;
    public boolean clientMatrixDirty = false;
    private UUID matrixId;
    public final Map<Enchantment, Integer> influences = new HashMap<Enchantment, Integer>();
    public int bookshelfPower;
    public int enchantability;
    public int charge;

    public MatrixEnchantingTableBlockEntity(BlockPos pos, BlockState state) {
        super(MatrixEnchantingModule.blockEntityType, pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, MatrixEnchantingTableBlockEntity be) {
        be.tick();
    }

    @Override
    public void tick() {
        ItemStack lapis;
        super.tick();
        ItemStack item = this.m_8020_(0);
        if (item.m_41619_()) {
            if (this.matrix != null) {
                this.matrixDirty = true;
                this.matrix = null;
            }
        } else {
            this.loadMatrix(item);
            if (this.f_58857_.m_46467_() % 20L == 0L || this.matrixDirty) {
                this.updateEnchantPower();
            }
        }
        if (this.charge <= 0 && !this.f_58857_.f_46443_ && !(lapis = this.m_8020_(1)).m_41619_()) {
            lapis.m_41774_(1);
            this.charge += MatrixEnchantingModule.chargePerLapis;
            this.sync();
        }
        if (this.matrixDirty) {
            this.makeOutput();
            this.matrixDirty = false;
        }
    }

    public void onOperation(Player player, int operation, int arg0, int arg1, int arg2) {
        if (this.matrix == null) {
            return;
        }
        switch (operation) {
            case 0: {
                this.apply(m -> this.generateAndPay((EnchantmentMatrix)m, player));
                break;
            }
            case 1: {
                this.apply(m -> m.place(arg0, arg1, arg2));
                break;
            }
            case 2: {
                this.apply(m -> m.remove(arg0));
                break;
            }
            case 3: {
                this.apply(m -> m.rotate(arg0));
                break;
            }
            case 4: {
                this.apply(m -> m.merge(arg0, arg1));
            }
        }
    }

    private void apply(Predicate<EnchantmentMatrix> oper) {
        if (oper.test(this.matrix)) {
            ItemStack item = this.m_8020_(0);
            this.commitMatrix(item);
        }
    }

    private boolean generateAndPay(EnchantmentMatrix matrix, Player player) {
        if (matrix.canGeneratePiece(this.influences, this.bookshelfPower, this.enchantability) && matrix.validateXp(player, this.bookshelfPower)) {
            boolean creative = player.m_150110_().f_35937_;
            int cost = matrix.getNewPiecePrice();
            if ((this.charge > 0 || creative) && matrix.generatePiece(this.influences, this.bookshelfPower, false) && !creative) {
                player.m_6749_(-cost);
                this.charge = Math.max(this.charge - 1, 0);
            }
        }
        return true;
    }

    private void makeOutput() {
        if (this.f_58857_.f_46443_) {
            return;
        }
        this.m_6836_(2, ItemStack.f_41583_);
        ItemStack in = this.m_8020_(0);
        if (!in.m_41619_() && this.matrix != null && !this.matrix.placedPieces.isEmpty()) {
            ItemStack out = in.m_41777_();
            boolean book = false;
            if (out.m_41720_() == Items.f_42517_) {
                out = new ItemStack((ItemLike)Items.f_42690_);
                book = true;
            }
            HashMap<Enchantment, Integer> enchantments = new HashMap<Enchantment, Integer>();
            Iterator<Object> iterator = this.matrix.placedPieces.iterator();
            while (iterator.hasNext()) {
                int n = iterator.next();
                EnchantmentMatrix.Piece p = this.matrix.pieces.get(n);
                if (p == null || p.enchant == null) continue;
                for (Enchantment o : enchantments.keySet()) {
                    if (o != p.enchant && p.enchant.m_44695_(o) && o.m_44695_(p.enchant)) continue;
                    return;
                }
                enchantments.put(p.enchant, p.level);
            }
            if (book) {
                for (Map.Entry entry : enchantments.entrySet()) {
                    EnchantedBookItem.m_41153_((ItemStack)out, (EnchantmentInstance)new EnchantmentInstance((Enchantment)entry.getKey(), ((Integer)entry.getValue()).intValue()));
                }
            } else {
                EnchantmentHelper.m_44865_(enchantments, (ItemStack)out);
                ItemNBTHelper.getNBT((ItemStack)out).m_128473_(TAG_STACK_MATRIX);
            }
            this.m_6836_(2, out);
        }
    }

    private void loadMatrix(ItemStack stack) {
        if (this.matrix == null || this.matrix.target != stack) {
            if (this.matrix != null) {
                this.matrixDirty = true;
            }
            this.matrix = null;
            if (stack.m_41792_()) {
                CompoundTag cmp;
                this.matrix = new EnchantmentMatrix(stack, this.f_58857_.f_46441_);
                this.matrixDirty = true;
                this.makeUUID();
                if (ItemNBTHelper.verifyExistence((ItemStack)stack, (String)TAG_STACK_MATRIX) && (cmp = ItemNBTHelper.getCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (boolean)true)) != null) {
                    this.matrix.readFromNBT(cmp);
                }
            }
        }
    }

    private void commitMatrix(ItemStack stack) {
        if (this.f_58857_.f_46443_) {
            return;
        }
        CompoundTag cmp = new CompoundTag();
        this.matrix.writeToNBT(cmp);
        ItemNBTHelper.setCompound((ItemStack)stack, (String)TAG_STACK_MATRIX, (CompoundTag)cmp);
        this.matrixDirty = true;
        this.makeUUID();
        this.sync();
        this.m_6596_();
    }

    private void makeUUID() {
        if (!this.f_58857_.f_46443_) {
            this.matrixId = UUID.randomUUID();
        }
    }

    private void updateEnchantPower() {
        ItemStack item = this.m_8020_(0);
        this.influences.clear();
        if (item.m_41619_()) {
            return;
        }
        this.enchantability = item.m_41720_().getItemEnchantability(item);
        boolean allowWater = MatrixEnchantingModule.allowUnderwaterEnchanting;
        float power = 0.0f;
        for (int j = -1; j <= 1; ++j) {
            for (int k = -1; k <= 1; ++k) {
                if (!this.isAirGap(j, k, allowWater)) continue;
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k * 2, 0, j * 2));
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k * 2, 1, j * 2));
                if (k == 0 || j == 0) continue;
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k * 2, 0, j));
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k * 2, 1, j));
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k, 0, j * 2));
                power += this.getEnchantPowerAt(this.f_58857_, this.f_58858_.m_142082_(k, 1, j * 2));
            }
        }
        this.bookshelfPower = Math.min((int)power, MatrixEnchantingModule.maxBookshelves);
    }

    private boolean isAirGap(int j, int k, boolean allowWater) {
        if (j != 0 || k != 0) {
            BlockPos test = this.f_58858_.m_142082_(k, 0, j);
            BlockPos testUp = test.m_7494_();
            return (this.f_58857_.m_46859_(test) || allowWater && this.f_58857_.m_8055_(test).m_60734_() == Blocks.f_49990_) && (this.f_58857_.m_46859_(testUp) || allowWater && this.f_58857_.m_8055_(testUp).m_60734_() == Blocks.f_49990_);
        }
        return false;
    }

    private float getEnchantPowerAt(Level world, BlockPos pos) {
        IEnchantmentInfluencer influencer;
        BlockState state = world.m_8055_(pos);
        if (MatrixEnchantingModule.allowInfluencing && (influencer = MatrixEnchantingTableBlockEntity.getInfluencerFromBlock(state, world, pos)) != null) {
            int count = influencer.getInfluenceStack((BlockGetter)world, pos, state);
            List<Enchantment> influencedEnchants = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(it -> influencer.influencesEnchantment((BlockGetter)world, pos, state, (Enchantment)it)).toList();
            List<Enchantment> dampenedEnchants = ForgeRegistries.ENCHANTMENTS.getValues().stream().filter(it -> influencer.dampensEnchantment((BlockGetter)world, pos, state, (Enchantment)it)).toList();
            if (!influencedEnchants.isEmpty() || !dampenedEnchants.isEmpty()) {
                int curr;
                for (Enchantment e2 : influencedEnchants) {
                    curr = this.influences.getOrDefault(e2, 0);
                    this.influences.put(e2, curr + count);
                }
                for (Enchantment e2 : dampenedEnchants) {
                    curr = this.influences.getOrDefault(e2, 0);
                    this.influences.put(e2, curr - count);
                }
                this.influences.replaceAll((e, v) -> Mth.m_14045_((int)v, (int)(-MatrixEnchantingModule.influenceMax), (int)MatrixEnchantingModule.influenceMax));
                return 1.0f;
            }
        }
        return state.getEnchantPowerBonus((LevelReader)world, pos);
    }

    public void writeSharedNBT(CompoundTag cmp) {
        super.writeSharedNBT(cmp);
        CompoundTag matrixCmp = new CompoundTag();
        if (this.matrix != null) {
            this.matrix.writeToNBT(matrixCmp);
            cmp.m_128365_(TAG_MATRIX, (Tag)matrixCmp);
            if (this.matrixId != null) {
                cmp.m_128356_(TAG_MATRIX_UUID_LESS, this.matrixId.getLeastSignificantBits());
                cmp.m_128356_(TAG_MATRIX_UUID_MOST, this.matrixId.getMostSignificantBits());
            }
        }
        cmp.m_128405_(TAG_CHARGE, this.charge);
    }

    public void readSharedNBT(CompoundTag cmp) {
        super.readSharedNBT(cmp);
        if (cmp.m_128441_(TAG_MATRIX)) {
            long least = cmp.m_128454_(TAG_MATRIX_UUID_LESS);
            long most = cmp.m_128454_(TAG_MATRIX_UUID_MOST);
            UUID newId = new UUID(most, least);
            if (!newId.equals(this.matrixId)) {
                CompoundTag matrixCmp = cmp.m_128469_(TAG_MATRIX);
                this.matrixId = newId;
                this.matrix = new EnchantmentMatrix(this.m_8020_(0), new Random());
                this.matrix.readFromNBT(matrixCmp);
            }
            this.clientMatrixDirty = true;
        } else {
            this.matrix = null;
        }
        this.charge = cmp.m_128451_(TAG_CHARGE);
    }

    public AbstractContainerMenu m_7208_(int id, @Nonnull Inventory inv, @Nonnull Player player) {
        return new MatrixEnchantingMenu(id, inv, this);
    }

    @Nonnull
    public Component m_5446_() {
        return this.m_7755_();
    }

    @Nullable
    public static IEnchantmentInfluencer getInfluencerFromBlock(BlockState state, Level world, BlockPos pos) {
        Block block = state.m_60734_();
        if (block instanceof IEnchantmentInfluencer) {
            IEnchantmentInfluencer influencer = (IEnchantmentInfluencer)block;
            return influencer;
        }
        if (MatrixEnchantingModule.customInfluences.containsKey(state)) {
            return MatrixEnchantingModule.customInfluences.get(state);
        }
        return CandleInfluencer.forBlock(state.m_60734_(), world, pos);
    }

    private record CandleInfluencer(boolean inverted) implements IEnchantmentInfluencer
    {
        private static final List<Block> CANDLES = Lists.newArrayList((Object[])new Block[]{Blocks.f_152483_, Blocks.f_152484_, Blocks.f_152511_, Blocks.f_152512_, Blocks.f_152513_, Blocks.f_152514_, Blocks.f_152515_, Blocks.f_152516_, Blocks.f_152517_, Blocks.f_152518_, Blocks.f_152519_, Blocks.f_152520_, Blocks.f_152521_, Blocks.f_152522_, Blocks.f_152523_, Blocks.f_152524_});
        private static final CandleInfluencer INSTANCE = new CandleInfluencer(false);
        private static final CandleInfluencer INVERTED_INSTANCE = new CandleInfluencer(true);

        @Nullable
        public static CandleInfluencer forBlock(Block block, Level world, BlockPos pos) {
            if (MatrixEnchantingModule.candleInfluencingFailed) {
                return null;
            }
            if (CANDLES.contains(block)) {
                if (MatrixEnchantingModule.soulCandlesInvert) {
                    BlockPos posBelow = pos.m_7495_();
                    BlockState below = world.m_8055_(posBelow);
                    if (below.m_204336_(BlockTags.f_13085_)) {
                        return INVERTED_INSTANCE;
                    }
                    if (below.getEnchantPowerBonus((LevelReader)world, posBelow) > 0.0f && (below = world.m_8055_(posBelow = posBelow.m_7495_())).m_204336_(BlockTags.f_13085_)) {
                        return INVERTED_INSTANCE;
                    }
                }
                return INSTANCE;
            }
            return null;
        }

        private DyeColor getColor(BlockState state) {
            if (!((Boolean)state.m_61143_((Property)CandleBlock.f_152791_)).booleanValue()) {
                return null;
            }
            int index = CANDLES.indexOf(state.m_60734_());
            return index >= 0 ? DyeColor.values()[index] : null;
        }

        @Override
        public float[] getEnchantmentInfluenceColor(BlockGetter world, BlockPos pos, BlockState state) {
            DyeColor color = this.getColor(state);
            return color == null ? null : color.m_41068_();
        }

        @Override
        @Nullable
        public ParticleOptions getExtraParticleOptions(BlockGetter world, BlockPos pos, BlockState state) {
            if (this.inverted) {
                return ParticleTypes.f_123746_;
            }
            return null;
        }

        @Override
        public double getExtraParticleChance(BlockGetter world, BlockPos pos, BlockState state) {
            return 0.25;
        }

        @Override
        public int getInfluenceStack(BlockGetter world, BlockPos pos, BlockState state) {
            return (Boolean)state.m_61143_((Property)CandleBlock.f_152791_) != false ? (Integer)state.m_61143_((Property)CandleBlock.f_152790_) : 0;
        }

        @Override
        public boolean influencesEnchantment(BlockGetter world, BlockPos pos, BlockState state, Enchantment enchantment) {
            DyeColor color = this.getColor(state);
            if (color == null) {
                return false;
            }
            Influence influence = MatrixEnchantingModule.candleInfluences.get(color);
            List<Enchantment> boosts = this.inverted ? influence.dampen() : influence.boost();
            return boosts.contains(enchantment);
        }

        @Override
        public boolean dampensEnchantment(BlockGetter world, BlockPos pos, BlockState state, Enchantment enchantment) {
            DyeColor color = this.getColor(state);
            if (color == null) {
                return false;
            }
            Influence influence = MatrixEnchantingModule.candleInfluences.get(color);
            List<Enchantment> dampens = this.inverted ? influence.boost() : influence.dampen();
            return dampens.contains(enchantment);
        }
    }
}

