/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.gametest;

import net.darkhax.bookshelf.api.registry.IRegistryReader;
import net.darkhax.bookshelf.impl.gametest.ITestable;
import net.minecraft.gametest.framework.GameTest;
import net.minecraft.gametest.framework.GameTestHelper;
import net.minecraft.resources.ResourceLocation;

public class TestRegistryAccessor<T>
implements ITestable {
    private final IRegistryReader<T> registryReader;
    private final T lastValue;

    public TestRegistryAccessor(IRegistryReader<T> registryReader) {
        this.registryReader = registryReader;
        this.lastValue = registryReader.streamValues().skip(registryReader.streamValues().count() - 1L).findFirst().orElseThrow();
    }

    @GameTest
    public void testRealIdLookup(GameTestHelper helper) {
        ResourceLocation id = this.registryReader.getId(this.lastValue);
        if (id != null) {
            helper.m_177412_();
        } else {
            helper.m_177284_("Id for lookup was null.");
        }
    }

    @GameTest
    public void testNullableLookup(GameTestHelper helper) {
        T value = this.registryReader.get(new ResourceLocation("fake_mc_fake", "im_not_a_real_boy"));
        if (value != null) {
            helper.m_177284_("Expected null. Got " + value);
        } else {
            helper.m_177412_();
        }
    }

    @GameTest
    public void testRealValueLookup(GameTestHelper helper) {
        ResourceLocation id = this.registryReader.getId(this.lastValue);
        T lookup = this.registryReader.get(id);
        if (id == null) {
            helper.m_177284_("Lookup ID was null!");
        } else if (lookup == null) {
            helper.m_177284_("Lookup was null for ID " + id + " was null");
        } else if (lookup != this.lastValue) {
            helper.m_177284_("Incorrect match. Expected " + this.lastValue + " Got " + lookup);
        } else {
            helper.m_177412_();
        }
    }

    @Override
    public String getDefaultBatch() {
        return "bookshelf_serialization_" + this.registryReader.getRegistryName().toString();
    }
}

