/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.bookshelf.impl.data.recipes.crafting;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import net.darkhax.bookshelf.api.Services;
import net.darkhax.bookshelf.api.data.recipes.IRecipeSerializer;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;

public class ShapelessDurabilityRecipe
extends ShapelessRecipe {
    public static final Serializer SERIALIZER = new Serializer();
    private final int damageAmount;

    public ShapelessDurabilityRecipe(ResourceLocation recipeId, String group, ItemStack result, NonNullList<Ingredient> ingredients, int damageAmount) {
        super(recipeId, group, result, ingredients);
        this.damageAmount = damageAmount;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingContainer inv) {
        NonNullList keptItems = super.m_7457_((Container)inv);
        return Services.INVENTORY_HELPER.keepDamageableItems(inv, (NonNullList<ItemStack>)keptItems, this.damageAmount);
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER.getWrapper();
    }

    public static class Serializer
    extends IRecipeSerializer<ShapelessDurabilityRecipe> {
        @Override
        public ShapelessDurabilityRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.m_13851_((JsonObject)json, (String)"group", (String)"");
            NonNullList<Ingredient> inputs = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)json, (String)"ingredients"));
            ItemStack output = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)json, (String)"result"));
            int damageAmount = GsonHelper.m_13824_((JsonObject)json, (String)"damageAmount", (int)1);
            if (inputs.isEmpty()) {
                throw new JsonSyntaxException("No ingredients were found for the recipe!");
            }
            if (inputs.size() > 9) {
                throw new JsonSyntaxException("Too many ingredients. Maximum is 9 but " + inputs.size() + " were given.");
            }
            if (output.m_41619_()) {
                throw new JsonSyntaxException("The output of the recipe must not be empty!");
            }
            return new ShapelessDurabilityRecipe(recipeId, group, output, inputs, damageAmount);
        }

        @Override
        public ShapelessDurabilityRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            String group = buffer.m_130136_(Short.MAX_VALUE);
            int inputCount = buffer.m_130242_();
            NonNullList inputs = NonNullList.m_122780_((int)inputCount, (Object)Ingredient.f_43901_);
            for (int i = 0; i < inputCount; ++i) {
                inputs.set(i, (Object)Ingredient.m_43940_((FriendlyByteBuf)buffer));
            }
            ItemStack output = buffer.m_130267_();
            int damageAmount = buffer.m_130242_();
            return new ShapelessDurabilityRecipe(recipeId, group, output, (NonNullList<Ingredient>)inputs, damageAmount);
        }

        @Override
        public void toNetwork(FriendlyByteBuf buffer, ShapelessDurabilityRecipe toWrite) {
            buffer.m_130070_(toWrite.m_6076_());
            buffer.m_130130_(toWrite.m_7527_().size());
            for (Ingredient ingredient : toWrite.m_7527_()) {
                ingredient.m_43923_(buffer);
            }
            buffer.m_130055_(toWrite.m_8043_());
            buffer.m_130130_(toWrite.damageAmount);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray json) {
            NonNullList ingredients = NonNullList.m_122779_();
            for (JsonElement element : json) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)element);
                if (ingredient.m_43947_()) continue;
                ingredients.add((Object)ingredient);
            }
            return ingredients;
        }
    }
}

