/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge.dynamic;

import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.forge.dynamic.ModDynamicRegistry;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.resourcepack.DynamicDataPack;
import net.mehvahdjukaar.selene.resourcepack.RPAwareDynamicDataProvider;
import net.mehvahdjukaar.selene.resourcepack.ResType;
import net.mehvahdjukaar.selene.resourcepack.StaticResource;
import net.mehvahdjukaar.selene.resourcepack.resources.TagBuilder;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.apache.logging.log4j.Logger;

public class ServerDynamicResourcesHandler
extends RPAwareDynamicDataProvider {
    public ServerDynamicResourcesHandler() {
        super(new DynamicDataPack(ImmersiveWeathering.res("generated_pack")));
        ((DynamicDataPack)this.dynamicPack).generateDebugResources = false;
    }

    public Logger getLogger() {
        return ImmersiveWeathering.LOGGER;
    }

    public boolean dependsOnLoadedPacks() {
        return true;
    }

    public void regenerateDynamicAssets(ResourceManager manager) {
        StaticResource lootTable = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.BLOCK_LOOT_TABLES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        StaticResource recipe = StaticResource.getOrLog((ResourceManager)manager, (ResourceLocation)ResType.RECIPES.getPath(ImmersiveWeathering.res("oak_leaf_pile")));
        for (Map.Entry<LeafPileBlock, LeavesType> e : ModDynamicRegistry.LEAF_TO_TYPE.entrySet()) {
            LeavesType leafType = e.getValue();
            if (leafType.isVanilla()) continue;
            LeafPileBlock v = e.getKey();
            String path = leafType.getNamespace() + "/" + leafType.getTypeName();
            String id = path + "_leaf_pile";
            String leavesId = leafType.leaves.getRegistryName().toString();
            try {
                this.addLeafPileJson(Objects.requireNonNull(lootTable), id, leavesId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile loot table for {} : {}", (Object)v, (Object)ex);
            }
            try {
                this.addLeafPileJson(Objects.requireNonNull(recipe), id, leavesId);
            }
            catch (Exception ex) {
                this.getLogger().error("Failed to generate Leaf Pile recipe for {} : {}", (Object)v, (Object)ex);
            }
        }
    }

    public void generateStaticAssetsOnStartup(ResourceManager manager) {
        TagBuilder leafPiles = TagBuilder.of((ResourceLocation)ImmersiveWeathering.res("leaf_piles"));
        ModDynamicRegistry.LEAF_TO_TYPE.keySet().forEach(v -> leafPiles.add(v.getRegistryName()));
        ((DynamicDataPack)this.dynamicPack).addTag(leafPiles, Registry.f_122901_);
        ((DynamicDataPack)this.dynamicPack).addTag(leafPiles, Registry.f_122904_);
        ((DynamicDataPack)this.dynamicPack).addTag(TagBuilder.of((ResourceLocation)ImmersiveWeathering.res("bark")).addEntries(ModDynamicRegistry.MODDED_BARK.values()), Registry.f_122904_);
    }

    public void addLeafPileJson(StaticResource resource, String id, String leafBlockId) {
        String string = new String(resource.data, StandardCharsets.UTF_8);
        String path = resource.location.m_135815_().replace("oak_leaf_pile", id);
        string = string.replace("oak_leaf_pile", id);
        string = string.replace("minecraft:oak_leaves", leafBlockId);
        ResourceLocation newRes = ImmersiveWeathering.res(path);
        ((DynamicDataPack)this.dynamicPack).addBytes(newRes, string.getBytes(), ResType.GENERIC);
    }
}

