/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge.dynamic;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.client.particles.LeafParticle;
import com.ordana.immersive_weathering.forge.dynamic.ClientDynamicResourcesHandler;
import com.ordana.immersive_weathering.forge.dynamic.ServerDynamicResourcesHandler;
import com.ordana.immersive_weathering.items.BurnableItem;
import com.ordana.immersive_weathering.items.LeafPileBlockItem;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModParticles;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.mehvahdjukaar.selene.block_set.BlockSetManager;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesType;
import net.mehvahdjukaar.selene.block_set.leaves.LeavesTypeRegistry;
import net.mehvahdjukaar.selene.block_set.wood.WoodType;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModDynamicRegistry {
    public static final Map<LeafPileBlock, LeavesType> LEAF_TO_TYPE = new LinkedHashMap<LeafPileBlock, LeavesType>();
    public static final Map<LeavesType, LeafPileBlock> TYPE_TO_LEAF = new LinkedHashMap<LeavesType, LeafPileBlock>();
    public static final Map<LeavesType, SimpleParticleType> TYPE_TO_LEAF_PARTICLE = new LinkedHashMap<LeavesType, SimpleParticleType>();
    public static final Map<Item, LeavesType> LEAF_PILES_ITEMS = new LinkedHashMap<Item, LeavesType>();
    public static final Map<WoodType, Item> MODDED_BARK = new LinkedHashMap<WoodType, Item>();

    public static Map<Block, LeafPileBlock> getLeafToLeafPileMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        LEAF_TO_TYPE.forEach((key, value) -> builder.put((Object)value.leaves, (Object)key));
        return builder.build();
    }

    public static Map<Block, SimpleParticleType> getLeavesToParticleMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        TYPE_TO_LEAF_PARTICLE.forEach((key, value) -> builder.put((Object)key.leaves, value));
        return builder.build();
    }

    public static Map<Block, Pair<Item, Block>> getBarkMap() {
        HashMap<Block, Pair<Item, Block>> map = new HashMap<Block, Pair<Item, Block>>();
        MODDED_BARK.forEach((wood, item) -> {
            Block stripped_wood;
            Block log = wood.log;
            Block stripped = wood.getBlockOfThis("stripped_log");
            if (stripped != null) {
                map.put(stripped, Pair.of((Object)item, (Object)log));
            }
            if ((stripped_wood = wood.getBlockOfThis("stripped_wood")) != null) {
                map.put(stripped_wood, Pair.of((Object)item, (Object)wood.getBlockOfThis("wood")));
            }
        });
        return map;
    }

    private static void registerBarks(RegistryEvent.Register<Item> event, Collection<WoodType> woodTypes) {
        IForgeRegistry registry = event.getRegistry();
        for (WoodType type : woodTypes) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_bark";
            Item item = (Item)new BurnableItem(new Item.Properties().m_41491_(CreativeModeTab.f_40759_), 200).setRegistryName(ImmersiveWeathering.res(name));
            registry.register((IForgeRegistryEntry)item);
            MODDED_BARK.put(type, item);
        }
        LEAF_TO_TYPE.forEach((a, b) -> TYPE_TO_LEAF.put((LeavesType)b, (LeafPileBlock)((Object)a)));
    }

    private static void registerLeafPiles(RegistryEvent.Register<Block> event, Collection<LeavesType> leavesTypes) {
        LEAF_TO_TYPE.put(ModBlocks.OAK_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"oak"));
        LEAF_TO_TYPE.put(ModBlocks.BIRCH_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"birch"));
        LEAF_TO_TYPE.put(ModBlocks.SPRUCE_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"spruce"));
        LEAF_TO_TYPE.put(ModBlocks.JUNGLE_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"jungle"));
        LEAF_TO_TYPE.put(ModBlocks.ACACIA_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"acacia"));
        LEAF_TO_TYPE.put(ModBlocks.DARK_OAK_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"dark_oak"));
        LEAF_TO_TYPE.put(ModBlocks.AZALEA_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"azalea"));
        LEAF_TO_TYPE.put(ModBlocks.FLOWERING_AZALEA_LEAF_PILE.get(), LeavesTypeRegistry.fromNBT((String)"flowering_azalea"));
        IForgeRegistry registry = event.getRegistry();
        for (LeavesType type : leavesTypes) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_leaf_pile";
            LeafPileBlock block = (LeafPileBlock)new LeafPileBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)ModBlocks.OAK_LEAF_PILE.get())), false, false, true, List.of(() -> TYPE_TO_LEAF_PARTICLE.get(type))).setRegistryName(ImmersiveWeathering.res(name));
            registry.register((IForgeRegistryEntry)block);
            LEAF_TO_TYPE.put(block, type);
        }
        LEAF_TO_TYPE.forEach((a, b) -> TYPE_TO_LEAF.put((LeavesType)b, (LeafPileBlock)((Object)a)));
    }

    private static void registerLeafPilesItems(RegistryEvent.Register<Item> event, Collection<LeavesType> leavesTypes) {
        for (LeavesType type : leavesTypes) {
            if (type.isVanilla()) continue;
            LeafPileBlockItem i = new LeafPileBlockItem((Block)TYPE_TO_LEAF.get(type), new Item.Properties().m_41491_(CreativeModeTab.f_40750_));
            i.setRegistryName(TYPE_TO_LEAF.get(type).getRegistryName());
            event.getRegistry().register((IForgeRegistryEntry)i);
        }
    }

    private static void registerLeafPilesParticles(RegistryEvent.Register<ParticleType<?>> event) {
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"oak"), ModParticles.OAK_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"birch"), ModParticles.BIRCH_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"spruce"), ModParticles.SPRUCE_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"jungle"), ModParticles.JUNGLE_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"acacia"), ModParticles.ACACIA_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"dark_oak"), ModParticles.DARK_OAK_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"azalea"), ModParticles.AZALEA_LEAF.get());
        TYPE_TO_LEAF_PARTICLE.put(LeavesTypeRegistry.fromNBT((String)"flowering_azalea"), ModParticles.AZALEA_FLOWER.get());
        for (LeavesType type : LeavesTypeRegistry.LEAVES_TYPES.values()) {
            if (type.isVanilla()) continue;
            String name = type.getNamespace() + "/" + type.getTypeName() + "_leaf";
            SimpleParticleType o = new SimpleParticleType(true);
            event.getRegistry().register((IForgeRegistryEntry)((ParticleType)o.setRegistryName(name)));
            TYPE_TO_LEAF_PARTICLE.put(type, o);
        }
    }

    public static void init() {
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerLeafPiles, Block.class, LeavesType.class);
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerLeafPilesItems, Item.class, LeavesType.class);
        BlockSetManager.addBlockSetRegistrationCallback(ModDynamicRegistry::registerBarks, Item.class, WoodType.class);
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addGenericListener(ParticleType.class, ModDynamicRegistry::registerLeafPilesParticles);
        ServerDynamicResourcesHandler serverRes = new ServerDynamicResourcesHandler();
        serverRes.register(bus);
        PlatformHelper.getEnv().ifClient(() -> {
            ClientDynamicResourcesHandler clientRes = new ClientDynamicResourcesHandler();
            clientRes.register(bus);
            ClientPlatformHelper.addParticleRegistration(ModDynamicRegistry::registerParticlesRenderers);
        });
    }

    private static void registerParticlesRenderers(ClientPlatformHelper.ParticleEvent particleEvent) {
        for (Map.Entry<LeavesType, SimpleParticleType> e : TYPE_TO_LEAF_PARTICLE.entrySet()) {
            if (e.getKey().isVanilla()) continue;
            particleEvent.register(e.getValue(), LeafParticle.ColoredLeafParticle::new);
        }
    }
}

