/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.ordana.immersive_weathering.client.ImmersiveWeatheringClient;
import com.ordana.immersive_weathering.forge.IWPlatformStuffImpl;
import com.ordana.immersive_weathering.mixins.forge.AccessorBlockColor;
import com.ordana.immersive_weathering.mixins.forge.AccessorItemColor;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IRegistryDelegate;

@Mod.EventBusSubscriber(modid="immersive_weathering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class ImmersiveWeatheringForgeClient {
    @SubscribeEvent
    public static void init(FMLClientSetupEvent event) {
        ImmersiveWeatheringClient.setup();
    }

    @Mod.EventBusSubscriber(modid="immersive_weathering", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class ClientTicker {
        private static boolean clientTicked = false;

        @SubscribeEvent
        public static void firstClientTick(TickEvent.ClientTickEvent event) {
            if (!clientTicked && event.phase == TickEvent.Phase.END) {
                try {
                    BlockColors bc = Minecraft.m_91087_().m_91298_();
                    Map<IRegistryDelegate<Block>, BlockColor> blockColorMap = ((AccessorBlockColor)bc).getBlockColors();
                    IWPlatformStuffImpl.COPY_BLOCK_COLORS.forEach((block, colorFrom) -> {
                        BlockState leafState = colorFrom.m_49966_();
                        BlockColor color = (BlockColor)blockColorMap.get(colorFrom.delegate);
                        if (color != null) {
                            BlockColor newBc = (s, t, p, i) -> color.m_92566_(leafState, t, p, i);
                            bc.m_92589_(newBc, new Block[]{block});
                        }
                    });
                }
                catch (Exception bc) {
                    // empty catch block
                }
                try {
                    ItemColors ic = Minecraft.m_91087_().getItemColors();
                    Map<IRegistryDelegate<Item>, ItemColor> itemColorMap = ((AccessorItemColor)ic).getItemColors();
                    IWPlatformStuffImpl.COPY_ITEM_COLORS.forEach((item, colorFrom) -> {
                        ItemStack leafItem = new ItemStack((ItemLike)colorFrom);
                        ItemColor baseColor = (ItemColor)itemColorMap.get(leafItem.m_41720_().delegate);
                        if (baseColor != null) {
                            ItemColor newIc = (s, i) -> baseColor.m_92671_(leafItem, i);
                            ic.m_92689_(newIc, new ItemLike[]{item});
                        }
                    });
                }
                catch (Exception exception) {
                    // empty catch block
                }
                clientTicked = true;
            }
        }
    }
}

