/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.google.common.base.Suppliers;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.ordana.immersive_weathering.ImmersiveWeathering;
import com.ordana.immersive_weathering.client.ImmersiveWeatheringClient;
import com.ordana.immersive_weathering.forge.CeilingAndWallBlockItem;
import com.ordana.immersive_weathering.forge.FeatureHacks;
import com.ordana.immersive_weathering.forge.dynamic.ModDynamicRegistry;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModWaxables;
import java.io.IOException;
import java.util.Map;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.repository.Pack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.data.loading.DatagenModLoader;
import net.minecraftforge.event.AddPackFindersEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.locating.IModFile;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.resource.PathResourcePack;

@Mod(value="immersive_weathering")
public class ImmersiveWeatheringForge {
    public static final String MOD_ID = "immersive_weathering";
    public static boolean hasDynamic = ModList.get().isLoaded("selene");

    public ImmersiveWeatheringForge() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.register((Object)this);
        ImmersiveWeathering.commonInit();
        FeatureHacks.init();
        if (hasDynamic) {
            ModDynamicRegistry.init();
        }
        if (PlatformHelper.getEnv().isClient()) {
            ImmersiveWeatheringClient.init();
        }
    }

    @SubscribeEvent
    public void interModCommunication(InterModEnqueueEvent event) {
        event.enqueueWork(() -> {});
    }

    @SubscribeEvent
    public void registerOverrides(RegistryEvent.Register<Item> event) {
        event.getRegistry().register((IForgeRegistryEntry)((Item)new CeilingAndWallBlockItem(Blocks.f_152548_, ModBlocks.HANGING_ROOTS_WALL.get(), new Item.Properties().m_41491_(CreativeModeTab.f_40750_)).setRegistryName("minecraft:hanging_roots")));
    }

    @SubscribeEvent
    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            ImmersiveWeathering.commonSetup();
            ImmersiveWeatheringForge.registerWaxables();
        });
    }

    private static void registerWaxables() {
        try {
            BiMap oldWaxables = (BiMap)HoneycombItem.f_150863_.get();
            HoneycombItem.f_150863_ = Suppliers.memoize(() -> ImmutableBiMap.builder().putAll((Map)oldWaxables).putAll(ModWaxables.getValues()).build());
            HoneycombItem.f_150864_ = Suppliers.memoize(() -> ((BiMap)HoneycombItem.f_150863_.get()).inverse());
        }
        catch (Exception e) {
            ImmersiveWeathering.LOGGER.error("Failed to register Waxables: ", (Throwable)e);
        }
    }

    @SubscribeEvent
    public void addPackFinders(AddPackFindersEvent event) {
        if (event.getPackType() == PackType.CLIENT_RESOURCES) {
            ImmersiveWeatheringForge.registerBuiltinResourcePack(event, (MutableComponent)new TextComponent("Biome Tinted Mossy Blocks"), "biome_tinted_mossy_blocks");
            ImmersiveWeatheringForge.registerBuiltinResourcePack(event, (MutableComponent)new TextComponent("Better Brick Items"), "better_brick_items");
            ImmersiveWeatheringForge.registerBuiltinResourcePack(event, (MutableComponent)new TextComponent("Better Brick blocks"), "better_brick_blocks");
            ImmersiveWeatheringForge.registerBuiltinResourcePack(event, (MutableComponent)new TextComponent("Visual Waxed Iron Items"), "visual_waxed_iron_items");
        }
    }

    private static void registerBuiltinResourcePack(AddPackFindersEvent event, MutableComponent name, String folder) {
        event.addRepositorySource((consumer, constructor) -> {
            block7: {
                String path = ImmersiveWeathering.res(folder).toString();
                IModFile file = ModList.get().getModFileById(MOD_ID).getFile();
                try (PathResourcePack pack = new PathResourcePack(path, file.findResource(new String[]{"resourcepacks/" + folder}));){
                    consumer.accept(constructor.create(ImmersiveWeathering.res(folder).toString(), (Component)name, false, () -> pack, (PackMetadataSection)pack.m_5550_((MetadataSectionSerializer)PackMetadataSection.f_10366_), Pack.Position.TOP, PackSource.f_10528_, false));
                }
                catch (IOException e) {
                    if (DatagenModLoader.isRunningDataGen()) break block7;
                    e.printStackTrace();
                }
            }
        });
    }
}

