/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.forge;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.forge.FeatureHacks;
import com.ordana.immersive_weathering.forge.ImmersiveWeatheringForge;
import com.ordana.immersive_weathering.forge.dynamic.ModDynamicRegistry;
import com.ordana.immersive_weathering.integration.IntegrationHandler;
import com.ordana.immersive_weathering.integration.QuarkPlugin;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.platform.ClientPlatformHelper;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class IWPlatformStuffImpl {
    public static final IdentityHashMap<Block, Block> COPY_BLOCK_COLORS = new IdentityHashMap();
    public static final IdentityHashMap<Item, Item> COPY_ITEM_COLORS = new IdentityHashMap();

    public static void addExtraFloweryBlocks(ImmutableBiMap.Builder<Block, Block> builder) {
        Block a = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:flowering_azalea_hedge"));
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:azalea_hedge"));
        if (a != null && b != null) {
            builder.put((Object)a, (Object)b);
        }
        Block c = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:flowering_azalea_leaf_carpet"));
        Block d = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("quark:azalea_leaf_carpet"));
        if (c != null && d != null) {
            builder.put((Object)c, (Object)d);
        }
    }

    public static void addExtraMossyBlocks(ImmutableBiMap.Builder<Block, Block> builder) {
        if (IntegrationHandler.quark) {
            QuarkPlugin.addAllVerticalSlabs(builder);
        }
    }

    public static void addExtraCrackedBlocks(ImmutableBiMap.Builder<Block, Block> builder) {
        if (IntegrationHandler.quark) {
            QuarkPlugin.addAllVerticalSlabs(builder);
        }
    }

    public static FlowingFluid getFlowingFluid(LiquidBlock block) {
        return block.getFluid();
    }

    public static Collection<LeafPileBlock> getLeafPiles() {
        return List.of();
    }

    public static void addFeatureToBiome(GenerationStep.Decoration step, TagKey<Biome> tagKey, ResourceKey<PlacedFeature> feature) {
        Consumer<BiomeLoadingEvent> c = e -> FeatureHacks.registerVanillaBiomeFeatures(e, tagKey, feature, step);
        MinecraftForge.EVENT_BUS.addListener(c);
    }

    public static Map<Block, LeafPileBlock> getDynamicLeafPiles() {
        return ImmersiveWeatheringForge.hasDynamic ? ModDynamicRegistry.getLeafToLeafPileMap() : null;
    }

    public static Map<Block, SimpleParticleType> getDynamicLeafParticles() {
        return ImmersiveWeatheringForge.hasDynamic ? ModDynamicRegistry.getLeavesToParticleMap() : null;
    }

    public static void addExtraBark(ImmutableMap.Builder<Block, Pair<Item, Block>> builder) {
        if (ImmersiveWeatheringForge.hasDynamic) {
            builder.putAll(ModDynamicRegistry.getBarkMap());
        }
    }

    public static void copyColorFrom(ClientPlatformHelper.BlockColorEvent event, Block block, Block colorFrom, BlockColor fallbackColor) {
        COPY_BLOCK_COLORS.put(block, colorFrom);
    }

    public static void copyColorFrom(ClientPlatformHelper.ItemColorEvent event, ItemLike block, ItemLike colorFrom, ItemColor fallbackColor) {
        COPY_ITEM_COLORS.put(block.m_5456_(), colorFrom.m_5456_());
    }
}

