/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.features;

import com.ordana.immersive_weathering.blocks.IcicleBlock;
import com.ordana.immersive_weathering.reg.ModBlocks;
import com.ordana.immersive_weathering.reg.ModTags;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.Property;

public class IcicleHelper {
    protected static boolean canGenerate(LevelAccessor world, BlockPos pos) {
        return world.m_7433_(pos, IcicleHelper::canGenerate);
    }

    protected static void getIcicleThickness(Direction direction, int height, boolean merge, Consumer<BlockState> callback) {
        if (height >= 3) {
            callback.accept(IcicleHelper.getState(direction, DripstoneThickness.BASE));
            for (int i = 0; i < height - 3; ++i) {
                callback.accept(IcicleHelper.getState(direction, DripstoneThickness.MIDDLE));
            }
        }
        if (height >= 2) {
            callback.accept(IcicleHelper.getState(direction, DripstoneThickness.FRUSTUM));
        }
        if (height >= 1) {
            callback.accept(IcicleHelper.getState(direction, merge ? DripstoneThickness.TIP_MERGE : DripstoneThickness.TIP));
        }
    }

    protected static void generateIcicle(LevelAccessor world, BlockPos pos, Direction direction, int height, boolean merge) {
        if (IcicleHelper.canReplace(world.m_8055_(pos.m_142300_(direction.m_122424_())))) {
            BlockPos.MutableBlockPos mutable = pos.m_122032_();
            IcicleHelper.getIcicleThickness(direction, height, merge, state -> {
                if (state.m_60713_(ModBlocks.ICICLE.get())) {
                    state = (BlockState)state.m_61124_((Property)IcicleBlock.f_154011_, (Comparable)Boolean.valueOf(world.m_46801_((BlockPos)mutable)));
                }
                world.m_7731_((BlockPos)mutable, state, 2);
                mutable.m_122173_(direction);
            });
        }
    }

    protected static boolean generateIceBlock(LevelAccessor world, BlockPos pos) {
        BlockState blockState = world.m_8055_(pos);
        if (blockState.m_204336_(ModTags.ICICLE_REPLACEABLE_BLOCKS)) {
            world.m_7731_(pos, Blocks.f_50354_.m_49966_(), 2);
            return true;
        }
        return false;
    }

    private static BlockState getState(Direction direction, DripstoneThickness thickness) {
        return (BlockState)((BlockState)ModBlocks.ICICLE.get().m_49966_().m_61124_((Property)IcicleBlock.f_154009_, (Comparable)direction)).m_61124_((Property)IcicleBlock.f_154010_, (Comparable)thickness);
    }

    public static boolean canReplaceOrLava(BlockState state) {
        return IcicleHelper.canReplace(state) || state.m_60713_(Blocks.f_49991_);
    }

    public static boolean canReplace(BlockState state) {
        return state.m_204336_(ModTags.ICICLE_REPLACEABLE_BLOCKS);
    }

    public static boolean canGenerate(BlockState state) {
        return state.m_60795_() || state.m_60713_(Blocks.f_49990_);
    }
}

