/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.entities;

import com.ordana.immersive_weathering.configs.CommonConfigs;
import com.ordana.immersive_weathering.reg.ModEntities;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.BlockPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import org.jetbrains.annotations.Nullable;

public class IcicleBlockEntity
extends BlockEntity
implements GameEventListener {
    public static final Object2IntMap<GameEvent> VOLUME_FOR_EVENT = Object2IntMaps.unmodifiable((Object2IntMap)((Object2IntMap)Util.m_137469_((Object)new Object2IntOpenHashMap(), map -> {
        map.put((Object)GameEvent.f_157770_, 2);
        map.put((Object)GameEvent.f_157794_, 1);
        map.put((Object)GameEvent.f_157773_, 2);
        map.put((Object)GameEvent.f_157780_, 8);
        map.put((Object)GameEvent.f_157792_, 1);
        map.put((Object)GameEvent.f_157779_, 8);
        map.put((Object)GameEvent.f_157793_, 6);
        map.put((Object)GameEvent.f_157796_, 6);
        map.put((Object)GameEvent.f_157802_, 3);
        map.put((Object)GameEvent.f_157803_, 3);
        map.put((Object)GameEvent.f_157774_, 3);
        map.put((Object)GameEvent.f_157782_, 3);
        map.put((Object)GameEvent.f_157783_, 3);
        map.put((Object)GameEvent.f_157775_, 3);
        map.put((Object)GameEvent.f_157812_, 15);
        map.put((Object)GameEvent.f_157772_, 15);
        Registry.f_175412_.m_6612_(new ResourceLocation("moyai", "moyai_boom")).ifPresent(e -> map.put(e, 7));
    })));
    private final int radius;
    protected final PositionSource listenerSource;

    public IcicleBlockEntity(BlockPos pos, BlockState state) {
        super(ModEntities.ICICLE_TILE.get(), pos, state);
        this.listenerSource = new BlockPositionSource(this.f_58858_);
        this.radius = CommonConfigs.FALLING_ICICLES.get() != false ? 15 : 0;
    }

    public PositionSource m_142460_() {
        return this.listenerSource;
    }

    public int m_142078_() {
        return this.radius;
    }

    public boolean m_142721_(Level level, GameEvent gameEvent, @Nullable Entity entity, BlockPos pos) {
        double distanceSqr;
        int volume;
        if (pos != this.f_58858_ && (double)((volume = VOLUME_FOR_EVENT.getInt((Object)gameEvent)) * volume) > (distanceSqr = this.f_58858_.m_203202_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) * 0.5 + (double)level.f_46441_.nextFloat() * distanceSqr) {
            float distScaling = 2.0f;
            int o = level.m_5822_().nextInt(3) - 1;
            int delay = Math.max(0, (int)Mth.m_14116_((float)((float)((double)distScaling * distanceSqr)))) + o;
            level.m_186460_(this.f_58858_, this.m_58900_().m_60734_(), delay);
        }
        return false;
    }
}

