/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.entities;

import com.ordana.immersive_weathering.blocks.LayerBlock;
import com.ordana.immersive_weathering.blocks.LeafPileBlock;
import com.ordana.immersive_weathering.reg.ModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FallingLayerEntity
extends FallingBlockEntity {
    public FallingLayerEntity(EntityType<FallingLayerEntity> type, Level level) {
        super(type, level);
    }

    public FallingLayerEntity(Level level) {
        this(ModEntities.FALLING_LAYER.get(), level);
    }

    public FallingLayerEntity(Level level, BlockPos pos, BlockState blockState) {
        super(ModEntities.FALLING_LAYER.get(), level);
        this.f_19850_ = true;
        this.f_19854_ = (double)pos.m_123341_() + 0.5;
        this.f_19855_ = pos.m_123342_();
        this.f_19856_ = (double)pos.m_123343_() + 0.5;
        this.m_6034_(this.f_19854_, this.f_19855_ + (double)((1.0f - this.m_20206_()) / 2.0f), this.f_19856_);
        this.m_20256_(Vec3.f_82478_);
        this.m_31959_(this.m_142538_());
        this.setBlockState(blockState);
    }

    public void setBlockState(BlockState state) {
        if (state.m_61138_((Property)BlockStateProperties.f_61362_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false));
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)state));
        tag.m_128405_("Time", this.f_31942_);
        this.m_7378_(tag);
    }

    public static FallingLayerEntity fall(Level level, BlockPos pos, BlockState state) {
        FallingLayerEntity entity = new FallingLayerEntity(level, pos, state);
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        level.m_7967_((Entity)entity);
        return entity;
    }

    @Nullable
    public ItemEntity m_19998_(ItemLike pItem) {
        this.dropItemAndBreak(this.m_31980_(), this.m_142538_());
        return null;
    }

    public void m_8119_() {
        Block block;
        if (this.f_19853_.f_46443_) {
            super.m_8119_();
            return;
        }
        BlockState blockState = this.m_31980_();
        if (blockState.m_60795_() || !((block = blockState.m_60734_()) instanceof LayerBlock)) {
            this.m_146870_();
        } else {
            LayerBlock block2 = (LayerBlock)block;
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19853_.f_46443_) {
                BlockHitResult blockhitresult;
                BlockState onState;
                BlockPos pos = this.m_142538_();
                if (this.f_19853_.m_6425_(pos).m_205070_(FluidTags.f_13131_)) {
                    onState = this.f_19853_.m_8055_(pos);
                    if (block2 instanceof LeafPileBlock && onState.m_60713_(Blocks.f_49990_) && block2.getLayers(blockState) == 1) {
                        blockState = (BlockState)blockState.m_61124_((Property)block2.layerProperty(), (Comparable)Integer.valueOf(0));
                    }
                }
                if (this.m_20184_().m_82556_() > 1.0 && (blockhitresult = this.f_19853_.m_45547_(new ClipContext(new Vec3(this.f_19854_, this.f_19855_, this.f_19856_), this.m_20182_(), ClipContext.Block.COLLIDER, ClipContext.Fluid.SOURCE_ONLY, (Entity)this))).m_6662_() != HitResult.Type.MISS && this.f_19853_.m_6425_(blockhitresult.m_82425_()).m_205070_(FluidTags.f_13131_)) {
                    this.discardAndDrop(blockState, pos);
                    return;
                }
                if (!this.f_19861_) {
                    if (!(this.f_19853_.f_46443_ || (this.f_31942_ <= 100 || pos.m_123342_() > this.f_19853_.m_141937_() && pos.m_123342_() <= this.f_19853_.m_151558_()) && this.f_31942_ <= 600)) {
                        this.discardAndDrop(blockState, pos);
                        return;
                    }
                } else {
                    onState = this.f_19853_.m_8055_(pos);
                    this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
                    if (!onState.m_60713_(Blocks.f_50110_)) {
                        boolean canSurvive;
                        boolean canBeReplaced = onState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, pos, Direction.DOWN, new ItemStack((ItemLike)blockState.m_60734_().m_5456_()), Direction.UP));
                        boolean isFree = block2.shouldFall(blockState, this.f_19853_.m_8055_(pos.m_7495_()));
                        boolean bl = canSurvive = blockState.m_60710_((LevelReader)this.f_19853_, pos) && !isFree;
                        if (canBeReplaced && canSurvive) {
                            int remaining = 0;
                            if (onState.m_60713_(blockState.m_60734_())) {
                                IntegerProperty layers_property = block2.layerProperty();
                                int layers = (Integer)blockState.m_61143_((Property)layers_property);
                                int toLayers = (Integer)onState.m_61143_((Property)layers_property);
                                int total = layers + toLayers;
                                int target = Mth.m_14045_((int)total, (int)1, (int)block2.getMaxLayers());
                                remaining = total - target;
                                blockState = (BlockState)blockState.m_61124_((Property)layers_property, (Comparable)Integer.valueOf(target));
                            }
                            if (this.f_19853_.m_7731_(pos, blockState, 3)) {
                                ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(pos, this.f_19853_.m_8055_(pos)));
                                block2.m_142216_(this.f_19853_, pos, blockState, onState, this);
                                this.m_146870_();
                                if (remaining != 0) {
                                    BlockPos above = pos.m_7494_();
                                    blockState = (BlockState)blockState.m_61124_((Property)block2.layerProperty(), (Comparable)Integer.valueOf(remaining));
                                    if (this.f_19853_.m_8055_(above).m_60767_().m_76336_() && !this.f_19853_.m_7731_(above, blockState, 3)) {
                                        ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(above, this.f_19853_.m_8055_(above)));
                                        this.dropItemAndBreak(blockState, pos);
                                    }
                                }
                                return;
                            }
                        }
                        this.discardAndDrop(blockState, pos);
                    }
                }
            }
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
    }

    private void discardAndDrop(BlockState state, BlockPos pos) {
        if (this.f_31943_ && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_149650_(state.m_60734_(), pos);
            this.dropItemAndBreak(state, pos);
        }
        this.m_146870_();
    }

    private void dropItemAndBreak(BlockState state, BlockPos pos) {
        Block.m_49881_((BlockState)state, (Level)this.f_19853_, (BlockPos)pos, null, null, (ItemStack)ItemStack.f_41583_);
        this.f_19853_.m_5898_(null, 2001, pos, Block.m_49956_((BlockState)state));
    }
}

