/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.fluid_generators;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.fluid_generators.IFluidGenerator;
import com.ordana.immersive_weathering.data.position_tests.PositionRuleTest;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.material.Fluid;

public class SelfFluidGenerator
implements IFluidGenerator {
    public static final Codec<SelfFluidGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Registry.f_122822_.m_194605_().fieldOf("fluid").forGetter(SelfFluidGenerator::getFluid), (App)IFluidGenerator.FluidType.CODEC.optionalFieldOf("fluid_type", (Object)IFluidGenerator.FluidType.BOTH).forGetter(SelfFluidGenerator::getFluidType), (App)BlockState.f_61039_.fieldOf("generate").forGetter(SelfFluidGenerator::getGrowth), (App)AdjacentBlocks.CODEC.fieldOf("adjacent_blocks").forGetter(SelfFluidGenerator::getAdjacentBlocksCondition), (App)PositionRuleTest.CODEC.optionalFieldOf("additional_target_check").forGetter(SelfFluidGenerator::getPositionTests), (App)Codec.INT.optionalFieldOf("priority", (Object)0).forGetter(SelfFluidGenerator::getPriority)).apply((Applicative)instance, SelfFluidGenerator::new));
    public static final IFluidGenerator.Type<SelfFluidGenerator> TYPE = new IFluidGenerator.Type<SelfFluidGenerator>(CODEC, "target_self");
    private final Fluid fluid;
    private final IFluidGenerator.FluidType fluidType;
    private final BlockState growth;
    private final Optional<PositionRuleTest> positionTests;
    private final int priority;
    private final AdjacentBlocks adjacentBlocksCondition;

    public SelfFluidGenerator(Fluid fluid, IFluidGenerator.FluidType fluidType, BlockState growth, AdjacentBlocks adjacentBlocks, Optional<PositionRuleTest> positionRuleTests, int priority) {
        this.fluid = fluid;
        this.fluidType = fluidType;
        this.growth = growth;
        this.adjacentBlocksCondition = adjacentBlocks;
        this.positionTests = positionRuleTests;
        this.priority = priority;
    }

    @Override
    public IFluidGenerator.FluidType getFluidType() {
        return this.fluidType;
    }

    @Override
    public IFluidGenerator.Type<?> getType() {
        return TYPE;
    }

    @Override
    public Fluid getFluid() {
        return this.fluid;
    }

    public BlockState getGrowth() {
        return this.growth;
    }

    public Optional<PositionRuleTest> getPositionTests() {
        return this.positionTests;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    public AdjacentBlocks getAdjacentBlocksCondition() {
        return this.adjacentBlocksCondition;
    }

    @Override
    public Optional<BlockPos> tryGenerating(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache) {
        if (!this.adjacentBlocksCondition.isMet(possibleFlowDir, pos, level, neighborCache, this.positionTests)) {
            return Optional.empty();
        }
        if (pos != null) {
            level.m_46597_(pos, this.growth);
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static class AdjacentBlocks {
        public static final Codec<AdjacentBlocks> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RuleTest.f_74307_.listOf().optionalFieldOf("sides", List.of()).forGetter(a -> a.sidesBlocks), (App)RuleTest.f_74307_.listOf().optionalFieldOf("any", List.of()).forGetter(a -> a.anyBlocks), (App)RuleTest.f_74307_.optionalFieldOf("up").forGetter(a -> Optional.ofNullable(a.upBlock)), (App)RuleTest.f_74307_.optionalFieldOf("down").forGetter(a -> Optional.ofNullable(a.downBlock))).apply((Applicative)instance, AdjacentBlocks::new)).comapFlatMap(arg -> {
            if (arg.sidesBlocks.isEmpty() && arg.anyBlocks.isEmpty() && arg.upBlock == null && arg.downBlock == null) {
                return DataResult.error((String)"Adjacent Blocks must contain at least one predicate");
            }
            return DataResult.success((Object)arg);
        }, Function.identity());
        private final List<RuleTest> anyBlocks;
        private final List<RuleTest> sidesBlocks;
        private final RuleTest upBlock;
        private final RuleTest downBlock;

        public AdjacentBlocks(List<RuleTest> sidesBlocks, List<RuleTest> anyBlocks, Optional<RuleTest> upBlock, Optional<RuleTest> downBlock) {
            this.sidesBlocks = sidesBlocks;
            this.anyBlocks = anyBlocks;
            this.upBlock = upBlock.orElse(null);
            this.downBlock = downBlock.orElse(null);
        }

        public boolean isMet(List<Direction> possibleFlowDir, BlockPos pos, Level level, Map<Direction, BlockState> neighborCache, Optional<PositionRuleTest> extraCheck) {
            BlockPos target;
            Direction d;
            boolean atLeastOnceSuccess;
            Holder b = extraCheck.isPresent() ? level.m_204166_(pos) : null;
            for (RuleTest r : this.anyBlocks) {
                atLeastOnceSuccess = false;
                for (Direction d2 : Direction.values()) {
                    BlockPos side = pos.m_142300_(d2);
                    BlockState state = neighborCache.computeIfAbsent(d2, p -> level.m_8055_(side));
                    if (!r.m_7715_(state, level.f_46441_) || b != null && !extraCheck.get().test((Holder<Biome>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            for (RuleTest r : this.sidesBlocks) {
                atLeastOnceSuccess = false;
                for (Direction d3 : possibleFlowDir) {
                    BlockPos side;
                    BlockState state;
                    if (!d3.m_122434_().m_122479_() || !r.m_7715_(state = neighborCache.computeIfAbsent(d3, arg_0 -> AdjacentBlocks.lambda$isMet$7(level, side = pos.m_142300_(d3), arg_0)), level.f_46441_) || b != null && !extraCheck.get().test((Holder<Biome>)b, side, level)) continue;
                    atLeastOnceSuccess = true;
                    break;
                }
                if (atLeastOnceSuccess) continue;
                return false;
            }
            if (this.upBlock != null) {
                d = Direction.UP;
                target = pos.m_142300_(d);
                BlockState state = neighborCache.computeIfAbsent(d, p -> level.m_8055_(target));
                if (!this.upBlock.m_7715_(state, level.f_46441_)) {
                    return false;
                }
                if (b != null && !extraCheck.get().test((Holder<Biome>)b, pos, level)) {
                    return false;
                }
            }
            if (this.downBlock != null) {
                d = Direction.DOWN;
                target = pos.m_142300_(d);
                BlockState state = neighborCache.computeIfAbsent(d, p -> level.m_8055_(target));
                if (!this.downBlock.m_7715_(state, level.f_46441_)) {
                    return false;
                }
                if (b != null && !extraCheck.get().test((Holder<Biome>)b, target, level)) {
                    return false;
                }
            }
            return true;
        }

        private static /* synthetic */ BlockState lambda$isMet$7(Level level, BlockPos side, Direction p) {
            return level.m_8055_(side);
        }
    }
}

