/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.data.block_growths.growths;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.ordana.immersive_weathering.data.block_growths.BlockPair;
import com.ordana.immersive_weathering.data.block_growths.TickSource;
import com.ordana.immersive_weathering.data.block_growths.area_condition.AreaCondition;
import com.ordana.immersive_weathering.data.block_growths.growths.IBlockGrowth;
import com.ordana.immersive_weathering.data.position_tests.PositionRuleTest;
import com.ordana.immersive_weathering.mixins.accessors.RandomBlockMatchTestAccessor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import net.mehvahdjukaar.moonlight.api.platform.PlatformHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.AlwaysTrueTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import org.jetbrains.annotations.Nullable;

public class ConfigurableBlockGrowth
implements IBlockGrowth {
    public static final ConfigurableBlockGrowth EMPTY = new ConfigurableBlockGrowth(List.of(), 1.0f, (RuleTest)AlwaysTrueTest.f_73954_, AreaCondition.EMPTY, List.of(), Optional.of(HolderSet.m_205809_((Holder[])new Holder[]{Holder.m_205709_((Object)Blocks.f_50016_)})), List.of(), false, false);
    public static final Codec<ConfigurableBlockGrowth> CODEC = RecordCodecBuilder.create(instance -> {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.IndexOutOfBoundsException: Index 0 out of bounds for length 0
         *     at java.base/jdk.internal.util.Preconditions.outOfBounds(Preconditions.java:100)
         *     at java.base/jdk.internal.util.Preconditions.outOfBoundsCheckIndex(Preconditions.java:106)
         *     at java.base/jdk.internal.util.Preconditions.checkIndex(Preconditions.java:302)
         *     at java.base/java.util.Objects.checkIndex(Objects.java:385)
         *     at java.base/java.util.ArrayList.get(ArrayList.java:427)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:368)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.applyExpressionRewriter(CastExpression.java:128)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.rewriteExpressions(StructuredReturn.java:99)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    });
    @Nullable
    private final HolderSet<Block> owners;
    private final List<TickSource> tickSources;
    private final float growthChance;
    private final RuleTest targetPredicate;
    private final SimpleWeightedRandomList<Direction> growthForDirection;
    private final Map<Direction, SimpleWeightedRandomList<BlockPair>> blockGrowths;
    private final Set<Block> possibleBlocks;
    private final List<PositionRuleTest> positionTests;
    private final boolean targetSelf;
    private final boolean destroyTarget;
    private final int maxRange;
    private final AreaCondition areaCondition;

    public ConfigurableBlockGrowth(List<TickSource> sources, float growthChance, RuleTest targetPredicate, AreaCondition areaCheck, List<DirectionalList> growthForDirection, Optional<HolderSet<Block>> owners, List<PositionRuleTest> biomePredicates, Boolean targetSelf, Boolean destroyTarget) {
        this.tickSources = sources;
        this.growthChance = growthChance;
        this.owners = owners.orElse(null);
        this.positionTests = biomePredicates;
        this.targetPredicate = targetPredicate;
        SimpleWeightedRandomList.Builder dirBuilder = SimpleWeightedRandomList.m_146263_();
        ImmutableMap.Builder growthBuilder = new ImmutableMap.Builder();
        ImmutableSet.Builder blockBuilder = new ImmutableSet.Builder();
        for (DirectionalList randomBlockList : growthForDirection) {
            if (randomBlockList.direction.isEmpty()) {
                dirBuilder = SimpleWeightedRandomList.m_146263_();
                growthBuilder = new ImmutableMap.Builder();
                blockBuilder = new ImmutableSet.Builder();
                this.decodeRandomList(Direction.UP, (SimpleWeightedRandomList.Builder<Direction>)dirBuilder, (ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>>)growthBuilder, (ImmutableSet.Builder<Block>)blockBuilder, randomBlockList);
                for (Direction d : Direction.values()) {
                    if (d == Direction.UP) continue;
                    growthBuilder.put((Object)d, randomBlockList.randomList);
                    dirBuilder.m_146271_((Object)d, 1);
                }
                break;
            }
            this.decodeRandomList(randomBlockList.direction.get(), (SimpleWeightedRandomList.Builder<Direction>)dirBuilder, (ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>>)growthBuilder, (ImmutableSet.Builder<Block>)blockBuilder, randomBlockList);
        }
        this.growthForDirection = dirBuilder.m_146270_();
        this.blockGrowths = growthBuilder.build();
        this.possibleBlocks = blockBuilder.build();
        this.areaCondition = areaCheck;
        this.maxRange = this.areaCondition.getMaxRange();
        this.targetSelf = targetSelf;
        this.destroyTarget = destroyTarget;
    }

    private void decodeRandomList(Direction direction, SimpleWeightedRandomList.Builder<Direction> dirBuilder, ImmutableMap.Builder<Direction, SimpleWeightedRandomList<BlockPair>> growthBuilder, ImmutableSet.Builder<Block> blockBuilder, DirectionalList v) {
        int weight = v.weight.orElse(1);
        dirBuilder.m_146271_((Object)direction, weight);
        growthBuilder.put((Object)direction, v.randomList);
        v.randomList.m_146338_().stream().map(WeightedEntry.Wrapper::m_146310_).forEach(o -> {
            BlockState s;
            BlockState f = (BlockState)o.getFirst();
            if (f != null) {
                blockBuilder.add((Object)f.m_60734_());
            }
            if ((s = (BlockState)o.getFirst()) != null) {
                blockBuilder.add((Object)s.m_60734_());
            }
        });
    }

    public List<DirectionalList> encodeRandomLists() {
        ArrayList<DirectionalList> list = new ArrayList<DirectionalList>();
        for (WeightedEntry.Wrapper e : this.growthForDirection.m_146338_()) {
            Optional<Integer> weight;
            Optional<Direction> dir;
            if (this.growthForDirection.m_146338_().size() == 1) {
                dir = Optional.empty();
                weight = Optional.empty();
            } else {
                dir = Optional.of((Direction)e.m_146310_());
                weight = Optional.of(e.m_142631_().m_146281_());
            }
            list.add(new DirectionalList(dir, weight, this.blockGrowths.get(e.m_146310_())));
        }
        return list;
    }

    public RuleTest getTargetPredicate() {
        return this.targetPredicate;
    }

    public AreaCondition getAreaCondition() {
        return this.areaCondition;
    }

    public Set<Block> getPossibleBlocks() {
        return this.possibleBlocks;
    }

    public boolean targetSelf() {
        return this.targetSelf;
    }

    public boolean destroyTarget() {
        return this.destroyTarget;
    }

    public List<PositionRuleTest> getPositionTests() {
        return this.positionTests;
    }

    public List<TickSource> getTickSources() {
        return this.tickSources;
    }

    public boolean isEmpty() {
        return this.possibleBlocks.isEmpty();
    }

    private boolean canGrow(BlockPos pos, Level level, Holder<Biome> biome) {
        if (this.growthChance == 0.0f) {
            return false;
        }
        if (level.f_46441_.nextFloat() < this.growthChance) {
            for (PositionRuleTest positionTest : this.positionTests) {
                if (positionTest.test(biome, pos, level)) continue;
                return false;
            }
            return PlatformHelper.isAreaLoaded((LevelReader)level, pos, this.maxRange);
        }
        return false;
    }

    public float getGrowthChance() {
        return this.growthChance;
    }

    @Nullable
    public Iterable<Block> getOwners() {
        if (this.owners == null) {
            return null;
        }
        return this.owners.m_203614_().map(Holder::m_203334_).collect(Collectors.toList());
    }

    @Override
    public void tryGrowing(BlockPos pos, BlockState self, ServerLevel level, Holder<Biome> biome) {
        if (this.canGrow(pos, (Level)level, biome)) {
            Direction dir = this.growthForDirection.m_146266_(level.f_46441_).orElse(Direction.UP);
            Random seed = new Random(Mth.m_14057_((Vec3i)pos));
            BlockPos targetPos = this.targetSelf ? pos : pos.m_142300_(dir);
            BlockState target = level.m_8055_(targetPos);
            if (this.targetSelf || this.targetPredicate.m_7715_(target, seed)) {
                BlockPair toPlace;
                SimpleWeightedRandomList<BlockPair> l;
                RuleTest ruleTest;
                if (this.targetSelf && (ruleTest = this.targetPredicate) instanceof RandomBlockMatchTestAccessor) {
                    RandomBlockMatchTestAccessor rbm = (RandomBlockMatchTestAccessor)ruleTest;
                    if (!(seed.nextFloat() < rbm.getProbability())) {
                        return;
                    }
                }
                if ((l = this.blockGrowths.get(dir)) != null && (toPlace = (BlockPair)l.m_146266_(level.f_46441_).orElse(null)) != null && ((BlockState)toPlace.getFirst()).m_60710_((LevelReader)level, targetPos)) {
                    BlockPos targetPos2 = null;
                    BlockState target2 = null;
                    boolean db = toPlace.isDouble();
                    if (db && !this.targetPredicate.m_7715_(target2 = level.m_8055_(targetPos2 = targetPos.m_142300_(dir)), seed = new Random(Mth.m_14057_((Vec3i)pos)))) {
                        return;
                    }
                    if (this.areaCondition.test(pos, (Level)level, this)) {
                        if (this.destroyTarget) {
                            level.m_46961_(targetPos, true);
                        }
                        BlockState bb = this.setWaterIfNeeded((BlockState)toPlace.getFirst(), target);
                        bb = Block.m_49931_((BlockState)bb, (LevelAccessor)level, (BlockPos)targetPos);
                        level.m_7731_(targetPos, bb, 2);
                        if (db) {
                            if (this.destroyTarget) {
                                level.m_46961_(targetPos2, true);
                            }
                            BlockState bb2 = this.setWaterIfNeeded((BlockState)toPlace.getFirst(), target2);
                            bb2 = Block.m_49931_((BlockState)bb2, (LevelAccessor)level, (BlockPos)targetPos2);
                            level.m_7731_(targetPos2, bb2, 2);
                        }
                    }
                }
            }
        }
    }

    private BlockState setWaterIfNeeded(BlockState toPlace, BlockState target) {
        if (toPlace.m_61138_((Property)BlockStateProperties.f_61362_) && target.m_60819_().m_205070_(FluidTags.f_13131_)) {
            return (BlockState)toPlace.m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true));
        }
        return toPlace;
    }

    private static /* synthetic */ Optional lambda$static$0(ConfigurableBlockGrowth b) {
        return Optional.ofNullable(b.owners);
    }

    public record DirectionalList(Optional<Direction> direction, Optional<Integer> weight, SimpleWeightedRandomList<BlockPair> randomList) {
        public static final Codec<DirectionalList> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Direction.f_175356_.optionalFieldOf("direction").forGetter(DirectionalList::direction), (App)Codec.INT.optionalFieldOf("weight").forGetter(DirectionalList::weight), (App)SimpleWeightedRandomList.m_146264_(BlockPair.CODEC).fieldOf("growth").forGetter(DirectionalList::randomList)).apply((Applicative)instance, DirectionalList::new));
    }
}

