/*
 * Decompiled with CFR 0.152.
 */
package com.ordana.immersive_weathering.blocks;

import com.google.common.collect.Lists;
import com.ordana.immersive_weathering.blocks.ModBlockProperties;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.ParticleUtils;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class IvyBlock
extends MultifaceBlock
implements BonemealableBlock {
    public static final IntegerProperty AGE = ModBlockProperties.AGE;
    public static final int MAX_AGE = 10;

    public IvyBlock(BlockBehaviour.Properties settings) {
        super(settings);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(7)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE});
    }

    protected BlockState age(BlockState state) {
        return state.m_61138_((Property)AGE) ? (BlockState)state.m_61122_((Property)AGE) : state;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext ctx) {
        Level world = ctx.m_43725_();
        BlockPos blockPos = ctx.m_8083_();
        BlockState blockState = world.m_8055_(blockPos);
        return Arrays.stream(ctx.m_6232_()).map(direction -> this.m_153940_(blockState, (BlockGetter)world, blockPos, (Direction)direction)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public boolean m_6724_(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) < 10;
    }

    public boolean m_7370_(BlockGetter world, BlockPos pos, BlockState state, boolean isClient) {
        return Stream.of(f_153806_).anyMatch(direction -> this.m_153948_(state, world, pos, direction.m_122424_()));
    }

    public boolean m_5491_(Level world, Random random, BlockPos pos, BlockState state) {
        return this.canGrowPseudoAdjacent(world, pos, state) || this.canGrowAdjacent(world, pos, state) || this.canGrowExternal(world, pos, state);
    }

    public void m_7455_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        int methodThree;
        int method = random.nextInt(3);
        if (method == 0 ? this.growPseudoAdjacent((Level)world, random, pos, state) : (method == 1 ? this.growAdjacent((Level)world, random, pos, state) : this.growExternal((Level)world, random, pos, state))) {
            return;
        }
        int methodTwo = random.nextInt(3);
        if (methodTwo == method) {
            boolean side = random.nextBoolean();
            int n = method == 0 ? (side ? 1 : 2) : (method == 1 ? (side ? 0 : 2) : (methodTwo = side ? 0 : 1));
        }
        if (methodTwo == 0 ? this.growPseudoAdjacent((Level)world, random, pos, state) : (methodTwo == 1 ? this.growAdjacent((Level)world, random, pos, state) : this.growExternal((Level)world, random, pos, state))) {
            return;
        }
        int n = method == 0 ? (methodTwo == 1 ? 2 : 1) : (method == 1 ? (methodTwo == 0 ? 2 : 0) : (methodThree = methodTwo == 2 ? 0 : 2));
        if (methodThree == 0) {
            this.growPseudoAdjacent((Level)world, random, pos, state);
        } else if (methodThree == 1) {
            this.growAdjacent((Level)world, random, pos, state);
        } else {
            this.growExternal((Level)world, random, pos, state);
        }
    }

    public static boolean isIvyPos(BlockPos pos) {
        Random posRandom = new Random(Mth.m_14057_((Vec3i)pos));
        return posRandom.nextInt(2) == 0;
    }

    public void m_7719_(ServerLevel world, Random random, BlockPos pos, BlockState state) {
        int methodThree;
        world.m_46597_(pos, (BlockState)state.m_60734_().m_152465_(state).m_61124_((Property)AGE, (Comparable)Integer.valueOf(0)));
        int method = random.nextInt(3);
        if (method == 0 ? this.growPseudoAdjacent((Level)world, random, pos, state) : (method == 1 ? this.growAdjacent((Level)world, random, pos, state) : this.growExternal((Level)world, random, pos, state))) {
            return;
        }
        int methodTwo = random.nextInt(3);
        if (methodTwo == method) {
            boolean side = random.nextBoolean();
            int n = method == 0 ? (side ? 1 : 2) : (method == 1 ? (side ? 0 : 2) : (methodTwo = side ? 0 : 1));
        }
        if (methodTwo == 0 ? this.growPseudoAdjacent((Level)world, random, pos, state) : (methodTwo == 1 ? this.growAdjacent((Level)world, random, pos, state) : this.growExternal((Level)world, random, pos, state))) {
            return;
        }
        int n = method == 0 ? (methodTwo == 1 ? 2 : 1) : (method == 1 ? (methodTwo == 0 ? 2 : 0) : (methodThree = methodTwo == 2 ? 0 : 2));
        if (methodThree == 0) {
            this.growPseudoAdjacent((Level)world, random, pos, state);
        } else if (methodThree == 1) {
            this.growAdjacent((Level)world, random, pos, state);
        } else {
            this.growExternal((Level)world, random, pos, state);
        }
    }

    public List<Direction> getFacingDirections(BlockState state) {
        ArrayList facing = Lists.newArrayList();
        for (Direction dir : Direction.values()) {
            if (!((Boolean)state.m_61143_((Property)MultifaceBlock.m_153933_((Direction)dir))).booleanValue()) continue;
            facing.add(dir);
        }
        return facing;
    }

    public boolean growPseudoAdjacent(Level world, Random random, BlockPos pos, BlockState state) {
        BlockState newStateHere = state;
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction dir : shuffledDirections) {
            BlockState attemptedStateHere = (BlockState)newStateHere.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
            if (this.m_7898_(attemptedStateHere, (LevelReader)world, pos)) {
                newStateHere = attemptedStateHere;
            }
            if (newStateHere.equals(state)) continue;
            world.m_46597_(pos, newStateHere);
            return true;
        }
        return false;
    }

    public boolean canGrowPseudoAdjacent(Level world, BlockPos pos, BlockState state) {
        BlockState newStateHere = state;
        for (Direction dir : Direction.values()) {
            BlockState attemptedStateHere = (BlockState)newStateHere.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
            if (this.m_7898_(attemptedStateHere, (LevelReader)world, pos)) {
                newStateHere = attemptedStateHere;
            }
            if (newStateHere.equals(state)) continue;
            return true;
        }
        return false;
    }

    public boolean growAdjacent(Level world, Random random, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        Collections.shuffle(facing, random);
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : shuffledDirections) {
                if (idealFacingDir.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && !dir.equals((Object)Direction.UP)) {
                    if (dir.equals((Object)Direction.DOWN) && random.nextDouble() < 0.9) {
                        return false;
                    }
                    if (dir.m_122434_().m_122480_() == Direction.Plane.HORIZONTAL && random.nextDouble() < 0.25) {
                        return false;
                    }
                }
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos adjacentPos = pos.m_142300_(dir);
                BlockState adjacentState = world.m_8055_(adjacentPos);
                BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true));
                if (!adjacentState.m_60795_() && !adjacentState.m_60713_((Block)this) || !this.m_7898_(newState, (LevelReader)world, adjacentPos) || !IvyBlock.isIvyPos(adjacentPos)) continue;
                BlockState finalNewState = adjacentState.m_60713_((Block)this) ? (BlockState)adjacentState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true)) : ((Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newState);
                world.m_46597_(adjacentPos, finalNewState);
                if (finalNewState.equals(adjacentState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowAdjacent(Level world, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : Direction.values()) {
                BlockState finalNewState;
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos adjacentPos = pos.m_142300_(dir);
                BlockState adjacentState = world.m_8055_(adjacentPos);
                BlockState newState = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true));
                if (!adjacentState.m_60795_() && !adjacentState.m_60713_((Block)this) || !this.m_7898_(newState, (LevelReader)world, adjacentPos)) continue;
                BlockState blockState = adjacentState.m_60713_((Block)this) ? (BlockState)adjacentState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)idealFacingDir), (Comparable)Boolean.valueOf(true)) : (finalNewState = (Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newState.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newState);
                if (finalNewState.equals(adjacentState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean growExternal(Level world, Random random, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        Collections.shuffle(facing, random);
        ArrayList shuffledDirections = Lists.newArrayList((Object[])Direction.values());
        Collections.shuffle(shuffledDirections, random);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : shuffledDirections) {
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos externalPos = pos.m_142300_(idealFacingDir).m_142300_(dir);
                BlockState externalState = world.m_8055_(externalPos);
                BlockState newStateOpposed = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                if (!world.m_8055_(pos.m_142300_(dir)).m_60795_() || !externalState.m_60795_() && !externalState.m_60713_((Block)this) || !this.m_7898_(newStateOpposed, (LevelReader)world, externalPos) || !IvyBlock.isIvyPos(externalPos)) continue;
                BlockState finalNewState = externalState.m_60713_((Block)this) ? (BlockState)externalState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true)) : ((Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newStateOpposed.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newStateOpposed);
                world.m_46597_(externalPos, finalNewState);
                if (finalNewState.equals(externalState)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean canGrowExternal(Level world, BlockPos pos, BlockState state) {
        List<Direction> facing = this.getFacingDirections(state);
        for (Direction idealFacingDir : facing) {
            for (Direction dir : Direction.values()) {
                BlockState finalNewState;
                if (dir.m_122434_() == idealFacingDir.m_122434_()) continue;
                BlockPos externalPos = pos.m_142300_(idealFacingDir).m_142300_(dir);
                BlockState externalState = world.m_8055_(externalPos);
                BlockState newStateOpposed = (BlockState)this.m_49966_().m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true));
                if (!world.m_8055_(pos.m_142300_(dir)).m_60795_() || !externalState.m_60795_() && !externalState.m_60713_((Block)this) || !this.m_7898_(newStateOpposed, (LevelReader)world, externalPos)) continue;
                BlockState blockState = externalState.m_60713_((Block)this) ? (BlockState)externalState.m_61124_((Property)MultifaceBlock.m_153933_((Direction)dir.m_122424_()), (Comparable)Boolean.valueOf(true)) : (finalNewState = (Integer)state.m_61143_((Property)AGE) < 10 ? (BlockState)newStateOpposed.m_61124_((Property)AGE, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)AGE) + 1)) : newStateOpposed);
                if (finalNewState.equals(externalState)) continue;
                return true;
            }
        }
        return false;
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack stack = player.m_21120_(hand);
        if (stack.m_41720_() instanceof FlintAndSteelItem && (Integer)state.m_61143_((Property)AGE) < 10) {
            level.m_5594_(player, pos, SoundEvents.f_184217_, SoundSource.BLOCKS, 1.0f, 1.0f);
            ParticleUtils.m_144962_((Level)level, (BlockPos)pos, (ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), (UniformInt)UniformInt.m_146622_((int)3, (int)5));
            if (player instanceof ServerPlayer) {
                if (!player.m_150110_().f_35937_) {
                    stack.m_41629_(1, new Random(), null);
                }
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(10)));
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6227_(state, level, pos, player, hand, hit);
    }
}

