/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.betterdungeons.module;

import com.yungnickyoung.minecraft.betterdungeons.BetterDungeonsCommon;
import com.yungnickyoung.minecraft.betterdungeons.module.StructureFeatureModule;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.skeleton_dungeon.SkeletonDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.small_dungeon.SmallDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.spider_dungeon.SpiderDungeonStructure;
import com.yungnickyoung.minecraft.betterdungeons.world.structure.zombie_dungeon.ZombieDungeonStructure;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistry;

public class StructureFeatureModuleForge {
    public static void init() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(StructureFeature.class, StructureFeatureModuleForge::registerStructures);
        MinecraftForge.EVENT_BUS.addListener(StructureFeatureModuleForge::removeVanillaDungeons);
    }

    private static void registerStructures(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        StructureFeatureModule.SMALL_DUNGEON = StructureFeatureModuleForge.register(registry, "small_dungeon", new SmallDungeonStructure());
        StructureFeatureModule.SPIDER_DUNGEON = StructureFeatureModuleForge.register(registry, "spider_dungeon", new SpiderDungeonStructure());
        StructureFeatureModule.SKELETON_DUNGEON = StructureFeatureModuleForge.register(registry, "skeleton_dungeon", new SkeletonDungeonStructure());
        StructureFeatureModule.ZOMBIE_DUNGEON = StructureFeatureModuleForge.register(registry, "zombie_dungeon", new ZombieDungeonStructure());
    }

    private static <FC extends FeatureConfiguration> StructureFeature<FC> register(IForgeRegistry<StructureFeature<?>> registry, String name, StructureFeature<FC> structureFeature) {
        structureFeature.setRegistryName(new ResourceLocation("betterdungeons", name));
        registry.register(structureFeature);
        return structureFeature;
    }

    private static void removeVanillaDungeons(BiomeLoadingEvent event) {
        if (event.getName() == null) {
            BetterDungeonsCommon.LOGGER.error("Missing biome name! This is a critical error and should not occur.");
            BetterDungeonsCommon.LOGGER.error("Try running the game with the Blame mod for a more detailed breakdown.");
            BetterDungeonsCommon.LOGGER.error("Please report this issue!");
            return;
        }
        if (BetterDungeonsCommon.CONFIG.general.removeVanillaDungeons) {
            event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_STRUCTURES).removeIf(s -> ((ConfiguredFeature)((PlacedFeature)s.m_203334_()).f_191775_().m_203334_()).f_65377_() == Feature.f_65777_);
        }
    }
}

