/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsTargetGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GDFallingBlockEntity;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class OgreEntity
extends GoblinEntity {
    private static final UniformInt field_234196_bu_ = TimeUtil.m_145020_((int)20, (int)39);
    private int field_234197_bv_;
    private UUID field_234198_bw_;
    private int attackTimer;
    private static final EntityDataAccessor<Boolean> ROARING = SynchedEntityData.m_135353_(OgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> BUTT_SMASH = SynchedEntityData.m_135353_(OgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_BUTT_SMASH = SynchedEntityData.m_135353_(OgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CAN_ROAR = SynchedEntityData.m_135353_(OgreEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int roarTicks = 1800;
    private int buttSmashTicks = 900;

    public OgreEntity(EntityType<? extends OgreEntity> type, Level worldIn) {
        super(type, worldIn);
        this.f_19793_ = 1.0f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new AttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(2, (Goal)new MoveTowardsTargetGoal((PathfinderMob)this, 0.9, 32.0f));
        this.f_21345_.m_25352_(7, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(2, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, AbstractVillager.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Raider.class, true));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, IronGolem.class, true));
        this.f_21346_.m_25352_(1, (Goal)new RoarGoal());
        this.f_21346_.m_25352_(1, (Goal)new ButtSmashGoal(this));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0).m_22268_(Attributes.f_22279_, (double)0.15f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22277_, 25.0).m_22268_(Attributes.f_22278_, 25.0);
    }

    protected SoundEvent m_7515_() {
        return SoundInit.OGRE_IDLE;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.OGRE_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.OGRE_DEATH;
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean isRoaring() {
        return (Boolean)this.f_19804_.m_135370_(ROARING);
    }

    private void setRoaring(boolean isRoaring) {
        this.f_19804_.m_135381_(ROARING, (Object)isRoaring);
    }

    public boolean isFallingOnButt() {
        return (Boolean)this.f_19804_.m_135370_(BUTT_SMASH);
    }

    private void setFallingOnButt(boolean buttSmash) {
        this.f_19804_.m_135381_(BUTT_SMASH, (Object)buttSmash);
    }

    public boolean canRoar() {
        return (Boolean)this.f_19804_.m_135370_(CAN_ROAR);
    }

    private void setCanRoar(boolean canRoar) {
        this.f_19804_.m_135381_(CAN_ROAR, (Object)canRoar);
    }

    public boolean canButtSmash() {
        return (Boolean)this.f_19804_.m_135370_(CAN_BUTT_SMASH);
    }

    private void setCanButtSmash(boolean canButtSmash) {
        this.f_19804_.m_135381_(CAN_BUTT_SMASH, (Object)canButtSmash);
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ROARING, (Object)false);
        this.f_19804_.m_135372_(BUTT_SMASH, (Object)false);
        this.f_19804_.m_135372_(CAN_ROAR, (Object)false);
        this.f_19804_.m_135372_(CAN_BUTT_SMASH, (Object)false);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsRoaring", this.isRoaring());
        compound.m_128379_("ButtSmash", this.isFallingOnButt());
        compound.m_128379_("CanRoar", this.canRoar());
        compound.m_128379_("CanButtSmash", this.canButtSmash());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setRoaring(compound.m_128471_("IsRoaring"));
        this.setFallingOnButt(compound.m_128471_("ButtSmash"));
        this.setCanButtSmash(compound.m_128471_("CanButtSmash"));
        this.setCanRoar(compound.m_128471_("CanRoar"));
    }

    public void m_8107_() {
        super.m_8107_();
        if (this.m_5448_() != null) {
            ++this.attackTimer;
        }
        if (this.attackTimer > 200 || this.m_5448_() == null) {
            this.attackTimer = 0;
        }
        if (this.buttSmashTicks > 0) {
            --this.buttSmashTicks;
        }
        if (this.roarTicks > 0) {
            --this.roarTicks;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public int getAttackTimer() {
        return this.attackTimer;
    }

    public void func_230258_H__() {
        this.setAngerTime(field_234196_bu_.m_142270_(this.f_19796_));
    }

    public void setAngerTime(int time) {
        this.field_234197_bv_ = time;
    }

    public int getAngerTime() {
        return this.field_234197_bv_;
    }

    public void setAngerTarget(@Nullable UUID target) {
        this.field_234198_bw_ = target;
    }

    public UUID getAngerTarget() {
        return this.field_234198_bw_;
    }

    private float func_226511_et_() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public boolean m_7327_(Entity entityIn) {
        this.f_19853_.m_7605_((Entity)this, (byte)4);
        float f = this.func_226511_et_();
        float f1 = (int)f > 0 ? f / 2.0f + (float)this.f_19796_.nextInt((int)f) : f;
        boolean flag = entityIn.m_6469_(DamageSource.m_19370_((LivingEntity)this), f1);
        if (flag) {
            entityIn.m_20256_(entityIn.m_20184_().m_82520_(0.0, (double)0.4f, 0.0));
            this.m_19970_((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        boolean flag = super.m_6469_(source, amount);
        return flag;
    }

    public void m_6667_(DamageSource cause) {
        super.m_6667_(cause);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vec3 func_241205_ce_() {
        return new Vec3(0.0, (double)(0.875f * this.m_20192_()), (double)(this.m_20205_() * 0.4f));
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.roarTicks == 0) {
            this.setCanRoar(true);
        }
        if (this.buttSmashTicks == 0) {
            this.setCanButtSmash(true);
        }
    }

    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ItemInit.OGRE_SPAWN_EGG.get());
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal(PathfinderMob creature, double speedIn, boolean useLongMemory) {
            super(creature, speedIn, useLongMemory);
        }

        public boolean m_8036_() {
            return OgreEntity.this.m_5448_() != null;
        }

        public boolean m_8045_() {
            return OgreEntity.this.m_5448_() != null && !OgreEntity.this.canButtSmash() && !OgreEntity.this.canRoar();
        }
    }

    class RoarGoal
    extends Goal {
        int timer = 0;

        RoarGoal() {
        }

        public boolean m_8036_() {
            return OgreEntity.this.m_5448_() != null && OgreEntity.this.canRoar();
        }

        public void m_8037_() {
            ++this.timer;
            if (this.timer == 50) {
                this.m_8041_();
            }
        }

        public void m_8056_() {
            OgreEntity.this.setRoaring(true);
            LivingEntity entity = OgreEntity.this.m_5448_();
            OgreEntity.this.f_19853_.m_5594_((Player)null, OgreEntity.this.m_142538_(), SoundInit.OGRE_ROAR, SoundSource.HOSTILE, 2.0f, 1.0f);
            OgreEntity.this.m_5496_(SoundInit.OGRE_ROAR, 1.0f, 1.0f);
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300, 1));
        }

        public boolean m_8045_() {
            return OgreEntity.this.m_5448_() != null && OgreEntity.this.canRoar();
        }

        public void m_8041_() {
            super.m_8041_();
            OgreEntity.this.setRoaring(false);
            OgreEntity.this.roarTicks = 1800;
            this.timer = 0;
        }
    }

    class ButtSmashGoal
    extends Goal {
        Boolean hasJumped = false;
        OgreEntity ogre;
        int timer;

        public ButtSmashGoal(OgreEntity ogre) {
            this.ogre = ogre;
        }

        public boolean m_8036_() {
            return this.ogre.m_5448_() != null && this.ogre.canButtSmash();
        }

        public boolean m_8045_() {
            return this.ogre.m_5448_() != null && this.ogre.canButtSmash();
        }

        public void m_8037_() {
            ++this.timer;
            if (this.ogre.m_20096_() && !this.hasJumped.booleanValue()) {
                this.ogre.m_20334_(0.0, 0.5, 0.0);
                this.hasJumped = true;
            }
            double perpFacing = this.ogre.f_19855_ * (Math.PI / 180);
            double facingAngle = perpFacing + 1.5707963267948966;
            int hitY = Mth.m_14107_((double)(this.ogre.m_142469_().f_82289_ - 0.5));
            int tick = this.timer;
            int maxDistance = 6;
            ServerLevel world = (ServerLevel)this.ogre.f_19853_;
            if (tick > 0) {
                int distance = tick / 2 - 2;
                double spread = Math.PI * 2;
                int arcLen = Mth.m_14165_((double)((double)distance * spread));
                double minY = this.ogre.m_142469_().f_82289_;
                double maxY = this.ogre.m_142469_().f_82292_;
                for (int i = 0; i < arcLen; ++i) {
                    double theta = ((double)i / ((double)arcLen - 1.0) - 0.5) * spread + facingAngle;
                    double vx = Math.cos(theta);
                    double vz = Math.sin(theta);
                    double px = this.ogre.m_20185_() + vx * (double)distance;
                    double pz = this.ogre.m_20189_() + vz * (double)distance;
                    float factor = 1.0f - (float)distance / 6.0f;
                    AABB selection = new AABB(px - 1.5, minY, pz - 1.5, px + 1.5, maxY, pz + 1.5);
                    List hit = world.m_45976_(Entity.class, selection);
                    for (Entity entity : hit) {
                        if (entity == this.ogre || entity instanceof GDFallingBlockEntity) continue;
                        float applyKnockbackResistance = 0.0f;
                        if (entity instanceof LivingEntity) {
                            entity.m_6469_(DamageSource.m_19370_((LivingEntity)this.ogre), (float)((double)(factor * 5.0f + 1.0f) * this.ogre.m_21133_(Attributes.f_22281_)));
                            applyKnockbackResistance = (float)((LivingEntity)entity).m_21051_(Attributes.f_22278_).m_22135_();
                        }
                        double magnitude = world.f_46441_.nextDouble() * 0.15 + 0.1;
                        float x = 0.0f;
                        float y = 0.0f;
                        float z = 0.0f;
                        x = (float)((double)x + vx * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        if (entity.m_20096_()) {
                            y = (float)((double)y + (0.1 * (double)(1.0f - applyKnockbackResistance) + (double)factor * 0.15 * (double)(1.0f - applyKnockbackResistance)));
                        }
                        z = (float)((double)z + vz * (double)factor * magnitude * (double)(1.0f - applyKnockbackResistance));
                        entity.m_20256_(entity.m_20184_().m_82520_((double)x, (double)y, (double)z));
                        if (entity instanceof ServerPlayer) {
                            ((ServerPlayer)entity).f_8906_.m_141995_((Packet)new ClientboundSetEntityMotionPacket(entity));
                        }
                        if (!world.f_46441_.nextBoolean()) continue;
                        int hitX = Mth.m_14107_((double)px);
                        int hitZ = Mth.m_14107_((double)pz);
                        BlockPos pos = new BlockPos(hitX, hitY, hitZ);
                        BlockPos abovePos = new BlockPos((Vec3i)pos).m_7494_();
                        BlockState block = world.m_8055_(pos);
                        BlockState blockAbove = world.m_8055_(abovePos);
                        if (block.m_60767_() == Material.f_76296_ || !block.m_60796_((BlockGetter)world, pos) || block.m_155947_() || blockAbove.m_60767_().m_76334_()) continue;
                        GDFallingBlockEntity fallingBlock = new GDFallingBlockEntity((EntityType)EntityInit.FALLING_BLOCK.get(), (Level)world, block, (float)(0.4 + (double)factor * 0.2));
                        fallingBlock.m_6034_((double)hitX + 0.5, hitY + 1, (double)hitZ + 0.5);
                        world.m_7967_((Entity)fallingBlock);
                    }
                }
            }
            if (!this.ogre.m_20096_()) {
                this.ogre.setFallingOnButt(true);
            } else {
                this.ogre.setFallingOnButt(false);
                this.m_8041_();
            }
        }

        public void m_8041_() {
            super.m_8041_();
            this.ogre.buttSmashTicks = 900;
            this.ogre.setCanButtSmash(false);
        }
    }
}

