/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.entity;

import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import superlord.goblinsanddungeons.entity.GoblinEntity;
import superlord.goblinsanddungeons.init.CreatureAttributeInit;
import superlord.goblinsanddungeons.init.SoundInit;

public class MimicEntity
extends GoblinEntity {
    private static final EntityDataAccessor<Boolean> HIDING = SynchedEntityData.m_135353_(MimicEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public MimicEntity(EntityType<? extends MimicEntity> p_i50196_1_, Level p_i50196_2_) {
        super(p_i50196_1_, p_i50196_2_);
    }

    public boolean isHiding() {
        return (Boolean)this.f_19804_.m_135370_(HIDING);
    }

    private void setHiding(boolean isHiding) {
        this.f_19804_.m_135381_(HIDING, (Object)isHiding);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new HidingLookGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(0, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21346_.m_25352_(2, (Goal)new AttackNearestGoal(this));
        this.f_21345_.m_25352_(0, (Goal)new HideGoal());
        this.f_21346_.m_25352_(1, (Goal)new DefendGoal((PathfinderMob)this));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HIDING, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22281_, 3.0);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setHiding(compound.m_128471_("IsHiding"));
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("IsHiding", this.isHiding());
    }

    public boolean canDespawn(double distanceToClosestPlayer) {
        return false;
    }

    public boolean m_8023_() {
        return super.m_8023_();
    }

    public InteractionResult m_6071_(Player p_230254_1_, InteractionHand p_230254_2_) {
        if (!this.f_19853_.f_46443_) {
            this.setHiding(false);
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(p_230254_1_, p_230254_2_);
    }

    public boolean m_7307_(Entity entityIn) {
        if (super.m_7307_(entityIn)) {
            return true;
        }
        if (entityIn instanceof LivingEntity && ((LivingEntity)entityIn).m_6336_() == CreatureAttributeInit.GOBLIN) {
            return this.m_5647_() == null && entityIn.m_5647_() == null;
        }
        return false;
    }

    public void m_7334_(Entity p_33474_) {
        if (this.isHiding()) {
            super.m_7334_(p_33474_);
        }
    }

    public boolean m_5829_() {
        return this.m_6084_();
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficulty, MobSpawnType reason, @Nullable SpawnGroupData spawnData, @Nullable CompoundTag compound) {
        spawnData = super.m_6518_(worldIn, difficulty, reason, spawnData, compound);
        this.setHiding(true);
        return spawnData;
    }

    protected SoundEvent m_7515_() {
        if (!this.isHiding()) {
            return SoundInit.MIMIC_IDLE;
        }
        return null;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return SoundInit.MIMIC_HURT;
    }

    protected SoundEvent m_5592_() {
        return SoundInit.MIMIC_DEATH;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (super.m_6469_(source, amount)) {
            this.setHiding(false);
            return true;
        }
        return false;
    }

    public void m_142223_(ClientboundAddMobPacket p_149798_) {
        super.m_142223_(p_149798_);
        this.f_20883_ = 0.0f;
        this.f_20884_ = 0.0f;
    }

    class HidingLookGoal
    extends LookAtPlayerGoal {
        public HidingLookGoal(Mob entityIn, Class<? extends Player> watchTargetClass, float maxDistance) {
            super(entityIn, watchTargetClass, maxDistance);
        }

        public boolean m_8036_() {
            return super.m_8036_() && !MimicEntity.this.isHiding();
        }
    }

    class AttackNearestGoal
    extends NearestAttackableTargetGoal<Player> {
        public AttackNearestGoal(MimicEntity mimic) {
            super((Mob)mimic, Player.class, true);
        }

        public boolean m_8036_() {
            return !MimicEntity.this.isHiding() && super.m_8036_();
        }

        public void m_8056_() {
            super.m_8056_();
            MimicEntity.this.setHiding(false);
        }

        public void m_8041_() {
            super.m_8041_();
        }
    }

    class HideGoal
    extends Goal {
        HideGoal() {
        }

        public boolean m_8036_() {
            return MimicEntity.this.m_5448_() == null;
        }

        public void startExecuting() {
            MimicEntity.this.setHiding(true);
        }
    }

    class DefendGoal
    extends HurtByTargetGoal {
        public DefendGoal(PathfinderMob creatureIn) {
            super(creatureIn, new Class[0]);
        }

        public void m_8056_() {
            super.m_8056_();
            MimicEntity.this.setHiding(false);
        }
    }
}

