/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GobloEntity;

@OnlyIn(value=Dist.CLIENT)
public class GobloModel<T extends Entity>
extends EntityModel<GobloEntity>
implements ArmedModel {
    private final ModelPart RightArm;
    private final ModelPart LeftLeg;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart Body;
    private final ModelPart Head;

    public GobloModel(ModelPart root) {
        this.RightArm = root.m_171324_("RightArm");
        this.LeftLeg = root.m_171324_("LeftLeg");
        this.LeftArm = root.m_171324_("LeftArm");
        this.RightLeg = root.m_171324_("RightLeg");
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition RightArm = partdefinition.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(41, 0).m_171488_(0.0f, -1.0f, -1.5f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)5.0f, (float)13.0f, (float)0.0f));
        PartDefinition LeftLeg = partdefinition.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(29, 13).m_171480_().m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.5f, (float)20.0f, (float)0.0f));
        PartDefinition LeftArm = partdefinition.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(41, 0).m_171480_().m_171488_(-2.0f, -1.0f, -1.5f, 2.0f, 9.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-5.0f, (float)13.0f, (float)0.0f));
        PartDefinition RightLeg = partdefinition.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(29, 13).m_171488_(-1.5f, 0.0f, -1.5f, 3.0f, 4.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.5f, (float)20.0f, (float)0.0f));
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 11).m_171488_(-5.0f, 0.0f, -4.5f, 10.0f, 10.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)10.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -2.0f, -9.0f, 10.0f, 2.0f, 9.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.5f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171488_(-5.0f, -4.0f, -1.0f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)0.0f, (float)-1.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(29, 0).m_171480_().m_171488_(0.0f, -4.0f, -1.0f, 5.0f, 4.0f, 1.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)0.0f, (float)-1.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(GobloEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
        this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        this.Head.f_104203_ = -Mth.m_14154_((float)(Mth.m_14089_((float)(limbSwing * 0.3331f)) * 0.35f * limbSwingAmount));
        ItemStack itemstack = entity.m_6844_(EquipmentSlot.MAINHAND);
        if (!itemstack.m_41619_()) {
            for (int i = 0; i < 8; ++i) {
                this.Head.f_104203_ = -Mth.m_14154_((float)(-0.5f * Mth.m_14031_((float)(1.5f * ageInTicks / 10.0f))));
            }
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.RightArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.LeftArm.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.RightLeg.m_104301_(poseStack, buffer, packedLight, packedOverlay);
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? 1.0f : -1.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.m_104299_(matrixStackIn);
        modelrenderer.f_104200_ -= f;
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.LEFT ? this.LeftArm : this.RightArm;
    }
}

