/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import superlord.goblinsanddungeons.entity.GobberEntity;

@OnlyIn(value=Dist.CLIENT)
public class GobberModel
extends EntityModel<GobberEntity>
implements ArmedModel {
    private final ModelPart Body;
    private final ModelPart Head;
    private final ModelPart RightPauldron;
    private final ModelPart LeftPauldron;
    private final ModelPart RightArm;
    private final ModelPart LeftArm;
    private final ModelPart RightLeg;
    private final ModelPart LeftLeg;

    public GobberModel(ModelPart root) {
        this.Body = root.m_171324_("Body");
        this.Head = this.Body.m_171324_("Head");
        this.RightPauldron = this.Body.m_171324_("RightPauldron");
        this.LeftPauldron = this.Body.m_171324_("LeftPauldron");
        this.RightArm = this.RightPauldron.m_171324_("RightArm");
        this.LeftArm = this.LeftPauldron.m_171324_("LeftArm");
        this.RightLeg = this.Body.m_171324_("RightLeg");
        this.LeftLeg = this.Body.m_171324_("LeftLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition Body = partdefinition.m_171599_("Body", CubeListBuilder.m_171558_().m_171514_(0, 13).m_171488_(-5.0f, 0.0f, -4.0f, 10.0f, 9.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition Head = Body.m_171599_("Head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -5.0f, -3.0f, 8.0f, 7.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition LeftEar = Head.m_171599_("LeftEar", CubeListBuilder.m_171558_().m_171514_(22, 0).m_171488_(-4.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-4.0f, (float)-3.0f, (float)0.0f));
        PartDefinition RightEar = Head.m_171599_("RightEar", CubeListBuilder.m_171558_().m_171514_(22, 3).m_171488_(0.0f, 0.0f, 0.0f, 4.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)-3.0f, (float)0.0f));
        PartDefinition RightPauldron = Body.m_171599_("RightPauldron", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171480_().m_171488_(0.0f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)5.0f, (float)2.0f, (float)0.0f));
        PartDefinition RightArm = RightPauldron.m_171599_("RightArm", CubeListBuilder.m_171558_().m_171514_(28, 13).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)1.0f, (float)0.0f));
        PartDefinition LeftPauldron = Body.m_171599_("LeftPauldron", CubeListBuilder.m_171558_().m_171514_(36, 22).m_171488_(-5.0f, -2.0f, -2.5f, 5.0f, 5.0f, 5.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-5.0f, (float)2.0f, (float)0.0f));
        PartDefinition LeftArm = LeftPauldron.m_171599_("LeftArm", CubeListBuilder.m_171558_().m_171514_(28, 5).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 6.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.0f, (float)1.0f, (float)0.0f));
        PartDefinition RightLeg = Body.m_171599_("RightLeg", CubeListBuilder.m_171558_().m_171514_(36, 9).m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)8.0f, (float)0.0f));
        PartDefinition LeftLeg = Body.m_171599_("LeftLeg", CubeListBuilder.m_171558_().m_171514_(36, 9).m_171480_().m_171488_(-1.0f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)8.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)32);
    }

    public void setupAnim(GobberEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.m_5803_()) {
            this.RightPauldron.f_104205_ = -0.225f * Mth.m_14031_((float)(0.6f * ageInTicks / 10.0f));
            this.LeftPauldron.f_104205_ = -(-0.225f * Mth.m_14031_((float)(0.6f * ageInTicks / 10.0f)));
            this.Head.f_104203_ = 0.25f;
            this.LeftArm.f_104203_ = 0.0f;
            this.RightArm.f_104203_ = 0.0f;
            this.RightLeg.f_104203_ = 0.0f;
            this.LeftLeg.f_104203_ = 0.0f;
        } else {
            this.RightPauldron.f_104205_ = 0.0f;
            this.LeftPauldron.f_104205_ = 0.0f;
            this.Head.f_104203_ = 0.0f;
            this.Head.f_104203_ = headPitch * ((float)Math.PI / 180);
            this.Head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
            this.RightLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
            this.LeftLeg.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.RightArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f + (float)Math.PI)) * 1.4f * limbSwingAmount;
            this.LeftArm.f_104203_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        }
    }

    public void m_7695_(PoseStack poseStack, VertexConsumer buffer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.Body.m_104301_(poseStack, buffer, packedLight, packedOverlay);
    }

    public void m_6002_(HumanoidArm sideIn, PoseStack matrixStackIn) {
        float f = sideIn == HumanoidArm.RIGHT ? -4.0f : 0.0f;
        float f1 = sideIn == HumanoidArm.RIGHT ? 10.0f : 0.0f;
        ModelPart modelrenderer = this.getArmForSide(sideIn);
        modelrenderer.f_104200_ += f;
        modelrenderer.f_104201_ += f1;
        modelrenderer.m_104299_(matrixStackIn);
        matrixStackIn.m_85837_(0.0, 0.0, 0.0);
        modelrenderer.f_104200_ -= f;
        modelrenderer.f_104201_ -= f1;
    }

    protected ModelPart getArmForSide(HumanoidArm side) {
        return side == HumanoidArm.RIGHT ? this.LeftArm : this.RightArm;
    }
}

