/*
 * Decompiled with CFR 0.152.
 */
package superlord.goblinsanddungeons;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import superlord.goblinsanddungeons.client.ClientProxy;
import superlord.goblinsanddungeons.common.CommonProxy;
import superlord.goblinsanddungeons.compat.QuarkFlagRecipeCondition;
import superlord.goblinsanddungeons.compat.RegistryHelper;
import superlord.goblinsanddungeons.config.GDConfigHolder;
import superlord.goblinsanddungeons.config.GoblinsDungeonsConfig;
import superlord.goblinsanddungeons.entity.GarchEntity;
import superlord.goblinsanddungeons.entity.GobEntity;
import superlord.goblinsanddungeons.entity.GobKingEntity;
import superlord.goblinsanddungeons.entity.GobberEntity;
import superlord.goblinsanddungeons.entity.GobloEntity;
import superlord.goblinsanddungeons.entity.GoomEntity;
import superlord.goblinsanddungeons.entity.HobGobEntity;
import superlord.goblinsanddungeons.entity.MimicEntity;
import superlord.goblinsanddungeons.entity.OgreEntity;
import superlord.goblinsanddungeons.init.BlockInit;
import superlord.goblinsanddungeons.init.EffectInit;
import superlord.goblinsanddungeons.init.EntityInit;
import superlord.goblinsanddungeons.init.ItemInit;
import superlord.goblinsanddungeons.init.PacketInit;
import superlord.goblinsanddungeons.init.StructureInit;
import superlord.goblinsanddungeons.init.TileEntityInit;
import superlord.goblinsanddungeons.world.GoblinsAndDungeonsFeatures;

@Mod(value="goblinsanddungeons")
@Mod.EventBusSubscriber(modid="goblinsanddungeons")
public class GoblinsAndDungeons {
    public static final String MOD_ID = "goblinsanddungeons";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final RegistryHelper REGISTRY_HELPER = new RegistryHelper("goblinsanddungeons");
    private static final String PROTOCOL_VERSION = "1";
    public static final SimpleChannel NETWORK_WRAPPER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("goblinsanddungeons", "main_channel")).clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).networkProtocolVersion(() -> "1").simpleChannel();
    public static GoblinsAndDungeons instance;
    public static CommonProxy PROXY;
    public static final CreativeModeTab GROUP;

    public GoblinsAndDungeons() {
        instance = this;
        ModLoadingContext modLoadingContext = ModLoadingContext.get();
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        bus.addListener(this::registerEntityAttributes);
        bus.addListener(this::clientRegistries);
        CraftingHelper.register((IConditionSerializer)new QuarkFlagRecipeCondition.Serializer());
        REGISTRY_HELPER.getDeferredBlockRegister().register(bus);
        REGISTRY_HELPER.getDeferredItemRegister().register(bus);
        BlockInit.REGISTER.register(bus);
        ItemInit.REGISTER.register(bus);
        EntityInit.REGISTER.register(bus);
        EffectInit.EFFECTS.register(bus);
        EffectInit.POTIONS.register(bus);
        TileEntityInit.REGISTER.register(bus);
        PacketInit.registerPackets();
        modLoadingContext.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)GDConfigHolder.CLIENT_SPEC);
        modLoadingContext.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)GDConfigHolder.SERVER_SPEC);
        IEventBus forgeBus = MinecraftForge.EVENT_BUS;
        forgeBus.addListener(EventPriority.HIGH, this::biomeModification);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void registerBiomes(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.BiomeCategory.PLAINS || event.getCategory() == Biome.BiomeCategory.SWAMP || event.getCategory() == Biome.BiomeCategory.TAIGA || event.getCategory() == Biome.BiomeCategory.FOREST) {
            event.getSpawns().getSpawner(MobCategory.CREATURE).add(new MobSpawnSettings.SpawnerData((EntityType)EntityInit.OGRE.get(), GoblinsDungeonsConfig.ogreSpawnWeight, 1, 1));
        }
    }

    public static ResourceLocation location(String name) {
        return new ResourceLocation(MOD_ID, name);
    }

    public void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> StructureInit.init());
        EffectInit.brewingRecipes();
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.OGRE.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GOB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.HOBGOB.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GARCH.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GOBBER.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GOBLO.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
        SpawnPlacements.m_21754_((EntityType)((EntityType)EntityInit.GOB_KING.get()), (SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (Heightmap.Types)Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, Monster::m_33023_);
    }

    public void clientRegistries(FMLClientSetupEvent event) {
    }

    private void registerEntityAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)EntityInit.GOB.get(), GobEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.HOBGOB.get(), HobGobEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.GOBLO.get(), GobloEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.GARCH.get(), GarchEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.GOOM.get(), GoomEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.GOBBER.get(), GobberEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.OGRE.get(), OgreEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.GOB_KING.get(), GobKingEntity.createAttributes().m_22265_());
        event.put((EntityType)EntityInit.MIMIC.get(), MimicEntity.createAttributes().m_22265_());
    }

    public void biomeModification(BiomeLoadingEvent event) {
        event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(GoblinsAndDungeonsFeatures.ORE_SCORIA_LOWER);
        event.getGeneration().getFeatures(GenerationStep.Decoration.UNDERGROUND_ORES).add(GoblinsAndDungeonsFeatures.ORE_SCORIA_UPPER);
    }

    public static GoblinsAndDungeons getInstance() {
        return instance;
    }

    static {
        PROXY = (CommonProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> CommonProxy::new);
        GROUP = new CreativeModeTab("goblinsanddungeons_item_group"){

            public ItemStack m_6976_() {
                return new ItemStack((ItemLike)ItemInit.GOBLIN_CROWN.get());
            }
        };
    }
}

