/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.core.generator;

import com.supermartijn642.core.generator.ResourceCache;
import com.supermartijn642.core.generator.ResourceGenerator;
import com.supermartijn642.core.generator.ResourceType;
import com.supermartijn642.core.generator.aggregator.TranslationsAggregator;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;

public abstract class LanguageGenerator
extends ResourceGenerator {
    private final Map<String, String> translations = new LinkedHashMap<String, String>();
    protected final String langCode;

    public LanguageGenerator(String modid, ResourceCache cache, String langCode) {
        super(modid, cache);
        if (!langCode.matches("[a-z]{2}_[a-z]{2}")) {
            throw new IllegalArgumentException("Invalid lang code '" + langCode + "'!");
        }
        this.langCode = langCode;
    }

    @Override
    public void save() {
        this.cache.saveResource(ResourceType.ASSET, TranslationsAggregator.INSTANCE, this.translations, this.modid, "lang", this.langCode, ".json");
    }

    protected void translation(String translationKey, String translation) {
        if (translationKey.isBlank()) {
            throw new IllegalArgumentException("Translation key '" + translation + "' for translation '" + translation + "' must not be empty!");
        }
        this.translations.put(translationKey, translation);
    }

    protected void itemGroup(CreativeModeTab group, String translation) {
        Component component = group.m_40786_();
        if (component instanceof TranslatableComponent) {
            this.translation(((TranslatableComponent)component).m_131328_(), translation);
        }
        this.translation(group.f_40763_, translation);
    }

    protected void item(Item item, String translation) {
        this.translation(item.m_5524_(), translation);
    }

    protected void block(Block block, String translation) {
        this.translation(block.m_7705_(), translation);
    }

    @Override
    public String getName() {
        return this.modName + " Language Generator";
    }
}

