/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.mod.vanilla;

import java.util.Collection;
import javax.annotation.Nullable;
import journeymap.client.JourneymapClient;
import journeymap.client.cartography.color.ColorManager;
import journeymap.client.cartography.color.ColoredSprite;
import journeymap.client.cartography.color.RGB;
import journeymap.client.mod.IBlockColorProxy;
import journeymap.client.mod.ModBlockDelegate;
import journeymap.client.model.BlockMD;
import journeymap.client.model.ChunkMD;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.state.BlockState;

public enum FlowerBlockProxy implements IBlockColorProxy
{
    INSTANCE;

    boolean enabled = true;

    @Override
    public int deriveBlockColor(BlockMD blockMD, @Nullable ChunkMD chunkMD, @Nullable BlockPos blockPos) {
        Integer color;
        if (blockMD.getBlock() instanceof FlowerBlock && (color = this.getFlowerColor(blockMD, blockPos)) != null) {
            return color;
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().deriveBlockColor(blockMD, chunkMD, blockPos);
    }

    @Override
    public int getBlockColor(ChunkMD chunkMD, BlockMD blockMD, BlockPos blockPos) {
        if (blockMD.getBlock() instanceof FlowerBlock) {
            return blockMD.getTextureColor();
        }
        if (blockMD.getBlock() instanceof FlowerPotBlock && JourneymapClient.getInstance().getCoreProperties().mapPlants.get().booleanValue()) {
            try {
                BlockState blockState = blockMD.getBlockState();
                ItemStack iStack = ((FlowerPotBlock)blockState.m_60734_()).m_7397_((BlockGetter)chunkMD.getWorld(), blockPos, blockState);
                if (iStack != null) {
                    BlockState contentBlockState = Block.m_49814_((Item)iStack.m_41720_()).m_49966_();
                    return BlockMD.get(contentBlockState).getTextureColor();
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().error("Error checking FlowerPot: " + e, (Object)LogFormatter.toPartialString(e));
                this.enabled = false;
            }
        }
        return ModBlockDelegate.INSTANCE.getDefaultBlockColorProxy().getBlockColor(chunkMD, blockMD, blockPos);
    }

    private Integer getFlowerColor(BlockMD blockMd, BlockPos blockPos) {
        BlockState blockState = blockMd.getBlockState();
        if (blockState.m_60734_() instanceof FlowerBlock) {
            Block block = blockState.m_60734_();
            return switch (Registry.f_122824_.m_7981_((Object)block).m_135815_()) {
                case "poppy", "red_tulip" -> 9962502;
                case "blue_orchid" -> 1998518;
                case "allium" -> 8735158;
                case "azure_bluet" -> 10330535;
                case "orange_tulip" -> 10704922;
                case "white_tulip" -> 0xB0B0B0;
                case "pink_tulip" -> 11573936;
                case "oxeye_daisy" -> 0xB3B3B3;
                case "dandelion" -> 11514881;
                case "cornflower" -> 3361970;
                case "lily_of_the_valley" -> 0xFFFFFF;
                case "wither_rose" -> 0x191919;
                default -> this.getUnknownFlowerColor(blockMd, blockPos);
            };
        }
        return null;
    }

    private int getUnknownFlowerColor(BlockMD blockMD, BlockPos blockPos) {
        try {
            Collection<ColoredSprite> sprites = blockMD.getBlockSpritesProxy().getSprites(blockMD, null, null);
            float[] rgba = ColorManager.INSTANCE.getAverageColor(sprites);
            if (rgba != null) {
                return RGB.toInteger(rgba);
            }
            BlockState blockState = blockMD.getBlockState();
            ClientLevel level = Minecraft.m_91087_().f_91073_;
            return blockState.m_60780_((BlockGetter)level, (BlockPos)blockPos).f_76396_;
        }
        catch (Exception e) {
            return 0;
        }
    }
}

