/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.world.capability;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.AnimationEvent;
import com.nameless.indestructible.api.animation.types.CustomGuardAnimation;
import com.nameless.indestructible.data.AdvancedMobpatchReloader;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.world.ai.goal.AdvancedChasingGoal;
import com.nameless.indestructible.world.ai.goal.AdvancedCombatGoal;
import com.nameless.indestructible.world.ai.goal.GuardGoal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.RunIf;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.LivingMotions;
import yesman.epicfight.api.animation.types.DynamicAnimation;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.animation.ClientAnimator;
import yesman.epicfight.api.client.animation.Layer;
import yesman.epicfight.api.utils.AttackResult;
import yesman.epicfight.api.utils.math.OpenMatrix4f;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.gameasset.EpicFightSounds;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.network.EpicFightNetworkManager;
import yesman.epicfight.network.server.SPChangeLivingMotion;
import yesman.epicfight.particle.EpicFightParticles;
import yesman.epicfight.particle.HitParticleType;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.CapabilityItem;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.damagesource.EpicFightDamageSource;
import yesman.epicfight.world.damagesource.SourceTag;
import yesman.epicfight.world.damagesource.SourceTags;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.effect.EpicFightMobEffects;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.brain.BrainRecomposer;
import yesman.epicfight.world.entity.ai.brain.task.AnimatedCombatBehavior;
import yesman.epicfight.world.entity.ai.brain.task.BackUpIfTooCloseStopInaction;
import yesman.epicfight.world.entity.ai.brain.task.MoveToTargetSinkStopInaction;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedCustomHumanoidMobPatch<T extends PathfinderMob>
extends HumanoidMobPatch<T> {
    private final AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider;
    private final Map<WeaponCategory, Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>>> guardMotions;
    private static final EntityDataAccessor<Float> STAMINA = new EntityDataAccessor(253, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Float> ATTACK_SPEED = new EntityDataAccessor(177, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Boolean> IS_BLOCKING = new EntityDataAccessor(178, EntityDataSerializers.f_135035_);
    private final int regenStaminaStandbyTime;
    private final float regenStaminaMultiply;
    private final float maxStamina;
    private final boolean hasStunReduction;
    private final float maxStunShield;
    private final int reganShieldStandbyTime;
    private final float reganShieldMultiply;
    private final float staminaLoseMultiply;
    private int block_tick;
    private boolean cancel_block;
    private int tickSinceLastAction;
    private int tickSinceBreakShield;
    private CounterMotion counterMotion;
    private final float guardRadius;
    private DamageSourceModifier damageSourceModifier = null;
    private final List<AnimationEvent.TimeStampedEvent> timeEvents = Lists.newArrayList();
    private final List<AnimationEvent.HitEvent> hitEvents = Lists.newArrayList();
    private final List<AnimationEvent.ConditionalEvent> stunEvents = Lists.newArrayList();
    private int phase;
    private float strafingForward;
    private float strafingClockwise;
    private int strafingTime;
    private int inactionTime;
    private int convertTick = 0;
    private boolean isRunning = false;

    public AdvancedCustomHumanoidMobPatch(Faction faction, AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider) {
        super(faction);
        this.provider = provider;
        this.regenStaminaStandbyTime = this.provider.getRegenStaminaStandbyTime();
        this.regenStaminaMultiply = this.provider.getRegenStaminaMultiply();
        this.maxStamina = this.provider.getMaxStamina();
        this.hasStunReduction = this.provider.hasStunReduction();
        this.maxStunShield = this.provider.getMaxStunShield();
        this.reganShieldStandbyTime = this.provider.getReganShieldStandbyTime();
        this.reganShieldMultiply = this.provider.getReganShieldMultiply();
        this.staminaLoseMultiply = this.provider.getStaminaLoseMultiply();
        this.weaponLivingMotions = this.provider.getHumanoidWeaponMotions();
        this.weaponAttackMotions = this.provider.getHumanoidCombatBehaviors();
        this.guardMotions = this.provider.getGuardMotions();
        this.guardRadius = this.provider.getGuardRadius();
    }

    public void onConstructed(T entityIn) {
        super.onConstructed(entityIn);
        entityIn.m_20088_().m_135372_(STAMINA, (Object)Float.valueOf(0.0f));
        entityIn.m_20088_().m_135372_(ATTACK_SPEED, (Object)Float.valueOf(1.0f));
        entityIn.m_20088_().m_135372_(IS_BLOCKING, (Object)false);
    }

    public void onJoinWorld(T entityIn, EntityJoinWorldEvent event) {
        super.onJoinWorld(entityIn, event);
        this.tickSinceLastAction = 0;
        this.tickSinceBreakShield = 0;
        this.block_tick = 30;
        this.setStamina(this.getMaxStamina());
        this.setAttackSpeed(1.0f);
        this.setPhase(0);
        if (this.maxStunShield > 0.0f) {
            this.setMaxStunShield(this.maxStunShield);
            this.setStunShield(this.maxStunShield);
        }
        if (!this.isLogicalClient()) {
            this.initStunEvent(this.provider);
            this.resetMotion();
        }
    }

    public void serverTick(LivingEvent.LivingUpdateEvent event) {
        float maxStamina;
        float stamina;
        if (this.hasStunReduction) {
            super.serverTick(event);
        }
        if (!this.state.inaction() && this.isBlocking()) {
            ++this.tickSinceLastAction;
        }
        if ((stamina = this.getStamina()) < (maxStamina = this.getMaxStamina())) {
            if (this.tickSinceLastAction > this.regenStaminaStandbyTime) {
                float staminaFactor = 1.0f + (float)Math.pow(stamina / (maxStamina - stamina * 0.5f), 2.0);
                this.setStamina(stamina + maxStamina * (0.01f * this.regenStaminaMultiply) * staminaFactor);
            } else {
                this.setStamina(stamina + 0.0015f * this.regenStaminaMultiply * maxStamina);
            }
        }
        if (maxStamina < stamina) {
            this.setStamina(maxStamina);
        }
        if (this.maxStunShield > 0.0f) {
            float stunShield = this.getStunShield();
            float maxStunShield = this.getMaxStunShield();
            if (stunShield > 0.0f) {
                if (stunShield < maxStunShield && !this.getEntityState().hurt() && !this.getEntityState().knockDown()) {
                    this.setStunShield(stunShield + 0.0015f * this.reganShieldMultiply * maxStunShield);
                }
                if (this.tickSinceBreakShield > 0) {
                    this.tickSinceBreakShield = 0;
                }
            }
            if (stunShield == 0.0f) {
                ++this.tickSinceBreakShield;
                if (this.tickSinceBreakShield > this.reganShieldStandbyTime) {
                    this.setStunShield(this.getMaxStunShield());
                }
            }
            if (stunShield > maxStunShield) {
                this.setStunShield(this.getMaxStunShield());
            }
        }
    }

    protected void clientTick(LivingEvent.LivingUpdateEvent event) {
        boolean shouldRunning;
        boolean bl = shouldRunning = ((PathfinderMob)this.original).f_20924_ >= 0.7f;
        if (shouldRunning != this.isRunning) {
            ++this.convertTick;
            if (this.convertTick > 4) {
                this.isRunning = shouldRunning;
            }
        } else {
            this.convertTick = 0;
        }
    }

    public boolean hasTimeEvent() {
        return !this.timeEvents.isEmpty();
    }

    public List<AnimationEvent.TimeStampedEvent> getTimeEventList() {
        return this.timeEvents;
    }

    public void addEvent(AnimationEvent.TimeStampedEvent event) {
        this.timeEvents.add(event);
    }

    public boolean hasHitEvent() {
        return !this.hitEvents.isEmpty();
    }

    public List<AnimationEvent.HitEvent> getHitEventList() {
        return this.hitEvents;
    }

    public void addEvent(AnimationEvent.HitEvent event) {
        this.hitEvents.add(event);
    }

    private void initStunEvent(AdvancedMobpatchReloader.AdvancedCustomHumanoidMobPatchProvider provider) {
        this.stunEvents.clear();
        if (provider.getStunEvent() != null && !provider.getStunEvent().isEmpty()) {
            this.stunEvents.addAll(this.provider.getStunEvent());
        }
    }

    public void resetMotion() {
        if (this.hasTimeEvent()) {
            this.timeEvents.clear();
        }
        if (this.hasHitEvent()) {
            this.hitEvents.clear();
        }
        if (this.damageSourceModifier != null) {
            this.damageSourceModifier = null;
        }
    }

    public void setBlockTick(int value) {
        this.block_tick = value;
    }

    public int getBlockTick() {
        return this.block_tick;
    }

    public void setBlocking(boolean blocking) {
        ((PathfinderMob)this.original).m_20088_().m_135381_(IS_BLOCKING, (Object)blocking);
    }

    public boolean isBlocking() {
        return (Boolean)((PathfinderMob)this.original).m_20088_().m_135370_(IS_BLOCKING);
    }

    public void cancelBlock(boolean setCancel) {
        this.cancel_block = setCancel;
    }

    public float getMaxStamina() {
        return this.maxStamina;
    }

    public float getStamina() {
        return this.getMaxStamina() == 0.0f ? 0.0f : Math.max(0.0f, ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(STAMINA)).floatValue());
    }

    public void setStamina(float value) {
        float f1 = Math.max(Math.min(value, this.getMaxStamina()), 0.0f);
        ((PathfinderMob)this.original).m_20088_().m_135381_(STAMINA, (Object)Float.valueOf(f1));
    }

    public float getAttackSpeed() {
        return ((Float)((PathfinderMob)this.original).m_20088_().m_135370_(ATTACK_SPEED)).floatValue();
    }

    public void setAttackSpeed(float value) {
        ((PathfinderMob)this.original).m_20088_().m_135381_(ATTACK_SPEED, (Object)Float.valueOf(Math.abs(value)));
    }

    public void setCounterMotion(StaticAnimation counter, float cost, float chance, float speed) {
        this.counterMotion = new CounterMotion(counter, cost, chance, speed);
    }

    public StaticAnimation getCounter() {
        return this.counterMotion.counter;
    }

    public float getCounterChance() {
        return this.counterMotion.chance;
    }

    public float getCounterStamina() {
        return this.counterMotion.cost;
    }

    public float getCounterSpeed() {
        return this.counterMotion.speed;
    }

    public void resetActionTick() {
        this.tickSinceLastAction = 0;
    }

    public int getTickSinceLastAction() {
        return this.tickSinceLastAction;
    }

    public void setDamageSourceModifier(DamageSourceModifier damageSourceModifier) {
        this.damageSourceModifier = damageSourceModifier;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = Math.min(Math.max(0, phase), 20);
    }

    public int getStrafingTime() {
        return this.strafingTime;
    }

    public void setStrafingTime(int time) {
        this.strafingTime = time;
    }

    public float getStrafingForward() {
        return this.strafingForward;
    }

    public float getStrafingClockwise() {
        return this.strafingClockwise;
    }

    public int getInactionTime() {
        return this.inactionTime;
    }

    public void setInactionTime(int time) {
        this.inactionTime = time;
    }

    public void setStrafingDirection(float forward, float clockwise) {
        this.strafingForward = forward;
        this.strafingClockwise = clockwise;
    }

    public void setAIAsInfantry(boolean holdingRanedWeapon) {
        CombatBehaviors.Builder builder;
        boolean isUsingBrain;
        boolean bl = isUsingBrain = !((PathfinderMob)this.getOriginal()).m_6274_().f_21845_.isEmpty();
        if (isUsingBrain) {
            if (!holdingRanedWeapon) {
                CombatBehaviors.Builder builder2 = this.getHoldingItemWeaponMotionBuilder();
                if (builder2 != null) {
                    BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37988_, MeleeAttack.class, (Behavior)new AnimatedCombatBehavior((MobPatch)this, builder2.build((MobPatch)this)));
                }
                BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37988_, RunIf.class, (Behavior)new RunIf(entity -> entity.m_21093_(is -> is.m_41720_() instanceof CrossbowItem), (Behavior)new BackUpIfTooCloseStopInaction(5, 0.75f)));
                BrainRecomposer.replaceBehaviors((Brain)((PathfinderMob)this.original).m_6274_(), (Activity)Activity.f_37978_, MoveToTargetSink.class, (Behavior)new MoveToTargetSinkStopInaction());
            }
        } else if (!holdingRanedWeapon && (builder = this.getHoldingItemWeaponMotionBuilder()) != null) {
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new AdvancedCombatGoal<AdvancedCustomHumanoidMobPatch>(this, builder.build((MobPatch)this)));
            ((PathfinderMob)this.original).f_21345_.m_25352_(0, new GuardGoal<AdvancedCustomHumanoidMobPatch>(this, this.guardRadius));
            ((PathfinderMob)this.original).f_21345_.m_25352_(1, new AdvancedChasingGoal<AdvancedCustomHumanoidMobPatch>(this, (PathfinderMob)this.getOriginal(), this.provider.getChasingSpeed(), true, 0.0));
        }
    }

    protected void setWeaponMotions() {
        if (this.weaponAttackMotions == null) {
            super.setWeaponMotions();
        }
    }

    protected void initAttributes() {
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.WEIGHT.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.WEIGHT.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.MAX_STRIKES.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.MAX_STRIKES.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.ARMOR_NEGATION.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.ARMOR_NEGATION.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.IMPACT.get()).m_22100_(this.provider.getAttributeValues().get(EpicFightAttributes.IMPACT.get()).doubleValue());
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_IMPACT.get()).m_22100_(0.5);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ARMOR_NEGATION.get()).m_22100_(0.0);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_ATTACK_SPEED.get()).m_22100_((double)1.2f);
        ((PathfinderMob)this.original).m_21051_((Attribute)EpicFightAttributes.OFFHAND_MAX_STRIKES.get()).m_22100_(1.0);
        if (this.provider.getAttributeValues().containsKey(Attributes.f_22281_)) {
            ((PathfinderMob)this.original).m_21051_(Attributes.f_22281_).m_22100_(this.provider.getAttributeValues().get(Attributes.f_22281_).doubleValue());
        }
    }

    public void initAnimator(ClientAnimator clientAnimator) {
        for (Pair<LivingMotion, StaticAnimation> pair : this.provider.getDefaultAnimations()) {
            clientAnimator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
        }
        clientAnimator.setCurrentMotionsAsDefault();
    }

    public void updateMotion(boolean considerInaction) {
        this.currentLivingMotion = ((PathfinderMob)this.original).m_21223_() <= 0.0f ? LivingMotions.DEATH : (this.state.inaction() && considerInaction ? LivingMotions.IDLE : (((PathfinderMob)this.original).m_20202_() != null ? LivingMotions.MOUNT : (((PathfinderMob)this.original).m_20184_().f_82480_ < (double)-0.55f ? LivingMotions.FALL : (((PathfinderMob)this.original).f_20924_ > 0.01f ? (this.isRunning ? LivingMotions.CHASE : LivingMotions.WALK) : LivingMotions.IDLE))));
        this.currentCompositeMotion = this.currentLivingMotion;
        if (((PathfinderMob)this.original).m_6117_()) {
            CapabilityItem activeItem = this.getHoldingItemCapability(((PathfinderMob)this.original).m_7655_());
            UseAnim useAnim = ((PathfinderMob)this.original).m_21120_(((PathfinderMob)this.original).m_7655_()).m_41780_();
            UseAnim secondUseAnim = activeItem.getUseAnimation((LivingEntityPatch)this);
            this.currentCompositeMotion = useAnim == UseAnim.BLOCK || secondUseAnim == UseAnim.BLOCK ? (activeItem.getWeaponCategory() == CapabilityItem.WeaponCategories.SHIELD ? LivingMotions.BLOCK_SHIELD : LivingMotions.BLOCK) : (useAnim == UseAnim.BOW || useAnim == UseAnim.SPEAR ? LivingMotions.AIM : (useAnim == UseAnim.CROSSBOW ? LivingMotions.RELOAD : this.currentLivingMotion));
        } else {
            this.currentCompositeMotion = this.isBlocking() ? LivingMotions.BLOCK : (CrossbowItem.m_40932_((ItemStack)((PathfinderMob)this.original).m_21205_()) ? LivingMotions.AIM : (this.getClientAnimator().getCompositeLayer((Layer.Priority)Layer.Priority.MIDDLE).animationPlayer.getAnimation().isReboundAnimation() ? LivingMotions.NONE : (((PathfinderMob)this.original).f_20911_ && ((PathfinderMob)this.original).m_21257_().isEmpty() ? LivingMotions.DIGGING : this.currentLivingMotion)));
            if (this.getClientAnimator().isAiming() && this.currentCompositeMotion != LivingMotions.AIM) {
                this.playReboundAnimation();
            }
        }
    }

    public AttackResult attack(EpicFightDamageSource damageSource, Entity target, InteractionHand hand) {
        AttackResult result = super.attack(damageSource, target, hand);
        if (result.resultType.dealtDamage() && this.hasHitEvent()) {
            for (AnimationEvent.HitEvent event : this.getHitEventList()) {
                event.testAndExecute((LivingEntityPatch<?>)this, target);
            }
        }
        return result;
    }

    public StaticAnimation getHitAnimation(StunType stunType) {
        this.setAttackSpeed(1.0f);
        this.resetActionTick();
        this.resetMotion();
        return this.provider.getStunAnimations().get(stunType);
    }

    public OpenMatrix4f getModelMatrix(float partialTicks) {
        float scale = this.provider.getScale();
        return super.getModelMatrix(partialTicks).scale(scale, scale, scale);
    }

    public void setStunReductionOnHit(StunType stunType) {
        if (this.hasStunReduction) {
            super.setStunReductionOnHit(stunType);
        }
    }

    public float getStunReduction() {
        if (this.hasStunReduction) {
            return super.getStunReduction();
        }
        return 0.0f;
    }

    public void modifyLivingMotionByCurrentItem() {
        Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>> motionByStyle;
        Style style;
        Map mapByStyle;
        this.getAnimator().resetLivingAnimations();
        CapabilityItem mainhandCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        CapabilityItem offhandCap = this.getAdvancedHoldingItemCapability(InteractionHand.OFF_HAND);
        HashMap motionModifier = Maps.newHashMap();
        motionModifier.putAll(offhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.OFF_HAND));
        motionModifier.putAll(mainhandCap.getLivingMotionModifier((LivingEntityPatch)this, InteractionHand.MAIN_HAND));
        for (Map.Entry entry : motionModifier.entrySet()) {
            this.getAnimator().addLivingAnimation((LivingMotion)entry.getKey(), (StaticAnimation)entry.getValue());
        }
        if (this.weaponLivingMotions != null && this.weaponLivingMotions.containsKey(mainhandCap.getWeaponCategory()) && ((mapByStyle = (Map)this.weaponLivingMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle((LivingEntityPatch)this)) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            Set animModifierSet = mapByStyle.getOrDefault(style, (Set)mapByStyle.get(CapabilityItem.Styles.COMMON));
            for (Pair pair : animModifierSet) {
                this.animator.addLivingAnimation((LivingMotion)pair.getFirst(), (StaticAnimation)pair.getSecond());
            }
        }
        if (this.guardMotions != null && this.guardMotions.containsKey(mainhandCap.getWeaponCategory()) && ((motionByStyle = this.guardMotions.get(mainhandCap.getWeaponCategory())).containsKey(style = mainhandCap.getStyle((LivingEntityPatch)this)) || motionByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
            StaticAnimation guard = (StaticAnimation)motionByStyle.getOrDefault(style, motionByStyle.get(CapabilityItem.Styles.COMMON)).getFirst();
            this.animator.addLivingAnimation((LivingMotion)LivingMotions.BLOCK, guard);
        }
        SPChangeLivingMotion msg = new SPChangeLivingMotion(((PathfinderMob)this.original).m_142049_());
        msg.putEntries(this.getAnimator().getLivingAnimationEntrySet());
        EpicFightNetworkManager.sendToAllPlayerTrackingThisEntity((Object)msg, (Entity)this.original);
    }

    private Pair<StaticAnimation, Pair<Float, Boolean>> getCurrentGuardMotion() {
        CapabilityItem itemCap = this.getHoldingItemCapability(InteractionHand.MAIN_HAND);
        if (this.guardMotions != null && itemCap != null) {
            Style style = itemCap.getStyle((LivingEntityPatch)this);
            Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>> mapByStyle = this.guardMotions.get(itemCap.getWeaponCategory());
            if (mapByStyle != null && (mapByStyle.containsKey(style) || mapByStyle.containsKey(CapabilityItem.Styles.COMMON))) {
                return mapByStyle.getOrDefault(style, mapByStyle.get(CapabilityItem.Styles.COMMON));
            }
        }
        return Pair.of((Object)GuardAnimations.MOB_LONGSWORD_GUARD, (Object)Pair.of((Object)Float.valueOf(1.0f), (Object)false));
    }

    public Float getStaminaCostMultiply() {
        return (Float)((Pair)this.getCurrentGuardMotion().getSecond()).getFirst();
    }

    public CustomGuardAnimation getGuardAnimation() {
        Object object = this.getCurrentGuardMotion().getFirst();
        if (object instanceof CustomGuardAnimation) {
            CustomGuardAnimation guardAnimation = (CustomGuardAnimation)((Object)object);
            return guardAnimation;
        }
        return (CustomGuardAnimation)GuardAnimations.MOB_LONGSWORD_GUARD;
    }

    public boolean canBlockProjectile() {
        return (Boolean)((Pair)this.getCurrentGuardMotion().getSecond()).getSecond();
    }

    public AttackResult tryHurt(DamageSource damageSource, float amount) {
        AttackResult result = AttackResult.of((AttackResult.ResultType)this.getEntityState().attackResult(damageSource), (float)amount);
        if (result.resultType.dealtDamage()) {
            result = this.tryProcess(damageSource, amount);
        }
        return result;
    }

    private AttackResult tryProcess(DamageSource damageSource, float amount) {
        if (this.isBlocking()) {
            CustomGuardAnimation animation = this.getGuardAnimation();
            StaticAnimation success = animation.successAnimation != null ? EpicFightMod.getInstance().animationManager.findAnimationByPath(animation.successAnimation) : Animations.SWORD_GUARD_HIT;
            boolean isFront = false;
            boolean canBlockSource = !damageSource.m_19372_() && !damageSource.m_19387_() && !damageSource.m_19378_() && (!damageSource.m_19360_() || this.canBlockProjectile());
            Vec3 sourceLocation = damageSource.m_7270_();
            if (sourceLocation != null) {
                Vec3 viewVector = ((PathfinderMob)this.getOriginal()).m_20252_(1.0f);
                Vec3 toSourceLocation = sourceLocation.m_82546_(((PathfinderMob)this.getOriginal()).m_20182_()).m_82541_();
                if (toSourceLocation.m_82526_(viewVector) > 0.0) {
                    isFront = true;
                }
            }
            if (canBlockSource && isFront) {
                float impact;
                if (damageSource instanceof EpicFightDamageSource) {
                    EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
                    impact = amount / 4.0f * (1.0f + efDamageSource.getImpact() / 2.0f);
                    if (efDamageSource.hasTag((SourceTag)SourceTags.GUARD_PUNCTURE)) {
                        impact = Float.MAX_VALUE;
                    }
                } else {
                    impact = amount / 3.0f;
                }
                float knockback = 0.25f + Math.min(impact * 0.1f, 1.0f);
                Entity entity = damageSource.m_7640_();
                if (entity instanceof LivingEntity) {
                    LivingEntity targetEntity = (LivingEntity)entity;
                    knockback += (float)EnchantmentHelper.m_44894_((LivingEntity)targetEntity) * 0.1f;
                }
                float stamina = this.getStamina() - impact * this.getStaminaCostMultiply().floatValue();
                this.setStamina(stamina);
                ((HitParticleType)EpicFightParticles.HIT_BLUNT.get()).spawnParticleWithArgument((ServerLevel)((PathfinderMob)this.getOriginal()).f_19853_, HitParticleType.FRONT_OF_EYES, HitParticleType.ZERO, this.getOriginal(), damageSource.m_7640_());
                if (stamina >= 0.0f) {
                    float counter_cost = this.getCounterStamina();
                    Random random = ((PathfinderMob)this.getOriginal()).m_21187_();
                    if (random.nextFloat() < this.getCounterChance() && stamina >= counter_cost) {
                        ((PathfinderMob)this.getOriginal()).m_7292_(new MobEffectInstance((MobEffect)EpicFightMobEffects.STUN_IMMUNITY.get(), 25));
                        this.setAttackSpeed(this.getCounterSpeed());
                        this.playAnimationSynchronized(this.getCounter(), 0.0f);
                        this.playSound(EpicFightSounds.CLASH, -0.05f, 0.1f);
                        this.knockBackEntity(damageSource.m_7640_().m_20182_(), 0.1f);
                        if (this.cancel_block) {
                            this.setBlocking(false);
                        }
                        this.setStamina(this.getStamina() - counter_cost);
                    } else {
                        this.playAnimationSynchronized(success, 0.1f);
                        this.playSound(animation.isShield != false ? SoundEvents.f_12346_ : EpicFightSounds.CLASH, -0.05f, 0.1f);
                        this.knockBackEntity(damageSource.m_7640_().m_20182_(), knockback);
                    }
                    return new AttackResult(AttackResult.ResultType.BLOCKED, amount);
                }
                this.setBlocking(false);
                this.applyStun(StunType.NEUTRALIZE, 2.0f);
                this.setStamina(this.getMaxStamina());
                return new AttackResult(AttackResult.ResultType.SUCCESS, amount / 2.0f);
            }
        }
        if (damageSource instanceof EpicFightDamageSource) {
            EpicFightDamageSource efDamageSource = (EpicFightDamageSource)damageSource;
            if (this.staminaLoseMultiply > 0.0f && this.getStunShield() <= 0.0f) {
                DynamicAnimation animation = this.getAnimator().getPlayerFor(null).getAnimation();
                if (animation != Animations.BIPED_COMMON_NEUTRALIZED && animation != Animations.GREATSWORD_GUARD_BREAK) {
                    this.setStamina(this.getStamina() - efDamageSource.getImpact() * this.staminaLoseMultiply);
                }
                if (this.getStamina() < efDamageSource.getImpact()) {
                    efDamageSource.setStunType(StunType.NEUTRALIZE);
                    this.setStamina(this.getMaxStamina());
                }
            }
        }
        return new AttackResult(AttackResult.ResultType.SUCCESS, amount);
    }

    public EpicFightDamageSource getDamageSource(StaticAnimation animation, InteractionHand hand) {
        EpicFightDamageSource damagesource = EpicFightDamageSource.commonEntityDamageSource((String)"mob", (LivingEntity)((LivingEntity)this.original), (StaticAnimation)animation);
        damagesource.setImpact(this.getImpact(hand));
        damagesource.setArmorNegation(this.getArmorNegation(hand));
        damagesource.setHurtItem(((PathfinderMob)this.original).m_21120_(hand));
        if (this.damageSourceModifier != null) {
            damagesource.setImpact(this.getImpact(hand) * this.damageSourceModifier.impact());
            damagesource.setArmorNegation(Math.min(100.0f, this.getArmorNegation(hand) * this.damageSourceModifier.armor_negation()));
        }
        return damagesource;
    }

    public void onDeath(LivingDeathEvent event) {
        this.resetMotion();
        this.setBlocking(false);
        this.getAnimator().playDeathAnimation();
        this.currentLivingMotion = LivingMotions.DEATH;
    }

    public float getModifiedBaseDamage(float baseDamage) {
        if (this.damageSourceModifier != null) {
            baseDamage *= this.damageSourceModifier.damage();
        }
        return baseDamage;
    }

    public boolean applyStun(StunType stunType, float time) {
        DynamicAnimation animation = this.getAnimator().getPlayerFor(null).getAnimation();
        if (animation == Animations.BIPED_COMMON_NEUTRALIZED || animation == Animations.GREATSWORD_GUARD_BREAK) {
            StunType stunType2 = stunType = stunType == StunType.KNOCKDOWN ? stunType : StunType.NONE;
        }
        if (!this.stunEvents.isEmpty() && this.getHitAnimation(stunType) != null) {
            for (AnimationEvent.ConditionalEvent event : this.stunEvents) {
                event.testAndExecute((LivingEntityPatch<?>)this, stunType.ordinal());
            }
        }
        return super.applyStun(stunType, time);
    }

    public void knockBackEntity(Vec3 sourceLocation, float power) {
        DynamicAnimation animation = this.getAnimator().getPlayerFor(null).getAnimation();
        if (animation == Animations.BIPED_COMMON_NEUTRALIZED || animation == Animations.GREATSWORD_GUARD_BREAK) {
            return;
        }
        super.knockBackEntity(sourceLocation, power);
    }

    public record DamageSourceModifier(float damage, float impact, float armor_negation) {
    }

    public record CounterMotion(StaticAnimation counter, float cost, float chance, float speed) {
    }

    public record CustomAnimationMotion(StaticAnimation animation, float convertTime, float speed, float stamina) {
    }
}

