/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.utils;

import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.PotionItem;
import yesman.epicfight.gameasset.Animations;
import yesman.epicfight.world.capabilities.EpicFightCapabilities;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class ExtraPredicate {

    public static class Phase<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final int minLevel;
        private final int maxLevel;

        public Phase(int minLevel, int maxLevel) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public boolean test(T mobpatch) {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                int phase = advancedCustomHumanoidMobPatch.getPhase();
                return this.minLevel <= phase && phase <= this.maxLevel;
            }
            return false;
        }
    }

    public static class TargetIsUsingItem<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final boolean isEdible;

        public TargetIsUsingItem(boolean isEdible) {
            this.isEdible = isEdible;
        }

        public boolean test(T mobpatch) {
            LivingEntity target = mobpatch.getTarget();
            if (target.m_6117_()) {
                ItemStack item = target.m_21211_();
                if (this.isEdible) {
                    return item.m_41720_() instanceof PotionItem || item.m_41720_().m_41472_();
                }
                return !(item.m_41720_() instanceof PotionItem) && !item.m_41720_().m_41472_();
            }
            return false;
        }
    }

    public static class SelfStamina<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final float value;
        private final CombatBehaviors.Health.Comparator comparator;

        public SelfStamina(float value, CombatBehaviors.Health.Comparator comparator) {
            this.value = value;
            this.comparator = comparator;
        }

        public boolean test(T mobpatch) {
            if (!(mobpatch instanceof AdvancedCustomHumanoidMobPatch)) {
                return false;
            }
            float stamina = ((AdvancedCustomHumanoidMobPatch)((Object)mobpatch)).getStamina();
            float maxstamina = ((AdvancedCustomHumanoidMobPatch)((Object)mobpatch)).getMaxStamina();
            switch (this.comparator) {
                case LESS_ABSOLUTE: {
                    return this.value > stamina;
                }
                case GREATER_ABSOLUTE: {
                    return this.value < stamina;
                }
                case LESS_RATIO: {
                    return this.value > stamina / maxstamina;
                }
                case GREATER_RATIO: {
                    return this.value < stamina / maxstamina;
                }
            }
            return true;
        }
    }

    public static class TargetWithinState<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final int minLevel;
        private final int maxLevel;

        public TargetWithinState(int minLevel, int maxLevel) {
            this.minLevel = minLevel;
            this.maxLevel = maxLevel;
        }

        public boolean test(T mobpatch) {
            LivingEntityPatch tartgetpatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)mobpatch.getTarget(), LivingEntityPatch.class);
            if (tartgetpatch == null) {
                return false;
            }
            int level = tartgetpatch.getEntityState().getLevel();
            return this.minLevel <= level && level <= this.maxLevel;
        }
    }

    public static class TargetIsKnockDown<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final boolean invert;

        public TargetIsKnockDown(boolean invert) {
            this.invert = invert;
        }

        public boolean test(T mobpatch) {
            LivingEntityPatch tartgetpatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)mobpatch.getTarget(), LivingEntityPatch.class);
            if (tartgetpatch == null) {
                return false;
            }
            boolean targetisknockdown = tartgetpatch.getEntityState().knockDown();
            if (!this.invert) {
                return targetisknockdown;
            }
            return !targetisknockdown;
        }
    }

    public static class TargetIsGuardBreak<T extends MobPatch<?>>
    extends CombatBehaviors.BehaviorPredicate<T> {
        private final boolean invert;

        public TargetIsGuardBreak(boolean invert) {
            this.invert = invert;
        }

        public boolean test(T mobpatch) {
            boolean targetisguardbreak;
            LivingEntityPatch tartgetpatch = (LivingEntityPatch)EpicFightCapabilities.getEntityPatch((Entity)mobpatch.getTarget(), LivingEntityPatch.class);
            if (tartgetpatch == null) {
                return false;
            }
            boolean bl = targetisguardbreak = tartgetpatch.getAnimator().getPlayerFor(null).getAnimation() == Animations.BIPED_COMMON_NEUTRALIZED || tartgetpatch.getAnimator().getPlayerFor(null).getAnimation() == Animations.GREATSWORD_GUARD_BREAK;
            if (!this.invert) {
                return targetisguardbreak;
            }
            return !targetisguardbreak;
        }
    }
}

