/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.data;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.util.Pair;
import com.nameless.indestructible.api.animation.types.AnimationEvent;
import com.nameless.indestructible.gameasset.GuardAnimations;
import com.nameless.indestructible.main.Indestructible;
import com.nameless.indestructible.network.SPDatapackSync;
import com.nameless.indestructible.utils.ExtraPredicate;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;
import yesman.epicfight.api.animation.LivingMotion;
import yesman.epicfight.api.animation.types.StaticAnimation;
import yesman.epicfight.api.client.model.Meshes;
import yesman.epicfight.api.data.reloader.MobPatchReloadListener;
import yesman.epicfight.api.model.Armature;
import yesman.epicfight.client.ClientEngine;
import yesman.epicfight.client.mesh.HumanoidMesh;
import yesman.epicfight.gameasset.Armatures;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.model.armature.HumanoidArmature;
import yesman.epicfight.network.server.SPPlayAnimation;
import yesman.epicfight.world.capabilities.entitypatch.EntityPatch;
import yesman.epicfight.world.capabilities.entitypatch.Faction;
import yesman.epicfight.world.capabilities.entitypatch.HumanoidMobPatch;
import yesman.epicfight.world.capabilities.entitypatch.MobPatch;
import yesman.epicfight.world.capabilities.item.Style;
import yesman.epicfight.world.capabilities.item.WeaponCategory;
import yesman.epicfight.world.capabilities.provider.EntityPatchProvider;
import yesman.epicfight.world.damagesource.StunType;
import yesman.epicfight.world.entity.ai.attribute.EpicFightAttributes;
import yesman.epicfight.world.entity.ai.goal.CombatBehaviors;

public class AdvancedMobpatchReloader
extends SimpleJsonResourceReloadListener {
    private static final Gson GSON = new GsonBuilder().create();
    private static final Map<EntityType<?>, CompoundTag> TAGMAP = Maps.newHashMap();
    private static final Map<EntityType<?>, MobPatchReloadListener.AbstractMobPatchProvider> ADVANCED_MOB_PATCH_PROVIDERS = Maps.newHashMap();

    public AdvancedMobpatchReloader() {
        super(GSON, "advanced_mobpatch");
    }

    protected void apply(Map<ResourceLocation, JsonElement> objectIn, ResourceManager resourceManagerIn, ProfilerFiller profilerIn) {
        for (Map.Entry<ResourceLocation, JsonElement> entry : objectIn.entrySet()) {
            ResourceLocation rl = entry.getKey();
            String pathString = rl.m_135815_();
            ResourceLocation registryName = new ResourceLocation(rl.m_135827_(), pathString);
            if (!ForgeRegistries.ENTITIES.containsKey(registryName)) {
                Indestructible.LOGGER.warn("[Custom Entity] Entity named " + registryName + " does not exist");
                continue;
            }
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(registryName);
            CompoundTag tag = null;
            try {
                tag = TagParser.m_129359_((String)entry.getValue().toString());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
            ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, AdvancedMobpatchReloader.deserializeMobPatchProvider(entityType, tag, false));
            EntityPatchProvider.putCustomEntityPatch((EntityType)entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
            TAGMAP.put(entityType, AdvancedMobpatchReloader.filterClientData(tag));
            if (!EpicFightMod.isPhysicalClient()) continue;
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static AdvancedCustomHumanoidMobPatchProvider deserializeMobPatchProvider(EntityType<?> entityType, CompoundTag tag, boolean clientSide) {
        AdvancedCustomHumanoidMobPatchProvider provider = new AdvancedCustomHumanoidMobPatchProvider();
        provider.attributeValues = AdvancedMobpatchReloader.deserializeAdvancedAttributes(tag.m_128469_("attributes"));
        ResourceLocation modelLocation = new ResourceLocation(tag.m_128461_("model"));
        ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
        modelLocation = new ResourceLocation(modelLocation.m_135827_(), "animmodels/" + modelLocation.m_135815_() + ".json");
        armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
        if (EpicFightMod.isPhysicalClient()) {
            Minecraft mc = Minecraft.m_91087_();
            Meshes.getOrCreateAnimatedMesh((ResourceManager)mc.m_91098_(), (ResourceLocation)modelLocation, HumanoidMesh::new);
            Armature armature = Armatures.getOrCreateArmature((ResourceManager)mc.m_91098_(), (ResourceLocation)armatureLocation, HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, (Armature)armature);
        } else {
            Armature armature = Armatures.getOrCreateArmature(null, (ResourceLocation)armatureLocation, HumanoidArmature::new);
            Armatures.registerEntityTypeArmature(entityType, (Armature)armature);
        }
        provider.defaultAnimations = MobPatchReloadListener.deserializeDefaultAnimations((CompoundTag)tag.m_128469_("default_livingmotions"));
        provider.faction = Faction.valueOf((String)tag.m_128461_("faction").toUpperCase(Locale.ROOT));
        provider.scale = tag.m_128469_("attributes").m_128441_("scale") ? (float)tag.m_128469_("attributes").m_128459_("scale") : 1.0f;
        provider.maxStamina = tag.m_128469_("attributes").m_128441_("max_stamina") ? (float)tag.m_128469_("attributes").m_128459_("max_stamina") : 15.0f;
        float f = provider.maxStunShield = tag.m_128469_("attributes").m_128441_("max_stun_shield") ? (float)tag.m_128469_("attributes").m_128459_("max_stun_shield") : 0.0f;
        if (!clientSide) {
            provider.stunAnimations = MobPatchReloadListener.deserializeStunAnimations((CompoundTag)tag.m_128469_("stun_animations"));
            provider.chasingSpeed = tag.m_128469_("attributes").m_128459_("chasing_speed");
            provider.AHCombatBehaviors = AdvancedMobpatchReloader.deserializeAdvancedCombatBehaviors(tag.m_128437_("combat_behavior", 10));
            provider.AHWeaponMotions = MobPatchReloadListener.deserializeHumanoidWeaponMotions((ListTag)tag.m_128437_("humanoid_weapon_motions", 10));
            provider.guardMotions = AdvancedMobpatchReloader.deserializeGuardMotions(tag.m_128437_("custom_guard_motion", 10));
            provider.regenStaminaStandbyTime = tag.m_128469_("attributes").m_128441_("stamina_regan_delay") ? tag.m_128469_("attributes").m_128451_("stamina_regan_delay") : 30;
            provider.regenStaminaMultiply = tag.m_128469_("attributes").m_128441_("stamina_regan_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stamina_regan_multiply") : 1.0f;
            provider.hasStunReduction = !tag.m_128469_("attributes").m_128441_("has_stun_reduction") || tag.m_128469_("attributes").m_128471_("has_stun_reduction");
            provider.reganShieldStandbyTime = tag.m_128469_("attributes").m_128441_("stun_shield_regan_delay") ? tag.m_128469_("attributes").m_128451_("stun_shield_regan_delay") : 30;
            provider.reganShieldMultiply = tag.m_128469_("attributes").m_128441_("stun_shield_regan_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stun_shield_multiply") : 1.0f;
            provider.staminaLoseMultiply = tag.m_128469_("attributes").m_128441_("stamina_lose_multiply") ? (float)tag.m_128469_("attributes").m_128459_("stamina_lose_multiply") : 0.0f;
            provider.guardRadius = tag.m_128469_("attributes").m_128441_("guard_radius") ? (float)tag.m_128469_("attributes").m_128459_("guard_radius") : 3.0f;
            provider.stunEvent = AdvancedMobpatchReloader.deserializeStunCommandList(tag.m_128437_("stun_command_list", 10));
        }
        return provider;
    }

    public static CompoundTag filterClientData(CompoundTag tag) {
        CompoundTag clientTag = new CompoundTag();
        AdvancedMobpatchReloader.extractBranch(clientTag, tag);
        return clientTag;
    }

    public static CompoundTag extractBranch(CompoundTag extract, CompoundTag original) {
        extract.m_128365_("model", original.m_128423_("model"));
        extract.m_128365_("armature", original.m_128423_("armature"));
        extract.m_128379_("isHumanoid", original.m_128441_("isHumanoid") ? original.m_128471_("isHumanoid") : false);
        extract.m_128365_("renderer", original.m_128423_("renderer"));
        extract.m_128365_("faction", original.m_128423_("faction"));
        extract.m_128365_("default_livingmotions", original.m_128423_("default_livingmotions"));
        extract.m_128365_("attributes", original.m_128423_("attributes"));
        return extract;
    }

    public static Stream<CompoundTag> getDataStream() {
        Stream<CompoundTag> tagStream = TAGMAP.entrySet().stream().map(entry -> {
            ((CompoundTag)entry.getValue()).m_128359_("id", ((EntityType)entry.getKey()).getRegistryName().toString());
            return (CompoundTag)entry.getValue();
        });
        return tagStream;
    }

    public static int getTagCount() {
        return TAGMAP.size();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void processServerPacket(SPDatapackSync packet) {
        for (CompoundTag tag : packet.getTags()) {
            EntityType entityType = (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(tag.m_128461_("id")));
            ADVANCED_MOB_PATCH_PROVIDERS.put(entityType, AdvancedMobpatchReloader.deserializeMobPatchProvider(entityType, tag, true));
            EntityPatchProvider.putCustomEntityPatch((EntityType)entityType, entity -> () -> ADVANCED_MOB_PATCH_PROVIDERS.get(entity.m_6095_()).get(entity));
            Minecraft mc = Minecraft.m_91087_();
            ResourceLocation armatureLocation = new ResourceLocation(tag.m_128461_("armature"));
            armatureLocation = new ResourceLocation(armatureLocation.m_135827_(), "animmodels/" + armatureLocation.m_135815_() + ".json");
            boolean humanoid = tag.m_128471_("isHumanoid");
            Armature armature = Armatures.getOrCreateArmature((ResourceManager)mc.m_91098_(), (ResourceLocation)armatureLocation, (Armatures.ArmatureContructor)(humanoid ? Armature::new : HumanoidArmature::new));
            Armatures.registerEntityTypeArmature((EntityType)entityType, (Armature)armature);
            ClientEngine.getInstance().renderEngine.registerCustomEntityRenderer(entityType, tag.m_128441_("preset") ? tag.m_128461_("preset") : tag.m_128461_("renderer"));
        }
    }

    public static Map<Attribute, Double> deserializeAdvancedAttributes(CompoundTag tag) {
        HashMap attributes = Maps.newHashMap();
        attributes.put((Attribute)EpicFightAttributes.WEIGHT.get(), tag.m_128425_("weight", 6) ? tag.m_128459_("weight") : 40.0);
        attributes.put((Attribute)EpicFightAttributes.IMPACT.get(), tag.m_128425_("impact", 6) ? tag.m_128459_("impact") : 0.5);
        attributes.put((Attribute)EpicFightAttributes.ARMOR_NEGATION.get(), tag.m_128425_("armor_negation", 6) ? tag.m_128459_("armor_negation") : 0.0);
        attributes.put((Attribute)EpicFightAttributes.MAX_STRIKES.get(), Double.valueOf(tag.m_128425_("max_strikes", 3) ? tag.m_128451_("max_strikes") : 1));
        if (tag.m_128425_("attack_damage", 6)) {
            attributes.put(Attributes.f_22281_, tag.m_128459_("attack_damage"));
        }
        return attributes;
    }

    public static Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> deserializeAdvancedCombatBehaviors(ListTag tag) {
        HashMap combatBehaviorsMapBuilder = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag combatBehavior = tag.m_128728_(i);
            ListTag categories = combatBehavior.m_128437_("weapon_categories", 8);
            Style style = (Style)Style.ENUM_MANAGER.get(combatBehavior.m_128461_("style"));
            CombatBehaviors.Builder builder = AdvancedMobpatchReloader.deserializeAdvancedBehaviorsBuilder(combatBehavior.m_128437_("behavior_series", 10));
            for (int j = 0; j < categories.size(); ++j) {
                WeaponCategory category = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(categories.m_128778_(j));
                combatBehaviorsMapBuilder.computeIfAbsent(category, key -> Maps.newHashMap());
                ((Map)combatBehaviorsMapBuilder.get(category)).put(style, builder);
            }
        }
        return combatBehaviorsMapBuilder;
    }

    public static Map<WeaponCategory, Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>>> deserializeGuardMotions(ListTag tag) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag list = tag.m_128728_(i);
            Style style = (Style)Style.ENUM_MANAGER.get(list.m_128461_("style"));
            StaticAnimation guard = list.m_128441_("guard") ? EpicFightMod.getInstance().animationManager.findAnimationByPath(list.m_128461_("guard")) : GuardAnimations.MOB_LONGSWORD_GUARD;
            float stamina_cost_multiply = list.m_128441_("stamina_cost_multiply") ? (float)list.m_128459_("stamina_cost_multiply") : 1.0f;
            boolean canBlockProjectile = list.m_128441_("can_block_projectile") && list.m_128471_("can_block_projectile");
            Tag weponTypeTag = list.m_128423_("weapon_categories");
            if (weponTypeTag instanceof StringTag) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypeTag.m_7916_());
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, Pair.of((Object)guard, (Object)Pair.of((Object)Float.valueOf(stamina_cost_multiply), (Object)canBlockProjectile)));
                continue;
            }
            if (!(weponTypeTag instanceof ListTag)) continue;
            ListTag weponTypesTag = (ListTag)weponTypeTag;
            for (int j = 0; j < weponTypesTag.size(); ++j) {
                WeaponCategory weaponCategory = (WeaponCategory)WeaponCategory.ENUM_MANAGER.get(weponTypesTag.m_128778_(j));
                if (!map.containsKey(weaponCategory)) {
                    map.put(weaponCategory, Maps.newHashMap());
                }
                ((Map)map.get(weaponCategory)).put(style, Pair.of((Object)guard, (Object)Pair.of((Object)Float.valueOf(stamina_cost_multiply), (Object)canBlockProjectile)));
            }
        }
        return map;
    }

    private static <T extends MobPatch<?>> CombatBehaviors.Builder<T> deserializeAdvancedBehaviorsBuilder(ListTag tag) {
        CombatBehaviors.Builder builder = CombatBehaviors.builder();
        for (int i = 0; i < tag.size(); ++i) {
            CompoundTag behaviorSeries = tag.m_128728_(i);
            float weight = (float)behaviorSeries.m_128459_("weight");
            int cooldown = behaviorSeries.m_128441_("cooldown") ? behaviorSeries.m_128451_("cooldown") : 0;
            boolean canBeInterrupted = behaviorSeries.m_128441_("canBeInterrupted") && behaviorSeries.m_128471_("canBeInterrupted");
            boolean looping = behaviorSeries.m_128441_("looping") && behaviorSeries.m_128471_("looping");
            ListTag behaviorList = behaviorSeries.m_128437_("behaviors", 10);
            CombatBehaviors.BehaviorSeries.Builder behaviorSeriesBuilder = CombatBehaviors.BehaviorSeries.builder();
            behaviorSeriesBuilder.weight(weight).cooldown(cooldown).canBeInterrupted(canBeInterrupted).looping(looping);
            for (int j = 0; j < behaviorList.size(); ++j) {
                CombatBehaviors.Behavior.Builder behaviorBuilder = CombatBehaviors.Behavior.builder();
                CompoundTag behavior = behaviorList.m_128728_(j);
                ListTag conditionList = behavior.m_128437_("conditions", 10);
                if (behavior.m_128441_("animation")) {
                    StaticAnimation animation = EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.m_128461_("animation"));
                    float speed = behavior.m_128441_("play_speed") ? (float)behavior.m_128459_("play_speed") : 1.0f;
                    float stamina = behavior.m_128441_("stamina") ? (float)behavior.m_128459_("stamina") : 0.0f;
                    float convertTime = behavior.m_128441_("convert_time") ? (float)behavior.m_128459_("convert_time") : 0.0f;
                    AdvancedCustomHumanoidMobPatch.CustomAnimationMotion motion = new AdvancedCustomHumanoidMobPatch.CustomAnimationMotion(animation, convertTime, speed, stamina);
                    List<AnimationEvent.TimeStampedEvent> timeCommandList = behavior.m_128441_("command_list") ? AdvancedMobpatchReloader.deserializeTimeCommandList(behavior.m_128437_("command_list", 10)) : null;
                    List<AnimationEvent.HitEvent> hitCommandList = behavior.m_128441_("hit_command_list") ? AdvancedMobpatchReloader.deserializeHitCommandList(behavior.m_128437_("hit_command_list", 10)) : null;
                    int phase = behavior.m_128441_("set_phase") ? behavior.m_128451_("set_phase") : -1;
                    AdvancedCustomHumanoidMobPatch.DamageSourceModifier modifier = behavior.m_128441_("damage_modifier") ? AdvancedMobpatchReloader.deserializeDamageModifier(behavior.m_128469_("damage_modifier")) : null;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.customAttackAnimation(motion, modifier, timeCommandList, hitCommandList, phase));
                } else if (behavior.m_128441_("guard")) {
                    int guardTime = behavior.m_128451_("guard");
                    StaticAnimation counter = behavior.m_128441_("counter") ? EpicFightMod.getInstance().animationManager.findAnimationByPath(behavior.m_128461_("counter")) : GuardAnimations.MOB_COUNTER_ATTACK;
                    float cost = behavior.m_128441_("counter_cost") ? (float)behavior.m_128459_("counter_cost") : 3.0f;
                    float chance = behavior.m_128441_("counter_chance") ? (float)behavior.m_128459_("counter_chance") : 0.3f;
                    float speed = behavior.m_128441_("counter_speed") ? (float)behavior.m_128459_("counter_speed") : 1.0f;
                    boolean cancel = !behavior.m_128441_("cancel_after_counter") || behavior.m_128471_("cancel_after_counter");
                    int phase = behavior.m_128441_("set_phase") ? behavior.m_128451_("set_phase") : -1;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.setGuardMotion(guardTime, counter, cost, chance, speed, cancel, phase));
                } else if (behavior.m_128441_("wander")) {
                    int strafingTime = behavior.m_128451_("wander");
                    int inactionTime = behavior.m_128441_("inaction_time") ? behavior.m_128451_("inaction_time") : behavior.m_128451_("wander");
                    float forward = behavior.m_128441_("z_axis") ? (float)behavior.m_128459_("z_axis") : 0.0f;
                    float clockwise = behavior.m_128441_("x_axis") ? (float)behavior.m_128459_("x_axis") : 0.0f;
                    int phase = behavior.m_128441_("set_phase") ? behavior.m_128451_("set_phase") : -1;
                    behaviorBuilder.behavior(AdvancedMobpatchReloader.setStrafing(strafingTime, inactionTime, forward, clockwise, phase));
                }
                for (int k = 0; k < conditionList.size(); ++k) {
                    CompoundTag condition = conditionList.m_128728_(k);
                    CombatBehaviors.BehaviorPredicate<T> predicate = AdvancedMobpatchReloader.deserializeAdvancedBehaviorPredicate(condition.m_128461_("predicate"), condition);
                    behaviorBuilder.predicate(predicate);
                }
                behaviorSeriesBuilder.nextBehavior(behaviorBuilder);
            }
            builder.newBehaviorSeries(behaviorSeriesBuilder);
        }
        return builder;
    }

    private static <T extends MobPatch<?>> Consumer<T> customAttackAnimation(AdvancedCustomHumanoidMobPatch.CustomAnimationMotion motion, @Nullable AdvancedCustomHumanoidMobPatch.DamageSourceModifier damageSourceModifier, @Nullable List<AnimationEvent.TimeStampedEvent> timeEvents, @Nullable List<AnimationEvent.HitEvent> hitEvents, int phase) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setAttackSpeed(motion.speed());
                advancedCustomHumanoidMobPatch.setStrafingTime(0);
                if (motion.stamina() != 0.0f) {
                    advancedCustomHumanoidMobPatch.setStamina(advancedCustomHumanoidMobPatch.getStamina() - motion.stamina());
                }
                if (timeEvents != null) {
                    for (Object event : timeEvents) {
                        advancedCustomHumanoidMobPatch.addEvent((AnimationEvent.TimeStampedEvent)event);
                    }
                }
                if (hitEvents != null) {
                    for (Object event : hitEvents) {
                        advancedCustomHumanoidMobPatch.addEvent((AnimationEvent.HitEvent)event);
                    }
                }
                advancedCustomHumanoidMobPatch.setDamageSourceModifier(damageSourceModifier);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
            mobpatch.playAnimationSynchronized(motion.animation(), motion.convertTime(), SPPlayAnimation::new);
        };
    }

    public static <T extends MobPatch<?>> Consumer<T> setGuardMotion(int guardTime, StaticAnimation counter, float cost, float chance, float speed, boolean cancel, int phase) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setBlocking(true);
                advancedCustomHumanoidMobPatch.setBlockTick(guardTime);
                advancedCustomHumanoidMobPatch.setCounterMotion(counter, cost, chance, speed);
                advancedCustomHumanoidMobPatch.cancelBlock(cancel);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
        };
    }

    public static <T extends MobPatch<?>> Consumer<T> setStrafing(int strafingTime, int inactionTime, float forward, float clockwise, int phase) {
        return mobpatch -> {
            if (mobpatch instanceof AdvancedCustomHumanoidMobPatch) {
                AdvancedCustomHumanoidMobPatch advancedCustomHumanoidMobPatch = (AdvancedCustomHumanoidMobPatch)((Object)mobpatch);
                advancedCustomHumanoidMobPatch.setStrafingTime(strafingTime);
                advancedCustomHumanoidMobPatch.setInactionTime(inactionTime);
                advancedCustomHumanoidMobPatch.setStrafingDirection(forward, clockwise);
                if (phase >= 0) {
                    advancedCustomHumanoidMobPatch.setPhase(phase);
                }
            }
        };
    }

    private static List<AnimationEvent.TimeStampedEvent> deserializeTimeCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            AnimationEvent.TimeStampedEvent event = AnimationEvent.TimeStampedEvent.CreateTimeCommandEvent(command.m_128457_("time"), command.m_128461_("command"), command.m_128471_("execute_at_target"));
            list.add(event);
        }
        return list;
    }

    private static List<AnimationEvent.HitEvent> deserializeHitCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            AnimationEvent.HitEvent event = AnimationEvent.HitEvent.CreateHitCommandEvent(command.m_128461_("command"), command.m_128471_("execute_at_target"));
            list.add(event);
        }
        return list;
    }

    private static List<AnimationEvent.ConditionalEvent> deserializeStunCommandList(ListTag args) {
        ArrayList list = Lists.newArrayList();
        for (int k = 0; k < args.size(); ++k) {
            CompoundTag command = args.m_128728_(k);
            AnimationEvent.ConditionalEvent event = AnimationEvent.ConditionalEvent.CreateStunCommandEvent(command.m_128461_("command"), StunType.valueOf((String)command.m_128461_("stun_type").toUpperCase(Locale.ROOT)));
            list.add(event);
        }
        return list;
    }

    private static AdvancedCustomHumanoidMobPatch.DamageSourceModifier deserializeDamageModifier(CompoundTag args) {
        float damage = args.m_128441_("damage") ? args.m_128457_("damage") : 1.0f;
        float impact = args.m_128441_("impact") ? args.m_128457_("impact") : 1.0f;
        float armor_negation = args.m_128441_("armor_negation") ? args.m_128457_("armor_negation") : 1.0f;
        return new AdvancedCustomHumanoidMobPatch.DamageSourceModifier(damage, impact, armor_negation);
    }

    private static <T extends MobPatch<?>> CombatBehaviors.BehaviorPredicate<T> deserializeAdvancedBehaviorPredicate(String type, CompoundTag args) {
        Object predicate = null;
        ArrayList loggerNote = Lists.newArrayList();
        switch (type) {
            case "random_chance": {
                if (!args.m_128425_("chance", 6)) {
                    loggerNote.add(new String[]{"random_chance", "chance", "double", "0.0"});
                }
                predicate = new CombatBehaviors.RandomChance((float)args.m_128459_("chance"));
                break;
            }
            case "within_eye_height": {
                predicate = new CombatBehaviors.TargetWithinEyeHeight();
                break;
            }
            case "within_distance": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_distance", "min", "double", "0.0"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_distance", "max", "double", "0.0"});
                }
                predicate = new CombatBehaviors.TargetWithinDistance(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle", "within_distance", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "within_angle_horizontal": {
                if (!args.m_128425_("min", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "min", "double", "0.0F"});
                }
                if (!args.m_128425_("max", 6)) {
                    loggerNote.add(new String[]{"within_angle_horizontal", "max", "double", "0.0F"});
                }
                predicate = new CombatBehaviors.TargetWithinAngle.Horizontal(args.m_128459_("min"), args.m_128459_("max"));
                break;
            }
            case "health": {
                if (!args.m_128425_("health", 6)) {
                    loggerNote.add(new String[]{"health", "health", "double", "0.0F"});
                }
                if (!args.m_128425_("comparator", 8)) {
                    loggerNote.add(new String[]{"health", "comparator", "string", ""});
                }
                predicate = new CombatBehaviors.Health((float)args.m_128459_("health"), CombatBehaviors.Health.Comparator.valueOf((String)args.m_128461_("comparator").toUpperCase(Locale.ROOT)));
                break;
            }
            case "guard_break": {
                if (!args.m_128441_("invert")) {
                    loggerNote.add(new String[]{"guard_break", "invert", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsGuardBreak(args.m_128471_("invert"));
                break;
            }
            case "knock_down": {
                if (!args.m_128441_("invert")) {
                    loggerNote.add(new String[]{"knock_down", "invert", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsKnockDown(args.m_128471_("invert"));
                break;
            }
            case "attack_level": {
                if (!args.m_128425_("min", 3)) {
                    loggerNote.add(new String[]{"level", "min", "int", ""});
                }
                if (!args.m_128425_("max", 3)) {
                    loggerNote.add(new String[]{"level", "max", "int", ""});
                }
                predicate = new ExtraPredicate.TargetWithinState(args.m_128451_("min"), args.m_128451_("max"));
                break;
            }
            case "stamina": {
                if (!args.m_128425_("stamina", 6)) {
                    loggerNote.add(new String[]{"stamina", "stamina", "double", "0.0F"});
                }
                if (!args.m_128425_("comparator", 8)) {
                    loggerNote.add(new String[]{"stamina", "comparator", "string", ""});
                }
                predicate = new ExtraPredicate.SelfStamina((float)args.m_128459_("stamina"), CombatBehaviors.Health.Comparator.valueOf((String)args.m_128461_("comparator").toUpperCase(Locale.ROOT)));
                break;
            }
            case "using_item": {
                if (!args.m_128441_("edible")) {
                    loggerNote.add(new String[]{"using_item", "edible", "boolean", ""});
                }
                predicate = new ExtraPredicate.TargetIsUsingItem(args.m_128471_("edible"));
                break;
            }
            case "phase": {
                if (!args.m_128425_("min", 3)) {
                    loggerNote.add(new String[]{"phase", "min", "int", ""});
                }
                if (!args.m_128425_("max", 3)) {
                    loggerNote.add(new String[]{"phase", "max", "int", ""});
                }
                predicate = new ExtraPredicate.Phase(args.m_128451_("min"), args.m_128451_("max"));
            }
        }
        for (String[] formatArgs : loggerNote) {
            Indestructible.LOGGER.info(String.format("[Custom Entity Error] can't find a proper argument for %s. [name: %s, type: %s, default: %s]", formatArgs));
        }
        if (predicate == null) {
            throw new IllegalArgumentException("[Custom Entity Error] No predicate type: " + type);
        }
        return predicate;
    }

    public static class AdvancedCustomHumanoidMobPatchProvider
    extends MobPatchReloadListener.AbstractMobPatchProvider {
        protected Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> AHCombatBehaviors;
        protected Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> AHWeaponMotions;
        protected Map<WeaponCategory, Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>>> guardMotions;
        protected int regenStaminaStandbyTime;
        protected float regenStaminaMultiply;
        protected boolean hasStunReduction;
        protected float maxStunShield;
        protected int reganShieldStandbyTime;
        protected float reganShieldMultiply;
        protected float staminaLoseMultiply;
        protected float guardRadius;
        protected List<Pair<LivingMotion, StaticAnimation>> defaultAnimations;
        protected Map<StunType, StaticAnimation> stunAnimations;
        protected Map<Attribute, Double> attributeValues;
        protected Faction faction;
        protected double chasingSpeed;
        protected float scale;
        protected float maxStamina;
        protected List<AnimationEvent.ConditionalEvent> stunEvent;

        public EntityPatch<?> get(Entity entity) {
            return new AdvancedCustomHumanoidMobPatch(this.faction, this);
        }

        public Map<WeaponCategory, Map<Style, Set<Pair<LivingMotion, StaticAnimation>>>> getHumanoidWeaponMotions() {
            return this.AHWeaponMotions;
        }

        public Map<WeaponCategory, Map<Style, CombatBehaviors.Builder<HumanoidMobPatch<?>>>> getHumanoidCombatBehaviors() {
            return this.AHCombatBehaviors;
        }

        public Map<WeaponCategory, Map<Style, Pair<StaticAnimation, Pair<Float, Boolean>>>> getGuardMotions() {
            return this.guardMotions;
        }

        public List<Pair<LivingMotion, StaticAnimation>> getDefaultAnimations() {
            return this.defaultAnimations;
        }

        public Map<StunType, StaticAnimation> getStunAnimations() {
            return this.stunAnimations;
        }

        public Map<Attribute, Double> getAttributeValues() {
            return this.attributeValues;
        }

        public double getChasingSpeed() {
            return this.chasingSpeed;
        }

        public float getScale() {
            return this.scale;
        }

        public float getMaxStamina() {
            return this.maxStamina;
        }

        public int getRegenStaminaStandbyTime() {
            return this.regenStaminaStandbyTime;
        }

        public float getRegenStaminaMultiply() {
            return this.regenStaminaMultiply;
        }

        public boolean hasStunReduction() {
            return this.hasStunReduction;
        }

        public float getMaxStunShield() {
            return this.maxStunShield;
        }

        public int getReganShieldStandbyTime() {
            return this.reganShieldStandbyTime;
        }

        public float getReganShieldMultiply() {
            return this.reganShieldMultiply;
        }

        public float getStaminaLoseMultiply() {
            return this.staminaLoseMultiply;
        }

        public float getGuardRadius() {
            return this.guardRadius;
        }

        public List<AnimationEvent.ConditionalEvent> getStunEvent() {
            return this.stunEvent;
        }
    }
}

