/*
 * Decompiled with CFR 0.152.
 */
package com.nameless.indestructible.client.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix4f;
import com.nameless.indestructible.client.UIConfig;
import com.nameless.indestructible.world.capability.AdvancedCustomHumanoidMobPatch;
import java.util.Collection;
import java.util.Iterator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import yesman.epicfight.client.gui.EntityIndicator;
import yesman.epicfight.client.renderer.EpicFightRenderTypes;
import yesman.epicfight.client.world.capabilites.entitypatch.player.LocalPlayerPatch;
import yesman.epicfight.config.ClientConfig;
import yesman.epicfight.main.EpicFightMod;
import yesman.epicfight.world.capabilities.entitypatch.LivingEntityPatch;
import yesman.epicfight.world.effect.VisibleMobEffect;

public class StatusIndicator
extends EntityIndicator {
    public static final ResourceLocation STATUS_BAR = new ResourceLocation("indestructible", "textures/gui/bar.png");

    public boolean shouldDraw(LivingEntity entityIn, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch) {
        AdvancedCustomHumanoidMobPatch AHPatch;
        ClientConfig.HealthBarShowOptions option = (ClientConfig.HealthBarShowOptions)EpicFightMod.CLIENT_INGAME_CONFIG.healthBarShowOption.getValue();
        Minecraft mc = Minecraft.m_91087_();
        if (!((Boolean)UIConfig.REPLACE_UI.get()).booleanValue() || option == ClientConfig.HealthBarShowOptions.NONE) {
            return false;
        }
        if (!entityIn.m_6072_() || entityIn.m_20145_() || entityIn == ((LocalPlayer)playerpatch.getOriginal()).m_20202_()) {
            return false;
        }
        if (entityIn.m_20280_(mc.m_91288_()) >= 400.0) {
            return false;
        }
        if (entityIn instanceof Player) {
            Player playerIn = (Player)entityIn;
            if (playerIn == playerpatch.getOriginal() && playerpatch.getMaxStunShield() <= 0.0f) {
                return false;
            }
            if (playerIn.m_7500_() || playerIn.m_5833_()) {
                return false;
            }
        }
        if (option == ClientConfig.HealthBarShowOptions.TARGET) {
            return playerpatch.getTarget() == entityIn;
        }
        return (!entityIn.m_21220_().isEmpty() || entityIn.m_21223_() < entityIn.m_21233_() || entitypatch instanceof AdvancedCustomHumanoidMobPatch && (AHPatch = (AdvancedCustomHumanoidMobPatch)entitypatch).getStamina() < AHPatch.getMaxStamina()) && entityIn.f_20919_ < 19;
    }

    public void drawIndicator(LivingEntity entityIn, @Nullable LivingEntityPatch<?> entitypatch, LocalPlayerPatch playerpatch, PoseStack matStackIn, MultiBufferSource bufferIn, float partialTicks) {
        boolean adjustUI = entitypatch instanceof AdvancedCustomHumanoidMobPatch && (Boolean)UIConfig.REPLACE_UI.get() != false;
        float height = adjustUI ? 0.45f : 0.25f;
        Matrix4f mvMatrix = super.getMVMatrix(matStackIn, entityIn, 0.0f, entityIn.m_20206_() + height, 0.0f, true, partialTicks);
        Collection activeEffects = entityIn.m_21220_();
        if (!activeEffects.isEmpty() && !entityIn.m_7306_(playerpatch.getOriginal())) {
            Iterator iter = activeEffects.iterator();
            int acives = activeEffects.size();
            int row = acives > 1 ? 1 : 0;
            int column = (acives - 1) / 2;
            float startX = -0.8f + -0.3f * (float)row;
            float startY = -0.15f + 0.15f * (float)column;
            block0: for (int i = 0; i <= column; ++i) {
                for (int j = 0; j <= row; ++j) {
                    ResourceLocation rl;
                    MobEffectInstance effectInstance = (MobEffectInstance)iter.next();
                    MobEffect effect = effectInstance.m_19544_();
                    if (effect instanceof VisibleMobEffect) {
                        VisibleMobEffect visibleMobEffect = (VisibleMobEffect)effect;
                        rl = visibleMobEffect.getIcon(effectInstance);
                    } else {
                        rl = new ResourceLocation(effect.getRegistryName().m_135827_(), "textures/mob_effect/" + effect.getRegistryName().m_135815_() + ".png");
                    }
                    Minecraft.m_91087_().m_91097_().m_174784_(rl);
                    float x = startX + 0.3f * (float)j;
                    float y = startY + -0.3f * (float)i;
                    VertexConsumer vertexBuilder1 = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator((ResourceLocation)rl));
                    this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder1, x, y, x + 0.3f, y + 0.3f, 0.0f, 0.0f, 256.0f, 256.0f);
                    if (!iter.hasNext()) continue block0;
                }
            }
        }
        VertexConsumer vertexBuilder = bufferIn.m_6299_(EpicFightRenderTypes.entityIndicator((ResourceLocation)STATUS_BAR));
        float ratio = Mth.m_14036_((float)(entityIn.m_21223_() / entityIn.m_21233_()), (float)0.0f, (float)1.0f);
        float healthRatio = -0.5f + ratio;
        int textureRatio = (int)(65.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.05f, healthRatio, 0.08f, 0.0f, 26.0f, textureRatio, 35.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, healthRatio, -0.05f, 0.5f, 0.08f, textureRatio, 16.0f, 65.0f, 25.0f);
        if (entitypatch instanceof AdvancedCustomHumanoidMobPatch) {
            AdvancedCustomHumanoidMobPatch achpatch = (AdvancedCustomHumanoidMobPatch)entitypatch;
            this.renderStamina(achpatch, mvMatrix, vertexBuilder);
        }
    }

    private void renderStamina(AdvancedCustomHumanoidMobPatch<?> achpatch, Matrix4f mvMatrix, VertexConsumer vertexBuilder) {
        float ratio = Mth.m_14036_((float)(achpatch.getStamina() / achpatch.getMaxStamina()), (float)0.0f, (float)1.0f);
        float barRatio = -0.5f + ratio;
        int textureRatio = (int)(63.0f * ratio);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, -0.5f, -0.15f, barRatio, -0.05f, 0.0f, 8.0f, textureRatio, 15.0f);
        this.drawTexturedModalRect2DPlane(mvMatrix, vertexBuilder, barRatio, -0.15f, 0.5f, -0.05f, textureRatio, 0.0f, 63.0f, 7.0f);
    }
}

