/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;

public class WeightedRandomBag<T>
implements Iterable<T> {
    private double accumulatedWeight;
    private List<Entry> entries = new ArrayList<Entry>();
    private Random rand = new Random();

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e = new Entry();
        e.object = object;
        e.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e);
    }

    public T getRandom() {
        int index = this.getRandomIndex();
        if (index == -1) {
            return null;
        }
        return this.entries.get((int)index).object;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    private int getRandomIndex() {
        double r = this.rand.nextDouble() * this.accumulatedWeight;
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!(this.entries.get((int)i).accumulatedWeight >= r)) continue;
            return i;
        }
        return -1;
    }

    public List<T> getList() {
        return this.entries.stream().map(e -> e.object).collect(Collectors.toList());
    }

    public int size() {
        return this.entries.size();
    }

    @Override
    public Iterator<T> iterator() {
        ArrayList items = new ArrayList();
        HashSet<Integer> used = new HashSet<Integer>();
        while (used.size() < this.entries.size()) {
            int index = this.getRandomIndex();
            if (used.contains(index)) continue;
            used.add(index);
            items.add(this.entries.get((int)index).object);
        }
        return items.iterator();
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

