/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.tiles;

import ca.teamdman.zensummoning.common.Registrar;
import ca.teamdman.zensummoning.common.summoning.MobInfo;
import ca.teamdman.zensummoning.common.summoning.SummoningAttempt;
import ca.teamdman.zensummoning.common.summoning.SummoningDirector;
import ca.teamdman.zensummoning.common.summoning.SummoningInfo;
import ca.teamdman.zensummoning.util.UUIDHelper;
import ca.teamdman.zensummoning.util.WeightedRandomBag;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.item.MCItemStackMutable;
import com.google.common.collect.ImmutableList;
import com.mojang.math.Vector3d;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.Nullable;

public class TileAltar
extends BlockEntity {
    public final int TIME_TO_SPAWN = 100;
    private final ItemStackHandler clientInventory = new ItemStackHandler();
    private final ItemStackHandler inventory = new ItemStackHandler(SummoningDirector.getStackLimit()){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            TileAltar.this.f_58857_.m_7260_(TileAltar.this.m_58899_(), TileAltar.this.f_58857_.m_8055_(TileAltar.this.m_58899_()), TileAltar.this.f_58857_.m_8055_(TileAltar.this.m_58899_()), 3);
            TileAltar.this.m_6596_();
        }
    };
    private final Set<UUID> knownPlayers = new HashSet<UUID>();
    public int renderTick = -1;
    private int summonCountdown = -1;
    private SummoningInfo summonInfo;

    public TileAltar(BlockPos pos, BlockState state) {
        super((BlockEntityType)Registrar.ALTAR_TILE.get(), pos, state);
    }

    public Optional<SummoningAttempt> attemptWorldSummon() {
        AABB itemRange = new AABB(-1.0, -1.0, -1.0, 1.0, 1.0, 1.0).m_82338_(this.f_58858_);
        for (ItemEntity ent : this.f_58857_.m_142425_(EntityTypeTest.m_156916_(ItemEntity.class), itemRange, x -> true)) {
            SummoningAttempt attempt = this.attemptSummon(ent.m_32055_(), null);
            if (!attempt.isSuccess()) continue;
            return Optional.of(attempt);
        }
        return Optional.empty();
    }

    public SummoningAttempt attemptSummon(ItemStack catalyst, @javax.annotation.Nullable ServerPlayer summoner) {
        if (summoner == null) {
            assert (this.f_58857_ != null);
            assert (this.f_58857_.m_142572_() != null);
            summoner = this.knownPlayers.stream().map(arg_0 -> ((PlayerList)this.f_58857_.m_142572_().m_6846_()).m_11259_(arg_0)).filter(Objects::nonNull).findFirst().orElse(null);
        } else {
            this.addToKnownPlayers(summoner);
        }
        SummoningAttempt attempt = new SummoningAttempt(this.f_58857_, this.f_58858_, summoner);
        if (this.isSummoning()) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.busy");
            return attempt;
        }
        Optional<SummoningInfo> infoMatch = this.getSummonInfo(catalyst);
        if (!infoMatch.isPresent()) {
            attempt.setSuccess(false);
            attempt.setMessage(this.getAssumedErrorMessage(catalyst));
            return attempt;
        }
        SummoningInfo info = infoMatch.get();
        Optional<HashMap<Integer, Integer>> slotsMatch = this.getIngredientsToConsume(info);
        if (!slotsMatch.isPresent()) {
            attempt.setSuccess(false);
            attempt.setMessage("chat.zensummoning.unknown_error");
            return attempt;
        }
        Optional<String> failedConditionErrorMessage = info.getFailedConditionErrorMessage(attempt);
        if (failedConditionErrorMessage.isPresent()) {
            attempt.setSuccess(false);
            attempt.setMessage(failedConditionErrorMessage.get());
            return attempt;
        }
        info.getMutator().accept(attempt);
        if (!attempt.isSuccess()) {
            return attempt;
        }
        this.beginSummoning(info);
        slotsMatch.get().forEach((slot, count) -> this.inventory.extractItem(slot.intValue(), count.intValue(), false));
        if (info.isCatalystConsumed()) {
            catalyst.m_41774_(info.getCatalyst().getAmount());
        }
        return attempt;
    }

    public boolean isSummoning() {
        return this.summonInfo != null && this.summonCountdown >= 0;
    }

    private Optional<SummoningInfo> getSummonInfo(ItemStack catalyst) {
        WeightedRandomBag bag = new WeightedRandomBag();
        SummoningDirector.getSummonInfos().stream().filter(x -> this.meetsCriteria((SummoningInfo)x, catalyst)).forEach(x -> bag.addEntry(x, x.getWeight()));
        if (bag.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((SummoningInfo)bag.getRandom());
    }

    private boolean meetsCriteria(SummoningInfo info, ItemStack handStack) {
        if (!info.getCatalyst().getIngredient().matches((IItemStack)new MCItemStackMutable(handStack))) {
            return false;
        }
        if (info.getCatalyst().getAmount() > handStack.m_41613_()) {
            return false;
        }
        return this.getIngredientsToConsume(info).isPresent();
    }

    private Optional<HashMap<Integer, Integer>> getIngredientsToConsume(SummoningInfo info) {
        HashMap<Integer, Integer> slotUsage = new HashMap<Integer, Integer>();
        for (IIngredientWithAmount reagent : info.getReagents()) {
            int remaining = reagent.getAmount();
            for (int slot = 0; slot < this.inventory.getSlots() && remaining > 0; ++slot) {
                ItemStack slotStack = this.inventory.getStackInSlot(slot);
                int available = slotStack.m_41613_() - slotUsage.getOrDefault(slot, 0);
                if (!reagent.getIngredient().matches((IItemStack)new MCItemStackMutable(slotStack)) || available <= 0) continue;
                slotUsage.merge(slot, Math.min(remaining, available), Integer::sum);
                remaining -= available;
            }
            if (remaining <= 0) continue;
            return Optional.empty();
        }
        return Optional.of(slotUsage);
    }

    private String getAssumedErrorMessage(ItemStack handStack) {
        String msg = "chat.zensummoning.no_match";
        int mask = 0;
        for (SummoningInfo info : SummoningDirector.getSummonInfos()) {
            if (!info.getCatalyst().getIngredient().matches((IItemStack)new MCItemStackMutable(handStack))) continue;
            mask |= 1;
            if (info.getCatalyst().getAmount() >= handStack.m_41613_()) continue;
            mask |= 0x10;
        }
        if (mask == 0) {
            return "chat.zensummoning.no_match";
        }
        if (mask == 1) {
            return "chat.zensummoning.unsatisfied_hand";
        }
        return "chat.zensummoning.unsatisfied";
    }

    private void beginSummoning(SummoningInfo info) {
        this.summonInfo = info;
        this.summonCountdown = 100;
        this.renderTick = 0;
        this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.f_58857_.m_8055_(this.m_58899_()), 3);
        this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), SoundEvents.f_11862_, SoundSource.BLOCKS, 0.5f, 1.0f);
    }

    public void addToKnownPlayers(ServerPlayer playerEntity) {
        this.knownPlayers.add(playerEntity.m_142081_());
    }

    public boolean validIngredient(ItemStack item) {
        MCItemStackMutable stack = new MCItemStackMutable(item);
        return SummoningDirector.getSummonInfos().stream().flatMap(info -> info.getReagents().stream()).map(IIngredientWithAmount::getIngredient).anyMatch(r -> r.asVanillaIngredient().test(item));
    }

    public ItemStack pushStack(ItemStack stack) {
        ItemStack rtn = stack;
        for (int slot = 0; slot < this.inventory.getSlots() && !rtn.m_41619_(); ++slot) {
            rtn = this.inventory.insertItem(slot, rtn, false);
        }
        return rtn;
    }

    public ItemStack popStack() {
        for (int slot = this.inventory.getSlots() - 1; slot >= 0; --slot) {
            ItemStack rtn = this.inventory.getStackInSlot(slot);
            if (rtn.m_41619_()) continue;
            return this.inventory.extractItem(slot, rtn.m_41613_(), false);
        }
        return ItemStack.f_41583_;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ImmutableList<ItemStack> getClientStacks() {
        return this.getStacksFromInventory(this.clientInventory);
    }

    private ImmutableList<ItemStack> getStacksFromInventory(ItemStackHandler handler) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            if (stack.m_41619_()) continue;
            builder.add((Object)stack);
        }
        return builder.build();
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @javax.annotation.Nullable Direction side) {
        return cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? LazyOptional.of(() -> this.inventory) : super.getCapability(cap, side);
    }

    public static void onTick(Level level, BlockPos pos, BlockState state, TileAltar tile) {
        if (!tile.isSummoning()) {
            if (tile.renderTick > -1) {
                --tile.renderTick;
            }
            return;
        }
        --tile.summonCountdown;
        ++tile.renderTick;
        if (tile.summonCountdown > 0) {
            return;
        }
        tile.summonFinish();
    }

    private void summonFinish() {
        this.summonCountdown = -1;
        if (this.f_58857_.f_46443_) {
            this.summonInfo = null;
            return;
        }
        for (MobInfo mobInfo : this.summonInfo.getMobs()) {
            for (int i = 0; i < mobInfo.getCount(); ++i) {
                Entity mob = mobInfo.getEntityType().m_20615_(this.f_58857_);
                if (mob == null) {
                    return;
                }
                Vector3d mobPos = this.getRandomPosition(mobInfo);
                if (!mobInfo.getData().m_128456_()) {
                    CompoundTag newData = mobInfo.getData();
                    if (mobInfo.shouldMergeData()) {
                        CompoundTag ourData = newData;
                        newData = mob.serializeNBT();
                        for (String key : ourData.m_128431_()) {
                            newData.m_128365_(key, ourData.m_128423_(key));
                        }
                    }
                    mob.deserializeNBT(newData);
                    mob.m_6034_(mobPos.f_86214_, mobPos.f_86215_, mobPos.f_86216_);
                    if (newData.m_128425_("Passengers", 9)) {
                        ListTag passengers = newData.m_128437_("Passengers", 10);
                        passengers.forEach(p -> {
                            Entity e = EntityType.m_20645_((CompoundTag)((CompoundTag)p), (Level)this.f_58857_, rider -> {
                                rider.m_7678_(mobPos.f_86214_, mobPos.f_86215_, mobPos.f_86216_, rider.m_146908_(), rider.m_146909_());
                                return rider;
                            });
                            if (e == null) {
                                return;
                            }
                            e.m_7998_(mob, true);
                        });
                    }
                    ((ServerLevel)this.f_58857_).m_8860_(mob);
                    continue;
                }
                mob.m_6034_(mobPos.f_86214_, mobPos.f_86215_, mobPos.f_86216_);
                this.f_58857_.m_7967_(mob);
            }
        }
        this.f_58857_.m_7260_(this.m_58899_(), this.f_58857_.m_8055_(this.m_58899_()), this.f_58857_.m_8055_(this.m_58899_()), 3);
        SoundEvent toPlay = Registry.f_122821_.m_6612_(new ResourceLocation(this.summonInfo.getSound())).orElse(SoundEvents.f_11869_);
        this.f_58857_.m_6263_(null, (double)this.m_58899_().m_123341_(), (double)this.m_58899_().m_123342_(), (double)this.m_58899_().m_123343_(), toPlay, SoundSource.BLOCKS, 0.5f, 1.0f);
        this.summonInfo = null;
    }

    private Vector3d getRandomPosition(MobInfo mobInfo) {
        return new Vector3d((double)((float)this.m_58899_().m_123341_() + mobInfo.getOffset().m_122239_() + this.f_58857_.f_46441_.nextFloat() * (Math.abs(mobInfo.getSpread().m_122239_() * 2.0f) + 1.0f) - Math.abs(mobInfo.getSpread().m_122239_())), (double)((float)this.m_58899_().m_123342_() + mobInfo.getOffset().m_122260_() + this.f_58857_.f_46441_.nextFloat() * (Math.abs(mobInfo.getSpread().m_122260_() * 2.0f) + 1.0f) - Math.abs(mobInfo.getSpread().m_122260_())), (double)((float)this.m_58899_().m_123343_() + mobInfo.getOffset().m_122269_() + this.f_58857_.f_46441_.nextFloat() * (Math.abs(mobInfo.getSpread().m_122269_() * 2.0f) + 1.0f) - Math.abs(mobInfo.getSpread().m_122269_())));
    }

    public void m_142466_(CompoundTag nbt) {
        super.m_142466_(nbt);
        nbt.m_128469_("inventory").m_128405_("Size", Math.max(SummoningDirector.getStackLimit(), nbt.m_128469_("inventory").m_128451_("Size")));
        this.inventory.deserializeNBT(nbt.m_128469_("inventory"));
        this.renderTick = nbt.m_128451_("renderTick");
        this.summonCountdown = nbt.m_128451_("summonCountdown");
        UUIDHelper.deserialize(nbt.m_128437_("knownPlayers", 8)).forEach(this.knownPlayers::add);
        if (nbt.m_128425_("summonInfo", 10)) {
            this.summonInfo = SummoningInfo.fromNBT(nbt.m_128469_("summonInfo"));
        } else if (!this.isSummoning()) {
            this.clientInventory.deserializeNBT(nbt.m_128469_("inventory"));
        }
    }

    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128365_("inventory", (Tag)this.inventory.serializeNBT());
        compound.m_128405_("renderTick", this.renderTick);
        compound.m_128405_("summonCountdown", this.summonCountdown);
        compound.m_128365_("knownPlayers", (Tag)UUIDHelper.serialize(this.knownPlayers));
        if (this.isSummoning()) {
            compound.m_128365_("summonInfo", (Tag)this.summonInfo.serializeNBT());
        }
    }

    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_183216_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.deserializeNBT(pkt.m_131708_());
    }
}

