/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.summoning;

import ca.teamdman.zensummoning.common.summoning.MobInfo;
import ca.teamdman.zensummoning.common.summoning.SummoningAttempt;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.zensummoning.SummoningInfo")
@ZenRegister
@Document(value="mods/zensummoning/SummoningInfo")
public class SummoningInfo {
    private IIngredientWithAmount catalyst = null;
    private List<SummoningCondition> conditions = new LinkedList<SummoningCondition>();
    private boolean consumeCatalyst = true;
    private List<MobInfo> mobs = new ArrayList<MobInfo>();
    private Consumer<SummoningAttempt> mutator = __ -> {};
    private List<IIngredientWithAmount> reagents = new ArrayList<IIngredientWithAmount>();
    private String sound = SoundEvents.f_11869_.getRegistryName().toString();
    private double weight = 1.0;

    @ZenCodeType.Constructor
    public SummoningInfo() {
    }

    public static SummoningInfo fromNBT(CompoundTag compound) {
        SummoningInfo info = new SummoningInfo();
        ListTag mobs = compound.m_128437_("mobs", 10);
        for (int i = 0; i < mobs.size(); ++i) {
            CompoundTag mob = mobs.m_128728_(i);
            info.addMob(new MobInfo(mob.m_128469_("data"), (EntityType)ForgeRegistries.ENTITIES.getValue(new ResourceLocation(mob.m_128461_("mob"))), new Vector3f(mob.m_128457_("x"), mob.m_128457_("y"), mob.m_128457_("z")), new Vector3f(mob.m_128457_("dx"), mob.m_128457_("dy"), mob.m_128457_("dz"))));
        }
        return info;
    }

    @ZenCodeType.Method
    public SummoningInfo addMob(MobInfo info) {
        this.mobs.add(info);
        return this;
    }

    @ZenCodeType.Method
    public static SummoningInfo create() {
        return new SummoningInfo();
    }

    public String getSound() {
        return this.sound;
    }

    @ZenCodeType.Method
    public SummoningInfo setSound(String sound) {
        this.sound = sound;
        return this;
    }

    public List<SummoningCondition> getConditions() {
        return this.conditions;
    }

    public Optional<String> getFailedConditionErrorMessage(SummoningAttempt attempt) {
        return this.conditions.stream().filter(condition -> !condition.PREDICATE.test(attempt)).findFirst().map(condition -> condition.FAILURE_MESSAGE);
    }

    public double getWeight() {
        return this.weight;
    }

    @ZenCodeType.Method
    public SummoningInfo setWeight(double weight) {
        this.weight = weight;
        return this;
    }

    @ZenCodeType.Method
    public SummoningInfo addCondition(Predicate<SummoningAttempt> condition, String failureMessage, String jeiDescription) {
        this.conditions.add(new SummoningCondition(condition, failureMessage, jeiDescription));
        return this;
    }

    public IIngredientWithAmount getCatalyst() {
        return this.catalyst;
    }

    @ZenCodeType.Method
    public SummoningInfo setCatalyst(IIngredientWithAmount ingredient) {
        this.catalyst = ingredient;
        return this;
    }

    @ZenCodeType.Method
    public SummoningInfo setConsumeCatalyst(boolean value) {
        this.consumeCatalyst = value;
        return this;
    }

    public boolean isCatalystConsumed() {
        return this.consumeCatalyst;
    }

    public List<MobInfo> getMobs() {
        return Collections.unmodifiableList(this.mobs);
    }

    public List<IIngredientWithAmount> getReagents() {
        return Collections.unmodifiableList(this.reagents);
    }

    @ZenCodeType.Method
    public SummoningInfo setReagents(IIngredientWithAmount[] reagents) {
        this.reagents.clear();
        Collections.addAll(this.reagents, reagents);
        return this;
    }

    public Consumer<SummoningAttempt> getMutator() {
        return this.mutator;
    }

    @ZenCodeType.Method
    public SummoningInfo setMutator(Consumer<SummoningAttempt> mutator) {
        this.mutator = mutator;
        return this;
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        ListTag mobs = new ListTag();
        for (MobInfo info : this.mobs) {
            CompoundTag mob = new CompoundTag();
            mob.m_128359_("mob", info.getMobId().toString());
            mob.m_128365_("data", (Tag)info.getData());
            mob.m_128350_("x", info.getOffset().m_122239_());
            mob.m_128350_("y", info.getOffset().m_122260_());
            mob.m_128350_("z", info.getOffset().m_122269_());
            mob.m_128350_("dx", info.getSpread().m_122239_());
            mob.m_128350_("dy", info.getSpread().m_122260_());
            mob.m_128350_("dz", info.getSpread().m_122269_());
            mobs.add((Object)mob);
        }
        compound.m_128365_("mobs", (Tag)mobs);
        return compound;
    }

    public class SummoningCondition {
        public final String FAILURE_MESSAGE;
        public final String JEI_DESCRIPTION;
        public final Predicate<SummoningAttempt> PREDICATE;

        public SummoningCondition(Predicate<SummoningAttempt> PREDICATE, String FAILURE_MESSAGE, String JEI_DESCRIPTION) {
            this.PREDICATE = PREDICATE;
            this.FAILURE_MESSAGE = FAILURE_MESSAGE;
            this.JEI_DESCRIPTION = JEI_DESCRIPTION;
        }
    }
}

