/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.summoning;

import ca.teamdman.zensummoning.common.summoning.SummoningInfo;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.CraftTweakerConstants;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.base.IUndoableAction;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.zencode.IScriptLoadSource;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import java.util.ArrayList;
import java.util.List;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.zensummoning.SummoningDirector")
@Document(value="mods/zensummoning/SummoningDirector")
public class SummoningDirector {
    private static final List<SummoningInfo> summonings = new ArrayList<SummoningInfo>();
    private static int stackLimit = 0;

    public static int getStackLimit() {
        return stackLimit;
    }

    public static List<SummoningInfo> getSummonInfos() {
        return summonings;
    }

    @ZenCodeType.Method
    public static void addSummonInfo(SummoningInfo info) {
        CraftTweakerAPI.apply((IAction)new AddSummonInfoAction(info));
    }

    private static void tightenStackLimit() {
        stackLimit = summonings.stream().map(SummoningInfo::getReagents).mapToInt(List::size).max().orElse(0);
    }

    private static class AddSummonInfoAction
    implements IUndoableAction {
        private final SummoningInfo INFO;

        public AddSummonInfoAction(SummoningInfo info) {
            this.INFO = info;
        }

        public void undo() {
            summonings.remove(this.INFO);
            SummoningDirector.tightenStackLimit();
        }

        public boolean shouldApplyOn(IScriptLoadSource source) {
            return source.id().equals((Object)CraftTweakerConstants.RELOAD_LISTENER_SOURCE_ID) || source.id().equals((Object)CraftTweakerConstants.CLIENT_RECIPES_UPDATED_SOURCE_ID);
        }

        public String describeUndo() {
            return "Unregistering summoning " + this.INFO.toString();
        }

        public void apply() {
            summonings.add(this.INFO);
            SummoningDirector.tightenStackLimit();
        }

        public String describe() {
            return "Registering summoning " + this.INFO.toString();
        }
    }
}

