/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.summoning;

import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.data.base.IData;
import com.blamejared.crafttweaker_annotations.annotations.Document;
import com.mojang.math.Vector3f;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import org.openzen.zencode.java.ZenCodeType;

@ZenCodeType.Name(value="mods.zensummoning.MobInfo")
@ZenRegister
@Document(value="mods/zensummoning/MobInfo")
public class MobInfo {
    private int count = 1;
    private CompoundTag data = new CompoundTag();
    private boolean mergeData = false;
    private EntityType<?> mob = null;
    private Vector3f offset = new Vector3f(0.5f, 0.0f, 0.5f);
    private Vector3f spread = new Vector3f(0.0f, 0.0f, 0.0f);

    @ZenCodeType.Constructor
    public MobInfo() {
    }

    MobInfo(CompoundTag data, EntityType<?> mob, Vector3f offset, Vector3f spread) {
        this.data = data;
        this.mob = mob;
        this.offset = offset;
        this.spread = spread;
    }

    @ZenCodeType.Method
    public static MobInfo create() {
        return new MobInfo();
    }

    public Vector3f getSpread() {
        return this.spread;
    }

    public int getCount() {
        return this.count;
    }

    @ZenCodeType.Method
    public MobInfo setCount(int count) {
        this.count = count;
        return this;
    }

    public CompoundTag getData() {
        return this.data;
    }

    public boolean shouldMergeData() {
        return this.mergeData;
    }

    @ZenCodeType.Method
    public MobInfo setData(IData data) {
        this.data = (CompoundTag)data.getInternal();
        return this;
    }

    @ZenCodeType.Method
    public MobInfo mergeData() {
        this.mergeData = true;
        return this;
    }

    public ResourceLocation getMobId() {
        return this.mob.getRegistryName();
    }

    public EntityType<?> getEntityType() {
        return this.mob;
    }

    @ZenCodeType.Method
    public MobInfo setMob(EntityType mob) {
        this.mob = mob;
        return this;
    }

    public Vector3f getOffset() {
        return this.offset;
    }

    @ZenCodeType.Method
    public MobInfo setOffset(float x, float y, float z) {
        this.offset = new Vector3f(x, y, z);
        return this;
    }

    @ZenCodeType.Method
    public MobInfo setSpread(float x, float y, float z) {
        if (x < 0.0f || y < 0.0f || z < 0.0f) {
            System.out.println("Spread operates as a distance factor on each x,y,z plane, distances shouldn't be negative.");
        }
        this.spread = new Vector3f(Math.abs(x), Math.abs(y), Math.abs(z));
        return this;
    }
}

