/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.common.blocks;

import ca.teamdman.zensummoning.common.Registrar;
import ca.teamdman.zensummoning.common.summoning.SummoningAttempt;
import ca.teamdman.zensummoning.common.tiles.TileAltar;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BlockAltar
extends BaseEntityBlock
implements EntityBlock {
    protected static final VoxelShape SHAPE = Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0, (double)15.0);
    private final AABB bb = new AABB(0.0625, 0.0, 0.0625, 0.9375, 0.0625, 0.9375);

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    public BlockAltar() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76283_).m_60955_().m_60910_().m_60913_(5.0f, 6.0f));
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return true;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @javax.annotation.Nullable LivingEntity entity, ItemStack stack) {
        if (level.f_46443_) {
            return;
        }
        if (!(entity instanceof ServerPlayer)) {
            return;
        }
        BlockEntity tileEntity = level.m_7702_(pos);
        if (!(tileEntity instanceof TileAltar)) {
            return;
        }
        ((TileAltar)tileEntity).addToKnownPlayers((ServerPlayer)entity);
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof TileAltar) {
            ItemStack stack;
            TileAltar altar = (TileAltar)tile;
            while (!(stack = altar.popStack()).m_41619_()) {
                Containers.m_18992_((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (ItemStack)stack);
            }
            level.m_46717_(pos, (Block)this);
        }
        super.m_5707_(level, pos, state, player);
    }

    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!world.f_46443_ && world.m_46753_(pos)) {
            BlockEntity tile = world.m_7702_(pos);
            if (!(tile instanceof TileAltar)) {
                return;
            }
            if (((TileAltar)tile).isSummoning()) {
                return;
            }
            if (((TileAltar)tile).attemptWorldSummon().isPresent()) {
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12212_, SoundSource.BLOCKS, 0.5f, 0.1f);
            } else {
                world.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 0.05f, 1.0f);
            }
        }
        super.m_6861_(state, world, pos, blockIn, fromPos, isMoving);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.f_46443_) {
            return InteractionResult.CONSUME;
        }
        BlockEntity tile = level.m_7702_(pos);
        if (!(tile instanceof TileAltar)) {
            return InteractionResult.CONSUME;
        }
        TileAltar altar = (TileAltar)tile;
        if (player.m_6144_()) {
            ItemStack catalyst = player.m_21120_(hand);
            SummoningAttempt result = altar.attemptSummon(catalyst, (ServerPlayer)player);
            player.m_21008_(hand, catalyst);
            player.m_6352_((Component)new TranslatableComponent(result.getMessage()), Util.f_137441_);
            if (result.isSuccess()) {
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12212_, SoundSource.BLOCKS, 0.5f, 0.1f);
            } else {
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_11668_, SoundSource.BLOCKS, 0.05f, 1.0f);
            }
        } else if (player.m_21120_(hand).m_41619_()) {
            player.m_21008_(hand, altar.popStack());
            level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, -0.5f);
        } else {
            ItemStack handStack = player.m_21120_(hand);
            if (!altar.validIngredient(handStack)) {
                player.m_6352_((Component)new TranslatableComponent("chat.zensummoning.invalid_ingredient"), Util.f_137441_);
                return InteractionResult.CONSUME;
            }
            ItemStack remaining = altar.pushStack(handStack);
            if (handStack.equals(remaining, false)) {
                player.m_6352_((Component)new TranslatableComponent("chat.zensummoning.full"), Util.f_137441_);
            } else {
                player.m_21008_(hand, remaining);
                level.m_6263_(null, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), SoundEvents.f_12019_, SoundSource.BLOCKS, 0.5f, 2.0f);
            }
        }
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileAltar(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return BlockAltar.m_152132_(type, (BlockEntityType)((BlockEntityType)Registrar.ALTAR_TILE.get()), TileAltar::onTick);
    }
}

