/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.client.render.tile;

import ca.teamdman.zensummoning.common.tiles.TileAltar;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.ItemStack;

public class TESRAltar
implements BlockEntityRenderer<TileAltar> {
    public TESRAltar(BlockEntityRendererProvider.Context context) {
    }

    public void render(TileAltar te, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int combinedLightIn, int combinedOverlayIn) {
        ImmutableList<ItemStack> stacks = te.getClientStacks();
        if (stacks == null || stacks.isEmpty()) {
            return;
        }
        int count = stacks.size();
        Objects.requireNonNull(te);
        float scale = 1.0f - 1.0f / 100.0f * ((float)te.renderTick + partialTicks);
        matrixStack.m_85836_();
        matrixStack.m_85837_(0.5, 0.0, 0.5);
        Vector3f verticalAxis = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f depthAxis = new Vector3f(1.0f, 0.0f, 0.0f);
        matrixStack.m_85845_(verticalAxis.m_122270_((float)te.m_58904_().m_46467_() / 100.0f));
        for (ItemStack stack : stacks) {
            matrixStack.m_85845_(verticalAxis.m_122240_(360.0f / (float)count));
            if (te.isSummoning()) {
                matrixStack.m_85837_(0.0, 1.2 * (double)(1.0f - scale), 0.0);
            }
            matrixStack.m_85836_();
            matrixStack.m_85837_((double)(1.0f + (float)count / 15.0f), 0.0, 0.0);
            matrixStack.m_85845_(verticalAxis.m_122240_(90.0f));
            matrixStack.m_85845_(depthAxis.m_122240_(-90.0f));
            matrixStack.m_85841_(scale, scale, scale);
            Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.GROUND, combinedLightIn, combinedOverlayIn, matrixStack, bufferIn, (int)te.m_58899_().m_121878_());
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }
}

