/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.zensummoning.client.jei;

import ca.teamdman.zensummoning.ZenSummoning;
import ca.teamdman.zensummoning.common.Registrar;
import ca.teamdman.zensummoning.common.summoning.MobInfo;
import ca.teamdman.zensummoning.common.summoning.SummoningInfo;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.mojang.blaze3d.vertex.PoseStack;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;

class AltarCategory
implements IRecipeCategory<SummoningInfo> {
    private final int HEIGHT = 120;
    private final int WIDTH = 160;
    private final IDrawable background;
    private final IDrawable icon;

    public AltarCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createBlankDrawable(160, 120);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((ItemLike)Registrar.ALTAR_BLOCK.get()));
    }

    public ResourceLocation getUid() {
        return ZenSummoning.JEI_CATEGORY;
    }

    public Class<SummoningInfo> getRecipeClass() {
        return SummoningInfo.class;
    }

    public Component getTitle() {
        return new TranslatableComponent("jei.zensummoning.recipe.altar");
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(SummoningInfo recipe, IIngredients ingredients) {
        List<ItemStack> inputs = Stream.concat(Stream.of(recipe.getCatalyst()), recipe.getReagents().stream()).flatMap(x -> Arrays.stream(x.getIngredient().getItems())).map(IItemStack::getInternal).toList();
        ListTag lore = new ListTag();
        lore.add((Object)StringTag.m_129297_((String)I18n.m_118938_((String)"jei.zensummoning.catalyst.lore", (Object[])new Object[0])));
        inputs.get(0).m_41698_("display").m_128365_("Lore", (Tag)lore);
        List outputs = recipe.getMobs().stream().map(MobInfo::getEntityType).map(SpawnEggItem::m_43213_).map(ItemStack::new).filter(stack -> !stack.m_41619_()).collect(Collectors.toList());
        outputs.add(new ItemStack((ItemLike)Registrar.ALTAR_BLOCK.get()));
        ingredients.setInputs(VanillaTypes.ITEM, inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, outputs);
    }

    public void setRecipe(IRecipeLayout recipeLayout, SummoningInfo summoningInfo, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        guiItemStacks.init(0, true, 72, 44);
        int size = ingredients.getInputs(VanillaTypes.ITEM).size();
        double dist = 25 + size * 2;
        double cut = Math.PI * 2 / (double)(size - 1);
        for (i = 0; i < size - 1; ++i) {
            double x = Math.cos(cut * (double)i) * dist;
            double y = Math.sin(cut * (double)i) * dist;
            guiItemStacks.init(i + 1, true, 72 + (int)x, 52 + (int)y);
        }
        guiItemStacks.set(ingredients);
        guiItemStacks.init(++i, false, 72, 52);
        guiItemStacks.set(i, new ItemStack((ItemLike)Registrar.ALTAR_BLOCK.get()));
    }

    public void draw(SummoningInfo recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int i = 0;
        Minecraft minecraft = Minecraft.m_91087_();
        for (MobInfo mob : recipe.getMobs()) {
            minecraft.f_91062_.m_92883_(stack, I18n.m_118938_((String)"jei.zensummoning.recipe.altar.entity", (Object[])new Object[]{mob.getCount(), I18n.m_118938_((String)mob.getEntityType().m_20675_(), (Object[])new Object[0])}), 0.0f, (float)(9 * i++), Color.GRAY.getRGB());
        }
        minecraft.f_91062_.m_92883_(stack, I18n.m_118938_((String)"jei.zensummoning.recipe.altar.isCatalystConsumed", (Object[])new Object[]{recipe.isCatalystConsumed()}), 0.0f, (float)(9 * i++), Color.GRAY.getRGB());
        minecraft.f_91062_.m_92883_(stack, I18n.m_118938_((String)"jei.zensummoning.recipe.altar.weight", (Object[])new Object[]{recipe.getWeight()}), 0.0f, (float)(9 * i++), Color.GRAY.getRGB());
        for (SummoningInfo.SummoningCondition condition : recipe.getConditions()) {
            minecraft.f_91062_.m_92883_(stack, condition.JEI_DESCRIPTION, 0.0f, (float)(9 * i++), Color.GRAY.getRGB());
        }
    }
}

