/*
 * Decompiled with CFR 0.152.
 */
package samebutdifferent.ecologics.client.model;

import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import samebutdifferent.ecologics.entity.CoconutCrab;
import samebutdifferent.ecologics.util.AnimationUtil;

@OnlyIn(value=Dist.CLIENT)
public class CoconutCrabModel
extends HierarchicalModel<CoconutCrab> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("ecologics", "coconut_crab"), "main");
    private final ModelPart root;
    private final ModelPart head;
    private final ModelPart shell;
    private final ModelPart leftHindLeg;
    private final ModelPart rightHindLeg;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftMiddleLeg;
    private final ModelPart rightMiddleLeg;
    private final ModelPart rightClaw;
    private final ModelPart leftClaw;

    public CoconutCrabModel(ModelPart root) {
        super(RenderType::m_110458_);
        this.root = root.m_171324_("root");
        this.head = this.root.m_171324_("head");
        this.shell = this.root.m_171324_("shell");
        this.leftHindLeg = this.root.m_171324_("leftHindLeg");
        this.rightHindLeg = this.root.m_171324_("rightHindLeg");
        this.leftFrontLeg = this.root.m_171324_("leftFrontLeg");
        this.rightFrontLeg = this.root.m_171324_("rightFrontLeg");
        this.leftMiddleLeg = this.root.m_171324_("leftMiddleLeg");
        this.rightMiddleLeg = this.root.m_171324_("rightMiddleLeg");
        this.rightClaw = this.root.m_171324_("rightClaw");
        this.leftClaw = this.root.m_171324_("leftClaw");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_().m_171514_(0, 24).m_171488_(-3.5f, -9.0f, -4.0f, 7.0f, 5.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition shell = root.m_171599_("shell", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-6.0f, -6.0f, -8.0f, 12.0f, 12.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-8.4f, (float)6.0f, (float)-0.7854f, (float)0.0f, (float)0.0f));
        PartDefinition leftClaw = root.m_171599_("leftClaw", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)3.2277f, (float)-4.1522f, (float)-5.5809f));
        PartDefinition cube_r1 = leftClaw.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(31, 36).m_171488_(-3.0f, -4.0f, -3.0f, 5.0f, 3.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)1.2723f, (float)2.1522f, (float)0.5809f, (float)0.0f, (float)-0.3054f, (float)-0.5236f));
        PartDefinition rightClaw = root.m_171599_("rightClaw", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = rightClaw.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(34, 28).m_171488_(-2.3986f, -2.0f, -3.9074f, 6.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-3.9345f, (float)-3.4055f, (float)-4.2544f, (float)0.0f, (float)0.3054f, (float)0.5236f));
        PartDefinition head = root.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(36, 0).m_171488_(-2.5f, -2.25f, -4.0f, 5.0f, 4.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-6.25f, (float)-4.0f));
        PartDefinition eyes = head.m_171599_("eyes", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-2.5f, -1.5f, 0.0f, 5.0f, 3.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-3.75f, (float)-4.0f));
        PartDefinition rightMiddleLeg = root.m_171599_("rightMiddleLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-15.0f, -2.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)-0.3927f));
        PartDefinition leftMiddleLeg = root.m_171599_("leftMiddleLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171480_().m_171488_(5.0f, -2.0f, -1.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.0f, (float)0.3927f));
        PartDefinition rightFrontLeg = root.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-15.0f, -2.0f, -2.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)-0.3927f));
        PartDefinition leftFrontLeg = root.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171480_().m_171488_(5.0f, -2.0f, -2.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.2618f, (float)0.3927f));
        PartDefinition rightHindLeg = root.m_171599_("rightHindLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171488_(-15.0f, -2.0f, 0.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)0.2618f, (float)-0.3927f));
        PartDefinition leftHindLeg = root.m_171599_("leftHindLeg", CubeListBuilder.m_171558_().m_171514_(24, 24).m_171480_().m_171488_(5.0f, -2.0f, 0.0f, 10.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-3.0f, (float)-6.0f, (float)-1.0f, (float)0.0f, (float)-0.2618f, (float)0.3927f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(CoconutCrab entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setupInitialAnimationValues();
        this.head.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.head.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.shell.f_104207_ = entity.hasCoconut();
        float swingSlowdownFactor = 0.2f;
        this.shell.f_104203_ += Mth.m_14089_((float)((float)(Math.toRadians(-360.0) + (double)limbSwing))) * swingSlowdownFactor * limbSwingAmount;
        this.shell.f_104205_ += Mth.m_14089_((float)((float)(Math.toRadians(-60.0) + (double)limbSwing))) * swingSlowdownFactor * limbSwingAmount;
        float legLimbSwingAmount = Math.min(limbSwingAmount, 0.6f);
        this.leftHindLeg.f_104204_ += -Mth.m_14089_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftHindLeg.f_104205_ += Mth.m_14089_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightHindLeg.f_104204_ += -Mth.m_14089_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightHindLeg.f_104205_ += Mth.m_14089_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftFrontLeg.f_104204_ += Mth.m_14031_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftFrontLeg.f_104205_ += -Mth.m_14031_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightFrontLeg.f_104204_ += Mth.m_14031_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightFrontLeg.f_104205_ += -Mth.m_14031_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftMiddleLeg.f_104204_ += Mth.m_14089_((float)((float)(Math.toRadians(-120.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftMiddleLeg.f_104205_ += -Mth.m_14089_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightMiddleLeg.f_104204_ += Mth.m_14089_((float)((float)(Math.toRadians(-120.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightMiddleLeg.f_104205_ += -Mth.m_14089_((float)((float)(Math.toRadians(-80.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftClaw.f_104203_ += -Mth.m_14089_((float)((float)(Math.toRadians(-20.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.leftClaw.f_104205_ += -Mth.m_14089_((float)((float)(Math.toRadians(-20.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightClaw.f_104203_ += Mth.m_14089_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
        this.rightClaw.f_104205_ += Mth.m_14089_((float)((float)(Math.toRadians(-40.0) + (double)limbSwing))) * swingSlowdownFactor * legLimbSwingAmount;
    }

    public ModelPart m_142109_() {
        return this.root;
    }

    private void setupInitialAnimationValues() {
        AnimationUtil.setInitialValue(this.root, 0.0f, 24.0f, 0.0f);
        AnimationUtil.setInitialValue(this.head, 0.0f, -6.25f, -4.0f);
        AnimationUtil.setInitialValue(this.shell, 0.0f, -8.4f, 6.0f, -0.7854f, 0.0f, 0.0f);
        AnimationUtil.setInitialValue(this.leftHindLeg, -3.0f, -6.0f, -1.0f, 0.0f, -0.2618f, 0.3927f);
        AnimationUtil.setInitialValue(this.rightHindLeg, 3.0f, -6.0f, -1.0f, 0.0f, 0.2618f, -0.3927f);
        AnimationUtil.setInitialValue(this.leftFrontLeg, -3.0f, -6.0f, -1.0f, 0.0f, 0.2618f, 0.3927f);
        AnimationUtil.setInitialValue(this.rightFrontLeg, 3.0f, -6.0f, -1.0f, 0.0f, -0.2618f, -0.3927f);
        AnimationUtil.setInitialValue(this.leftMiddleLeg, -3.0f, -6.0f, -1.0f, 0.0f, 0.0f, 0.3927f);
        AnimationUtil.setInitialValue(this.rightMiddleLeg, 3.0f, -6.0f, -1.0f, 0.0f, 0.0f, -0.3927f);
        AnimationUtil.setInitialValue(this.rightClaw);
        AnimationUtil.setInitialValue(this.leftClaw, 3.2277f, -4.1522f, -5.5809f);
    }
}

