/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.helpers;

import bottomtextdanny.braincell.mod.entity.psyche.input.ActionInputKey;
import bottomtextdanny.braincell.mod.entity.psyche.targeting.MobMatchPredicate;
import bottomtextdanny.braincell.mod.world.entity_utilities.PsycheEntity;
import java.util.Random;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;

public final class CombatHelper {
    private static final Random RANDOM = new Random();

    public static boolean mayDisableShield(Entity target, int ticks, float possibility) {
        if (target instanceof Player) {
            Player player = (Player)target;
            if (RANDOM.nextFloat() < possibility && player.m_21254_()) {
                if (!player.m_36335_().m_41519_(player.m_21211_().m_41720_())) {
                    player.f_19853_.m_7605_(target, (byte)30);
                }
                player.m_36335_().m_41524_(player.m_21211_().m_41720_(), ticks);
                player.m_5810_();
                return true;
            }
        }
        return false;
    }

    public static boolean disableShield(Entity target, int ticks) {
        return CombatHelper.mayDisableShield(target, ticks, 1.0f);
    }

    public static boolean attackWithMultiplier(Mob attacker, LivingEntity livingEntity, float mult) {
        return livingEntity.m_6469_(DamageSource.m_19370_((LivingEntity)attacker), (float)attacker.m_21133_(Attributes.f_22281_) * mult);
    }

    public static float getHealthNormalized(Mob attacker) {
        return attacker.m_21223_() / attacker.m_21233_();
    }

    public static boolean hasLivingAttackTarget(Mob mob) {
        return mob.m_5448_() != null && mob.m_5448_().m_6084_() && !mob.m_146910_();
    }

    public static boolean isValidAttackTarget(LivingEntity mob) {
        return mob != null && mob.m_6084_() && !mob.m_146910_() && EntitySelector.f_20406_.test(mob);
    }

    public static boolean isValidAttackTarget(Mob targeter, LivingEntity target) {
        PsycheEntity psyched;
        if (targeter instanceof PsycheEntity && (psyched = (PsycheEntity)targeter).getPsyche() != null) {
            MobMatchPredicate<LivingEntity> pred = psyched.getPsyche().getInputs().getOfDefault(ActionInputKey.TARGET_VALIDATOR);
            return target != null && target.m_6084_() && !target.m_146910_() && pred.test(targeter, target);
        }
        return target != null && target.m_6084_() && !target.m_146910_() && EntitySelector.f_20406_.test(target);
    }
}

