/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_sound_instances;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.AbstractTickableSoundInstance;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;

public class EntityMovingSound
extends AbstractTickableSoundInstance {
    private final Entity entity;
    private float distance;
    private float baseVolume;

    private EntityMovingSound(Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch, float distance) {
        super(sound, category);
        this.entity = entity;
        this.f_119578_ = false;
        this.f_119579_ = 0;
        this.f_119573_ = volume;
        this.f_119582_ = false;
        this.f_119574_ = pitch;
        this.distance = distance;
        this.baseVolume = volume;
    }

    public static Builder builder(Entity entity, SoundEvent sound, SoundSource category) {
        return new Builder(entity, sound, category);
    }

    public void m_7788_() {
        if (!this.entity.m_146910_() && Minecraft.m_91087_().f_91074_ != null) {
            boolean distanceFlag;
            float dist = Minecraft.m_91087_().f_91074_.m_20270_(this.entity);
            boolean bl = this.distance == -1.0f ? dist < 20.0f : (distanceFlag = dist < this.distance);
            if (distanceFlag) {
                if (this.distance != -1.0f) {
                    this.f_119573_ = (1.0f - dist / this.distance) * this.baseVolume;
                }
                this.f_119575_ = this.entity.m_20182_().f_82479_;
                this.f_119576_ = this.entity.m_20182_().f_82480_;
                this.f_119577_ = this.entity.m_20182_().f_82481_;
            } else {
                this.m_119609_();
            }
        } else {
            this.m_119609_();
        }
    }

    public static class Builder {
        private final Entity entity;
        private final SoundEvent sound;
        private final SoundSource category;
        private float volume = 1.0f;
        private float pitch = 1.0f;
        private float distance = 20.0f;

        private Builder(Entity entity, SoundEvent sound, SoundSource category) {
            this.entity = entity;
            this.sound = sound;
            this.category = category;
        }

        public Builder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public Builder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public Builder distance(float distance) {
            this.distance = distance;
            return this;
        }

        public EntityMovingSound build() {
            return new EntityMovingSound(this.entity, this.sound, this.category, this.volume, this.pitch, this.distance);
        }
    }
}

