/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_particles;

import bottomtextdanny.braincell.mod.world.particle_utilities.local_sprites.SpriteGroup;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import java.util.List;
import net.minecraft.client.Camera;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class BCParticle
extends TextureSheetParticle {
    public static final float RADIAN = (float)Math.PI / 180;
    protected int maxTime;
    protected int ticksPassed;
    protected SpriteGroup sprites;
    private int compressedTime = -1;
    protected int[] ticksForEachFrame;
    private int[] ticksForEachFrameDefault;
    protected boolean onCeiling;
    private float defaultSize;
    public float prevYaw;
    public float yaw;
    public float prevPitch;
    public float pitch;

    protected BCParticle(ClientLevel world, double x, double y, double z) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.f_107227_ = 1.0f;
        this.f_107228_ = 1.0f;
        this.f_107229_ = 1.0f;
    }

    public void m_5989_() {
        this.f_107209_ = this.f_107212_;
        this.f_107210_ = this.f_107213_;
        this.f_107211_ = this.f_107214_;
        this.prevPitch = this.pitch;
        this.prevYaw = this.yaw;
        ++this.ticksPassed;
        if (!this.isCompressed()) {
            if (this.f_107224_ < this.f_107225_) {
                int localAge;
                int n = localAge = this.f_107224_ % this.ticksForEachFrameDefault.length;
                int n2 = this.ticksForEachFrame[n];
                this.ticksForEachFrame[n] = n2 - 1;
                if (n2 <= 0) {
                    if (localAge == this.ticksForEachFrame.length - 1) {
                        this.resetFrames();
                    }
                    ++this.f_107224_;
                    if (this.f_107224_ < this.f_107225_) {
                        this.setLocalSprite(this.f_107224_ % this.ticksForEachFrameDefault.length);
                    }
                }
            } else {
                this.m_107274_();
            }
        } else if (this.f_107224_ >= this.f_107225_) {
            this.m_107274_();
        }
        this.m_6257_(this.f_107215_, this.f_107216_, this.f_107217_);
    }

    public void resetFrames() {
        this.ticksForEachFrame = (int[])this.ticksForEachFrameDefault.clone();
    }

    public void m_6257_(double x, double y, double z) {
        double d0 = x;
        double d1 = y;
        double d2 = z;
        if (this.f_107219_ && (x != 0.0 || y != 0.0 || z != 0.0)) {
            Vec3 vector3d = Entity.m_198894_(null, (Vec3)new Vec3(x, y, z), (AABB)this.m_107277_(), (Level)this.f_107208_, List.of());
            x = vector3d.f_82479_;
            y = vector3d.f_82480_;
            z = vector3d.f_82481_;
        }
        if (x != 0.0 || y != 0.0 || z != 0.0) {
            this.m_107259_(this.m_107277_().m_82386_(x, y, z));
            this.m_107275_();
        }
        this.onCeiling = d1 != y && d1 > 0.0;
        boolean bl = this.f_107218_ = d1 != y && d1 < 0.0;
        if (d0 != x) {
            this.f_107215_ = 0.0;
        }
        if (d2 != z) {
            this.f_107217_ = 0.0;
        }
    }

    public void m_5744_(VertexConsumer buffer, Camera renderInfo, float partialTicks) {
        float f4 = this.m_5902_(partialTicks);
        if (this.isCompressed() && this.f_107224_ < this.f_107225_) {
            float div = (float)this.maxTime / (float)this.compressedTime;
            int previousAge = this.f_107224_;
            this.f_107224_ = (int)Math.min(Math.min(((float)this.ticksPassed + partialTicks) * div, (float)this.maxTime), (float)this.f_107225_);
            if (this.f_107224_ != previousAge) {
                if (this.f_107224_ < this.f_107225_) {
                    int localAge = this.f_107224_ % this.ticksForEachFrameDefault.length;
                    if (localAge == 0) {
                        this.resetFrames();
                    }
                    int n = localAge;
                    int n2 = this.ticksForEachFrame[n];
                    this.ticksForEachFrame[n] = n2 - 1;
                    if (n2 <= 0) {
                        ++this.f_107224_;
                        if (this.f_107224_ < this.f_107225_) {
                            this.setLocalSprite(this.f_107224_ % this.ticksForEachFrameDefault.length);
                        }
                    }
                } else {
                    f4 = 0.0f;
                    this.m_107274_();
                }
            }
        }
        PoseStack poseStack = new PoseStack();
        this.handleRenderRotations(partialTicks, renderInfo);
        Vec3 vector3d = renderInfo.m_90583_();
        float f = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107209_, (double)this.f_107212_) - vector3d.m_7096_());
        float f1 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107210_, (double)this.f_107213_) - vector3d.m_7098_());
        float f2 = (float)(Mth.m_14139_((double)partialTicks, (double)this.f_107211_, (double)this.f_107214_) - vector3d.m_7094_());
        poseStack.m_85837_((double)f, (double)f1, (double)f2);
        poseStack.m_85845_(Vector3f.f_122225_.m_122240_(-this.yaw));
        poseStack.m_85845_(Vector3f.f_122223_.m_122240_(this.pitch));
        if (this.f_107231_ != 0.0f) {
            float roll = Mth.m_14179_((float)partialTicks, (float)this.f_107204_, (float)this.f_107231_);
            poseStack.m_85845_(Vector3f.f_122227_.m_122240_(roll));
        }
        this.preRender(poseStack, buffer, renderInfo, partialTicks);
        int j = this.m_6355_(partialTicks);
        Vector3f[] avector3f = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, -1.0f, 0.0f)};
        Vector3f[] avector3f1 = new Vector3f[]{new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(-1.0f, -1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f), new Vector3f(1.0f, 1.0f, 0.0f)};
        for (int i = 0; i < 4; ++i) {
            Vector3f vector3f = avector3f[i];
            vector3f.m_122249_(poseStack.m_85850_().m_85864_());
            vector3f.m_122261_(f4);
            vector3f.m_122272_(f, f1, f2);
            Vector3f vector3f0 = avector3f1[i];
            vector3f0.m_122249_(poseStack.m_85850_().m_85864_());
            vector3f0.m_122261_(f4);
            vector3f0.m_122272_(f, f1, f2);
        }
        float minU = this.m_5970_();
        float maxU = this.m_5952_();
        float minV = this.m_5951_();
        float maxV = this.m_5950_();
        buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[3].m_122239_(), (double)avector3f[3].m_122260_(), (double)avector3f[3].m_122269_()).m_7421_(minU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[2].m_122239_(), (double)avector3f[2].m_122260_(), (double)avector3f[2].m_122269_()).m_7421_(minU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[1].m_122239_(), (double)avector3f[1].m_122260_(), (double)avector3f[1].m_122269_()).m_7421_(maxU, minV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
        buffer.m_5483_((double)avector3f[0].m_122239_(), (double)avector3f[0].m_122260_(), (double)avector3f[0].m_122269_()).m_7421_(maxU, maxV).m_85950_(this.f_107227_, this.f_107228_, this.f_107229_, this.f_107230_).m_85969_(j).m_5752_();
    }

    public void preRender(PoseStack poseStack, VertexConsumer buffer, Camera renderInfo, float partialTicks) {
    }

    public void handleRenderRotations(float partialTicks, Camera info) {
        this.yaw = this.prevYaw = info.m_90590_();
        this.pitch = this.prevPitch = info.m_90589_();
    }

    public final void setSpriteGroup(SpriteGroup group) {
        this.sprites = group;
    }

    public final void m_108339_(SpriteSet spriteSet) {
        super.m_108339_(spriteSet);
    }

    protected final void setLocalSprite(int index) {
        this.f_108321_ = this.sprites.fetch(index);
    }

    public void setTicksForEachFrame(int ... ticks) {
        int[] frameTicks = new int[this.f_107225_];
        for (int i = 0; i < ticks.length; ++i) {
            frameTicks[i] = ticks[i];
            this.maxTime += ticks[i];
        }
        this.ticksForEachFrameDefault = frameTicks;
        this.resetFrames();
    }

    public void setSimpleFrameTicks() {
        int size = this.sprites.size();
        int[] frameTicks = new int[size];
        for (int i = 0; i < size; ++i) {
            frameTicks[i] = 1;
        }
        this.maxTime = this.f_107225_;
        this.ticksForEachFrameDefault = frameTicks;
        this.resetFrames();
    }

    public void setSimpleFrameTicks(int spriteTicks) {
        int size = this.sprites.size();
        int[] frameTicks = new int[size];
        for (int i = 0; i < size; ++i) {
            frameTicks[i] = spriteTicks;
        }
        this.maxTime = this.f_107225_ * spriteTicks;
        this.ticksForEachFrameDefault = frameTicks;
        this.resetFrames();
    }

    protected void setDefaultSize(float size) {
        this.defaultSize = size;
        this.f_107663_ = size;
    }

    protected void setCompressed(int toTicks) {
        this.compressedTime = toTicks;
    }

    public int[] getTicksForEachFrame() {
        return this.ticksForEachFrame;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107432_;
    }

    public float getDefaultSize() {
        return this.defaultSize;
    }

    private boolean isCompressed() {
        return this.compressedTime > 0;
    }

    public boolean shouldCull() {
        return true;
    }
}

