/*
 * Decompiled with CFR 0.152.
 */
package bottomtextdanny.braincell.mod.world.builtin_items;

import bottomtextdanny.braincell.Braincell;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SpawnerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class BCSpawnEggItem
extends SpawnEggItem {
    public static final SpawnLogic DEFAULT_LOGIC = (type, world, direction, blockPos, itemStack, player) -> {
        BlockState blockState = world.m_8055_(blockPos);
        BlockPos blockPos1 = blockState.m_60812_((BlockGetter)world, blockPos).m_83281_() ? blockPos : blockPos.m_142300_(direction);
        if (type.m_20592_((ServerLevel)world, itemStack, player, blockPos1, MobSpawnType.SPAWN_EGG, true, !Objects.equals(blockPos, blockPos1) && direction == Direction.UP) != null) {
            itemStack.m_41774_(1);
        }
    };
    private final Supplier<? extends EntityType<? extends Mob>> typeSupplier;
    private final SpawnLogic spawnLogic;
    private final boolean unstable;

    public BCSpawnEggItem(int firstTint, int secondTint, boolean unstable, SpawnLogic logic, Supplier<? extends EntityType<? extends Mob>> typeSupplier, Item.Properties properties) {
        super(null, firstTint, secondTint, properties);
        Braincell.common().getEntityCoreDataDeferror().putEgg(this);
        this.typeSupplier = typeSupplier;
        this.spawnLogic = logic;
        this.unstable = unstable;
    }

    public static Builder createBuilder(int firstTint, int secondTint) {
        return new Builder(firstTint, secondTint);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tileentity;
        Level world = context.m_43725_();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        ItemStack itemstack = context.m_43722_();
        BlockPos blockpos = context.m_8083_();
        Direction direction = context.m_43719_();
        BlockState blockstate = world.m_8055_(blockpos);
        if (blockstate.m_60713_(Blocks.f_50085_) && (tileentity = world.m_7702_(blockpos)) instanceof SpawnerBlockEntity) {
            SpawnerBlockEntity spawner = (SpawnerBlockEntity)tileentity;
            BaseSpawner abstractspawner = spawner.m_59801_();
            EntityType<? extends Mob> entitytype1 = this.m_43228_(itemstack.m_41783_());
            abstractspawner.m_45462_(entitytype1);
            tileentity.m_6596_();
            world.m_7260_(blockpos, blockstate, blockstate, 3);
            itemstack.m_41774_(1);
            return InteractionResult.CONSUME;
        }
        this.spawnLogic.forSpawn(this.m_43228_(itemstack.m_41783_()), world, direction, blockpos, itemstack, context.m_43723_());
        return InteractionResult.CONSUME;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, Player playerIn, InteractionHand handIn) {
        ItemStack itemstack = playerIn.m_21120_(handIn);
        BlockHitResult raytraceresult = BCSpawnEggItem.m_41435_((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.SOURCE_ONLY);
        if (raytraceresult.m_6662_() != HitResult.Type.BLOCK) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (!(worldIn instanceof ServerLevel)) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        BlockHitResult blockraytraceresult = raytraceresult;
        BlockPos blockpos = blockraytraceresult.m_82425_();
        if (!worldIn.m_8055_(blockpos).m_60819_().m_76170_()) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        if (worldIn.m_7966_(playerIn, blockpos) && playerIn.m_36204_(blockpos, blockraytraceresult.m_82434_(), itemstack)) {
            this.spawnLogic.forSpawn(this.m_43228_(itemstack.m_41783_()), worldIn, blockraytraceresult.m_82434_(), blockpos, itemstack, playerIn);
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public EntityType<? extends Mob> m_43228_(@Nullable CompoundTag p_208076_1_) {
        return this.typeSupplier.get();
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (this.unstable) {
            tooltip.add((Component)new TranslatableComponent("description.braincell.unstable").m_6270_(Style.f_131099_.m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.RED)).m_131136_(Boolean.valueOf(true))));
        }
    }

    @FunctionalInterface
    public static interface SpawnLogic {
        public void forSpawn(EntityType<?> var1, Level var2, Direction var3, BlockPos var4, ItemStack var5, Player var6);
    }

    public static final class Builder {
        private final int firstTint;
        private final int secondTint;
        private short sort = (short)-1;
        private boolean unstable;
        private SpawnLogic logic = DEFAULT_LOGIC;
        private Item.Properties properties;
        private Supplier<? extends EntityType<? extends Mob>> typeSupplier;

        private Builder(int firstTint, int secondTint) {
            this.firstTint = firstTint;
            this.secondTint = secondTint;
        }

        public Builder unstable() {
            this.unstable = true;
            return this;
        }

        public Builder sorted(short sortValue) {
            this.sort = sortValue;
            return this;
        }

        public Builder setLogic(SpawnLogic logic) {
            this.logic = logic;
            return this;
        }

        public Builder setTypeSupplier(Supplier<? extends EntityType<? extends Mob>> typeSupplier) {
            this.typeSupplier = typeSupplier;
            return this;
        }

        public Builder properties(Item.Properties properties) {
            this.properties = properties;
            return this;
        }

        public BCSpawnEggItem build() {
            return new BCSpawnEggItem(this.firstTint, this.secondTint, this.unstable, this.logic, this.typeSupplier, this.properties);
        }

        public short getSort() {
            return this.sort;
        }
    }
}

